	
	function DBSLogin(){
		var RSA_PARAM_E = "3";
		var publickey;
		
	
	
	this.getPublickey =function(publickey){
		this.publickey = publickey;
	}

//-----------------------------------------------------------------
	// RSA_EncryptPIN
	// This function uses RSA to encrypt the PIN entered by the user.
	// randomValue - (I) Value of hidden HTML field received from server
	// PINValue - (I) Value of HTML field, containing the PIN entered 
	//				by the user
	// Return - A 128 byte block which is the result of RSA encryption of:
	//			1 byte  - PIN length+128 
	//			8 bytes - PIN Padded by 0xFF 
	//			8 bytes - Random session value from server
	//		  111 bytes - Buffer filled with random numbers generated by applet
	//-----------------------------------------------------------------

	this.RSA_EncryptPIN = function( randomValue,  PINValue){
		
		var encBuff ;
		var dataBlk;
		var randHexStr =randomValue;
		
		if (PINValue.length <= 9)
			
		dataBlk = "0"+PINValue.length;
		else
			
		dataBlk = "0"+9;
		
		var pinBlock=formatPIN(PINValue);
		dataBlk += Util.toHexString(pinBlock);
		dataBlk += randHexStr;
		//console.log("dataBlk = "+dataBlk);
		
		var pubkey = this.publickey;
				
		var rsa = null;
		 if (pubkey == null || RSA_PARAM_E == null) throw "101";
		 try{
			 rsa = new RSAKey();
		 } catch (e){throw "102";}
		
		 rsa.setPublic(pubkey, RSA_PARAM_E);
		
		try {
			
  			
			encBuff = rsa.encrypt(new BigInteger(Util.fromHexString(dataBlk)));
			
		} catch (e) {
			throw "100"; // errorcode"100" = get exception when encrypt data
			}

	
		return encBuff;


	}
//-----------------------------------------------------------------
	// RSA_EncryptPIN_change
	// This function uses RSA to encrypt the old PIN and new PIN for 
	// change password operation.
	// randomValue - (I) Value of hidden HTML field received from server
	// oldPIN - (I) Value of HTML field, containing the old PIN.
	// newPIN - (I) Value of HTML field, containing the new PIN.
	// Return - A 128 byte block which is the result of RSA encryption of:
	//			1 byte  - old PIN length+128 
	//			8 bytes - old PIN Padded by 0xFF 
	//			8 bytes - Random session value from server
	//			1 byte  - new PIN length
	//			8 bytes - new PIN Padded by 0xFF 
	//		  102 bytes - Buffer filled with random numbers generated by applet
	//-----------------------------------------------------------------

this.RSA_EncryptPIN_Change = function( randomValue, 
										 oldPIN,  newPIN){
	var rndValue = new Array();
	var encBuff ;
	var dataBlk;
	var randHexStr =randomValue;
	
	if (oldPIN.length <= 9)
			dataBlk = "0"+oldPIN.length;
		else
			dataBlk = "0"+9;
	var pinBlock=formatPIN(oldPIN);
	dataBlk += Util.toHexString(pinBlock);
	dataBlk += randHexStr;
	if (newPIN.length <= 9)
			dataBlk += "0"+newPIN.length;
		else
			dataBlk += "0"+9;
	var newpinBlock=formatPIN(newPIN);
	dataBlk += Util.toHexString(newpinBlock);

	//console.log("dataBlk = "+dataBlk);
		
		var pubkey = this.publickey;
				
		var rsa = null;
		 if (pubkey == null || RSA_PARAM_E == null) throw "101";
		 try{
			 rsa = new RSAKey();
		 } catch (e){throw "102";}
		
		 rsa.setPublic(pubkey, RSA_PARAM_E);
		
		try {
			
  			
			encBuff = rsa.encrypt(new BigInteger(Util.fromHexString(dataBlk)));
			
		} catch (e) {
			throw "100"; // errorcode"100" = get exception when encrypt data
			}

	
		return encBuff;

}


 //-----------------------------------------------------------------
	// formatPIN
	// Format PIN value into an 8 byte array by padding it with 0xff
//-----------------------------------------------------------------
function formatPIN(PINval){

	var PadLen = 8;
	var pad = new Array();
	var i, h, l;
	for (i=0; i<PadLen ;i++ )
	{
		pad[i]=0xff;
		
	}
	for (i=0;i<PINval.length && i<9 ; i++ )
	{
		
		var dec = PINval.charCodeAt(i);
		
		h=dec % 16;
		
			if (i%2 == 0){
				pad[i/2]=(pad[i/2] & (h * 16 + 0x0f));
				
			}
			else{
				var j = Math.floor(i/2);
				
				pad[j]=(pad[j] & (h | 0xf0));
				
			}
	}

	return pad;
}
	
}