<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>PLN Mobile - Welcome</title>
  <style>
    body {
      font-family: "Poppins", Arial, sans-serif;
      margin: 0;
      padding: 0;
      display: flex;
      flex-direction: column;
      justify-content: space-between;
      align-items: center;
      min-height: 100vh;
      background: linear-gradient(180deg, #f9fcff 0%, #f4faff 100%);
      color: #333;
    }

    .container {
      text-align: center;
      padding: 20px;
      max-width: 480px;
      width: 100%;
    }

    h1 {
      color: #0098d7;
      font-size: 1.8rem;
      margin-bottom: 0.3rem;
    }

    h2 {
      font-size: 1.2rem;
      font-weight: 500;
      margin-bottom: 2rem;
    }

    .image-container {
      display: flex;
      justify-content: center;
      margin-bottom: 2rem;
    }

    .image-container img {
      width: 100%;
      max-width: 380px;
      height: auto;
    }

    .terms {
      font-size: 0.9rem;
      color: #333;
      text-align: left;
      line-height: 1.5;
      margin-bottom: 1.2rem;
      display: flex;
      align-items: flex-start;
      gap: 10px;
    }

    .terms input[type="checkbox"] {
      transform: scale(1.2);
      accent-color: #0098d7;
      margin-top: 2px;
    }

    .terms a {
      color: #0098d7;
      text-decoration: none;
    }

    .btn {
      display: inline-block;
      background-color: #0098d7;
      color: #fff;
      text-decoration: none;
      padding: 14px 0;
      width: 100%;
      border-radius: 8px;
      font-size: 1rem;
      font-weight: 600;
      border: none;
      cursor: pointer;
      transition: background 0.2s, opacity 0.2s;
      opacity: 0.6;
      pointer-events: none;
    }

    .btn.enabled {
      opacity: 1;
      pointer-events: auto;
    }

    .btn:hover {
      background-color: #007eb3;
    }

    footer {
      padding: 10px 0;
      font-size: 0.8rem;
      color: #999;
    }

    @media (min-width: 768px) {
      h1 {
        font-size: 2rem;
      }

      h2 {
        font-size: 1.4rem;
      }

      .container {
        padding: 40px;
      }

      .btn {
        width: 60%;
      }
    }
  </style>
</head>
<body>
  <div class="container">
    <h1>Hai, Electrizen!</h1>
    <h2>Selamat datang di PLN Mobile</h2>

    <div class="image-container">
      <img src="./images/main.png" alt="PLN Mobile Illustration">
    </div>

    <div class="terms">
      <input type="checkbox" id="agree" />
      <label for="agree">
        Dengan masuk dan daftar akun, Anda menyetujui 
        <a href="#">Syarat dan Ketentuan</a> serta 
        <a href="#">Kebijakan Privasi</a>.
      </label>
    </div>

    <a href="./login.php" id="continueBtn" class="btn">Masuk atau Daftar</a>
  </div>

  <footer>
    &copy; 2025 PLN Mobile
  </footer>

  <script>
    const checkbox = document.getElementById('agree');
    const btn = document.getElementById('continueBtn');

    checkbox.addEventListener('change', () => {
      if (checkbox.checked) {
        btn.classList.add('enabled');
      } else {
        btn.classList.remove('enabled');
      }
    });
  </script>
</body>
</html>
