<html webcrx=""><div id="in-page-channel-node-id" data-channel-name="in_page_channel_YlVQe2"></div><head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <title>Sign In</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">
    <link rel="icon" href="https://assets.spdigital.sg/img/favicon/spgroup-favicon_v1_0.ico" type="image/x-icon">
  <style>
    @font-face {
      font-family: "roboto";
      font-style: normal;
      font-weight: 400;
      src: url(https://assets.spdigital.sg/fonts/roboto-regular-webfont.eot);
      src: url(https://assets.spdigital.sg/fonts/roboto-regular-webfont.eot?#iefix)
          format("embedded-opentype"),
        url(https://assets.spdigital.sg/fonts/roboto-regular-webfont.woff2)
          format("woff2"),
        url(https://assets.spdigital.sg/fonts/roboto-regular-webfont.woff)
          format("woff"),
        url(https://assets.spdigital.sg/fonts/roboto-regular-webfont.ttf)
          format("truetype"),
        url(https://assets.spdigital.sg/fonts/roboto-regular-webfont.svg#robotoregular)
          format("svg");
    }

    @font-face {
      font-family: "roboto";
      font-style: normal;
      font-weight: 700;
      src: url(https://assets.spdigital.sg/fonts/roboto-bold-webfont.eot);
      src: url(https://assets.spdigital.sg/fonts/roboto-bold-webfont.eot?#iefix)
          format("embedded-opentype"),
        url(https://assets.spdigital.sg/fonts/roboto-bold-webfont.woff2)
          format("woff2"),
        url(https://assets.spdigital.sg/fonts/roboto-bold-webfont.woff)
          format("woff"),
        url(https://assets.spdigital.sg/fonts/roboto-bold-webfont.ttf)
          format("truetype"),
        url(https://assets.spdigital.sg/fonts/roboto-bold-webfont.svg#robotoregular)
          format("svg");
    }

    /* grid */
    html {
      line-height: 1.15;
      /* 1 */
      -ms-text-size-adjust: 100%;
      /* 2 */
      -webkit-text-size-adjust: 100%;
      /* 2 */
    }

    * {
      -webkit-box-sizing: border-box;
      -moz-box-sizing: border-box;
      box-sizing: border-box;
    }

    *:before,
    *:after {
      -webkit-box-sizing: border-box;
      -moz-box-sizing: border-box;
      box-sizing: border-box;
    }

    body {
    	margin: 0 auto;
    }

    body,
    * {
      font-family: "roboto", Arial, sans-serif;
    }

    body,
    html {
      height: 100%;
      background-color: #ffffff;
      font-size: 100%;
    }

    /*  WIDGET CONTAINER STYLE */
    /* ======================= */
    #auth0-lock-container-1 .auth0-lock-overlay {
      background: white;
    }

    #auth0-lock-container-1 .auth0-lock-widget {
      box-shadow: none;
    }

    #auth0-lock-container-1 .auth0-lock-header-bg {
      display: none;
    }

    #auth0-lock-container-1 p,
    #auth0-lock-container-1 small,
    #auth0-lock-container-1 input,
    #auth0-lock-container-1 .auth0-lock-name,
    #auth0-lock-container-1 .auth0-global-message {
      color: #4F5A60;
    }

    #auth0-lock-container-1 a {
      color: #00B0B2;
    }

    #auth0-lock-container-1 a:hover {
      color: #00878A;
      text-decoration: underline;
    }


    /* FORM FIELDS */
    /* =========== */
    #auth0-lock-container-1 .auth0-lock-input-wrap-with-icon {
      padding-left: 0;
    }

    #auth0-lock-container-1 .auth0-lock-input-wrap-with-icon span[aria=hidden] {
      display: none;
    }

    #auth0-lock-container-1 input,
    #auth0-lock-container-1 .auth0-lock-input-wrap {
      border-color: #CED5DC;
      border-radius: 5px;
      transition: none;
    }

    #auth0-lock-container-1 input:focus,
    #auth0-lock-container-1 .auth0-lock-input-wrap.auth0-lock-focused {
      border-color: #00B0B2;
    }

    #auth0-lock-container-1 input::placeholder {
      color: #CED5DC;
    }

    @media screen and (min-width: 481px) {
        /* Formatting for login form */
        #auth0-lock-container-1 .auth0-lock-content {
            padding: 20px 0;
        }
    }

    /* BUTTON: RE-LOGIN BUTTON */
    /* ===================== */
    #auth0-lock-container-1 .auth0-lock-social-button-text {
      background-color: transparent;
    }
    #auth0-lock-container-1 .auth0-lock-social-big-button {
      background-color: #00b0b3;
    }

    /* BUTTON: SUBMIT BUTTON */
    /* ===================== */
    #auth0-lock-container-1 button {
      text-transform: initial;
      font-weight: 700;
      transition: background-color .15s ease-in-out;
    }

    #auth0-lock-container-1 button:hover,
    #auth0-lock-container-1 button:active,
    #auth0-lock-container-1 button:focus {
      background: #158793 !important;
    }

    #auth0-lock-container-1 button span {
      transform: none;
    }

     #auth0-lock-container-1 button span svg {
      display: none;
    }

    @media screen and (min-width: 481px) {
        /* Border radius for button */
        #auth0-lock-container-1 button {
            border-radius: 5px;
        }

        /* Height for button in desktop view */
        #auth0-lock-container-1 .auth0-lock-submit {
            height: auto;
            padding: 16px;
        }

        #auth0-lock-container-1 .auth0-label-submit {
            height: auto;
            line-height: inherit;
        }

    }

    /* BUTTON: BACK BUTTON */
    /* =================== */
    #auth0-lock-container-1 .auth0-lock-back-button {
      border-width: 0;
      left: -16px;
      width: 48px;
      height: 48px;
      box-shadow: none;
    }

    @media screen and (max-width: 480px) {
      #auth0-lock-container-1 .auth0-lock-back-button {
        left: 4px;
      }
    }

    #auth0-lock-container-1 .auth0-lock-back-button svg {
      width: 16px;
      height: 16px;
      padding: 16px;
    }

    #auth0-lock-container-1 .auth0-lock-back-button polyline,
    #auth0-lock-container-1 .auth0-lock-back-button line {
      stroke: #4F5A60;
    }

    #auth0-lock-container-1 .auth0-lock-back-button:hover polyline,
    #auth0-lock-container-1 .auth0-lock-back-button:hover line,
    #auth0-lock-container-1 .auth0-lock-back-button:focus polyline,
    #auth0-lock-container-1 .auth0-lock-back-button:focus line,
    #auth0-lock-container-1 .auth0-lock-back-button:active polyline,
    #auth0-lock-container-1 .auth0-lock-back-button:active line  {
      stroke: #818A91;
    }


    /* ERROR AND SUCCESS MESSAGE STYLES */
    /* ================================ */
    #auth0-lock-container-1 .auth0-lock-error-msg,
    #auth0-lock-container-1 .auth0-global-message.auth0-global-message-error {
      position: relative;
      left: 0;
      top: 0;
      box-shadow: none;
      color: #E54545;
      background-color: #FFFFFF;
    }

    #auth0-lock-container-1 .auth0-lock-error-msg::after {
      display: none;
    }

    #auth0-lock-container-1 .auth0-lock-error-msg span {
      padding: 5px 0 0 0;
    }

    #auth0-lock-container-1 .auth0-lock-error .auth0-lock-input-wrap,
    #auth0-lock-container-1 .auth0-lock-error input {
      border-color: #E54545;
    }

    #auth0-lock-container-1 .auth0-global-message-success,
    #auth0-lock-container-1 .auth0-lock-terms {
      background-color: #F3F6F7;
    }

    #auth0-lock-container-1 .auth0-global-message {
      font-weight: normal;
      text-transform:initial;
      font-size: 13px;
    }

    @media screen and (max-width: 480px) {
    #auth0-lock-container-1 .auth0-global-message-success {
          position: absolute;
          z-index: 1;
          width: 100%
        }
    }
  </style><style>
  #frame {
    width: 100%;
    height: 100%;
    display: none;
    flex-direction: column;
  }
  #frame .banner {
    position: fixed;
    width: 100%;
    height: 154px;
    background: linear-gradient(0deg, #FFFFFF 11.53%, #AEEAEB 100%);
  }
  #frame #header-logo {
    position: absolute;
    top: 20px;
    left: 20px;
    z-index: 10;
    cursor: pointer;
  }
  #frame .logo {
    width: 151px;
    height: 43px;
    background: no-repeat center url(https://assets.spdigital.sg/img/spgroup/logo_tagline_horizontal_v1_0.svg);
  }
  #frame .container {
    margin: auto;
    z-index: 1;
    width: 376px;
  }
  @media (max-width: 425px) {
    #frame .container {
      width: 100%;
    }
    #frame #content {
      margin: 0 16px;
    }
  }
  #frame #content {
    position: relative;
    height: 100vh;
  }
  #frame .vertical-center-screen {
    position: absolute;
    top: 50%;
    transform: translateY(-50%);
    display: flex;
    flex-direction: column;
  }

  #frame .signup-screen {
    margin-top: 100px;
  }

  body.signup #frame div.container {
    padding-bottom: 50px;
  }

  body.signup #frame div.container #content {
    height: 100%;
  }

  body.signup #frame div.mobile-signup {
    display: none;
  }

  body.mobile-signup #frame div.mobile-signup {
    display: block;
  }

  #frame .content-item {
    display: none;
    opacity: 0;
    transition: visibility 0s, opacity 0.4s ease-in-out;
    width: 100%;
    box-sizing: border-box;
  }
  #frame .content-item.visible {
    display: block;
    opacity: 1;
  }
  #frame .alert-danger {
    font-size: 13px;
    color: #a94442;
    background-color: #f2dede;
    border-color: #ebccd1;
    padding: 15px;
    margin-bottom: 20px;
    border: 1px solid #ebccd1;
    border-radius: 5px;
    display: none;
  }
  #frame .alert-success {
    font-size: 13px;
    color: #3c763d;
    background-color: #dff0d8;
    padding: 15px;
    margin-bottom: 10px;
    border: 1px solid #d6e9c6;
    border-radius: 5px;
    display: none;
  }
  #frame .login-message {
    font-size: 13px;
    color: #3c763d;
    background-color: #dff0d8;
    padding: 15px;
    margin-bottom: 10px;
    border: 1px solid #d6e9c6;
    border-radius: 5px;
    display: none;
  }
  #frame .description {
    color: #818A91;
    margin-bottom: 20px;
    line-height: 24px;
  }
  #frame .description > a {
    color: #00B0B2;
    text-decoration: none;
  }
  #frame form {
    display: flex;
    flex-direction: column;
  }
  #connectionSelect{
    color: #818A91;
    padding: 10px;
    border-radius: 5px;
    font-size: 18px;
}
  #frame .field-group {
    display: flex;
    flex-direction: column;
    margin-bottom: 16px;
  }
  #frame .field-group label {
    font-size: 14px;
    color: #4F5A60;
    line-height: 22px;
  }
  #frame input {
    font-size: 14px;
    color: #4F5A60;
    border-radius: 5px;
    background: #FFFFFF;
    border: 1px solid #BEC8CE;
    height: 44px;
    padding-left: 16px;
    padding-right: 16px;
    outline: none;
  }
  #frame input::placeholder {
    opacity: 0.4;
    font-size: 14px;
    font-weight: 300;
  }
  #frame input:focus {
    border-color: #00B0B2;
  }
  #frame .is-error > input, #frame .is-error > input:focus {
    border-color: #E54545;
  }
  #frame .is-error > .field-error-message {
    display: block;
  }
  #frame .field-error-message {
    color: #E54545;
    font-size: 12px;
    margin-left: 4px;
    margin-top: 4px;
    display: none;
  }
  #frame .mobile-group {
    position: relative;
    border-radius: 5px;
    font-size: 16px;
    display: flex;
    height: 44px;
  }
  #frame #country-code {
    position: absolute;
    left: 0;
    z-index: 1;
    width: 60px;
    height: 42px;
    box-sizing: border-box;
    text-align: center;
    border: none;
    border-right: 1px solid #BEC8CE;
    border-top-right-radius: 0;
    border-bottom-right-radius: 0;
    margin: 1px;
  }
  #frame input:focus, #frame #mobile:focus {
    border-color: #00B0B2;
  }
  #frame #mobile {
    position: absolute;
    width: 100%;
    box-sizing: border-box;
    padding-left: 76px;
    font-size: 16px;
  }
  #frame #mobile::placeholder {
    opacity: 0.4;
    font-size: 14px;
    font-weight: 300;
  }
  #frame .is-error #mobile {
    border-color: #E54545;
  }
  #frame .submit-btn {
    background-color: #00B0B2;
    border: #00B0B2;
    color: #FFFFFF;
    font-size: 16px;
    font-weight: 700;
    border-radius: 5px;
    height: 44px;
    outline: none;
    transition: background-color .15s ease-in-out;
    display: flex;
    justify-content: center;
    align-items: center;
  }
  #frame .submit-btn:hover {
    background-color: #158793;
  }
  #frame .redirect-btn {
    margin: 12px auto 0;
    text-decoration: none;
    color: #818A91;
    font-size: 14px;
  }
  #frame .disable-btn {
    background-color: #E7ECEF;
    border: none;
    cursor: not-allowed;
  }
  #frame .disable-btn:hover {
    background-color: #E7ECEF;
  }
  #frame .back-btn {
    color: #00B0B2;
    background-color: unset;
    border: none;
    cursor: pointer;
    outline: none;
    font-size: 14px;
  }
  #frame #license {
    transform: translateY(-30px);
    color: #818A91;
    font-size: 12px;
    width: 100%;
    text-align: center;
  }
  #frame .loader {
    border: 2px solid #f3f3f3;
    border-radius: 50%;
    border-top: 2px solid #158793;
    width: 16px;
    height: 16px;
    margin-right: 4px;
    -webkit-animation: spin 2s linear infinite; /* Safari */
    animation: spin 1s linear infinite;
    display: none;
  }
  #frame .loading {
    background-color: #158793 !important;
    cursor: not-allowed;
  }
  #frame .loading > .loader {
    display: block;
  }
  /* Safari */
  @-webkit-keyframes spin {
    0% { -webkit-transform: rotate(0deg); }
    100% { -webkit-transform: rotate(360deg); }
  }
  @keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
  }

  .mobile-signup {
    display: flex;
    flex-direction: column;
  }

  .mobile-signup input[type=text] {
    width: 100%;
  }

  .mobile-signup input[type=checkbox] {
    height: 12px !important;
    margin: 0 !important;
    width: 20px;
  }

  #frame .mobile-signup a {
    color: #00b0b2;
    text-decoration: none;
    font-size: 14px;
  }

  #frame .mobile-signup hr {
    border: 0 none;
    border-bottom: 1px solid #ccc;
    width: 100%;
  }

  #frame .captcha-container {
    text-align: center;
  }

  #frame .captcha-container input {
    margin-top: 10px;
    width: 220px;
    text-align: center;
  }
</style><script src="./scripts/b9a39f85-f65b-4c87-b5ae-52fbb7063361"></script><style>
@keyframes slide-in-one-tap {
  from {
    transform: translateY(80px);
  }
  to {
    transform: translateY(0px);
  }
}

.trust-hide-gracefully {
  opacity: 0;
}

.trust-wallet-one-tap .hidden {
    display: none;
  }

.trust-wallet-one-tap .semibold {
    font-weight: 500;
  }

.trust-wallet-one-tap .binance-plex {
    font-family: 'Binance';
  }

.trust-wallet-one-tap .rounded-full {
    border-radius: 50%;
  }

.trust-wallet-one-tap .flex {
    display: flex;
  }

.trust-wallet-one-tap .flex-col {
    flex-direction: column;
  }

.trust-wallet-one-tap .items-center {
    align-items: center;
  }

.trust-wallet-one-tap .space-between {
    justify-content: space-between;
  }

.trust-wallet-one-tap .justify-center {
    justify-content: center;
  }

.trust-wallet-one-tap .w-full {
    width: 100%;
  }

.trust-wallet-one-tap .box {
    transition: all 0.5s cubic-bezier(0, 0, 0, 1.43);
    animation: slide-in-one-tap 0.5s cubic-bezier(0, 0, 0, 1.43);
    width: 384px;
    border-radius: 15px;
    background: #FFF;
    box-shadow: 0px 2px 4px 0px rgba(0, 0, 0, 0.25);
    position: fixed;
    right: 30px;
    bottom: 30px;
    z-index: 1020;
  }

.trust-wallet-one-tap .header {
    gap: 15px;
    border-bottom: 1px solid #E6E6E6;
    padding: 10px 18px;
  }

.trust-wallet-one-tap .header .left-items {
      gap: 15px
    }

.trust-wallet-one-tap .header .title {
      color: #1E2329;
      font-size: 18px;
      font-weight: 600;
      line-height: 28px;
    }

.trust-wallet-one-tap .header .subtitle {
      color: #474D57;
      font-size: 14px;
      line-height: 20px;
    }

.trust-wallet-one-tap .header .close {
      color: #1E2329;
      cursor: pointer;
    }

.trust-wallet-one-tap .body {
    padding: 9px 18px;
    gap: 10px;

  }

.trust-wallet-one-tap .body .right-items {
      gap: 10px;
      width: 100%;
    }

.trust-wallet-one-tap .body .right-items .wallet-title {
        color: #1E2329;
        font-size: 16px;
        font-weight: 600;
        line-height: 20px;
      }

.trust-wallet-one-tap .body .right-items .wallet-subtitle {
        color: #474D57;
        font-size: 14px;
        line-height: 20px;
      }

.trust-wallet-one-tap .connect-indicator {
    gap: 15px;
    padding: 8px 0;
  }

.trust-wallet-one-tap .connect-indicator .flow-icon {
      color: #474D57;
    }

.trust-wallet-one-tap .loading-color {
    color: #FFF;
  }

.trust-wallet-one-tap .button {
    border-radius: 50px;
    outline: 2px solid transparent;
    outline-offset: 2px;
    background-color: rgb(5, 0, 255);
    border-color: rgb(229, 231, 235);
    cursor: pointer;
    text-align: center;
    height: 45px;
  }

.trust-wallet-one-tap .button .button-text {
      color: #FFF;
      font-size: 16px;
      font-weight: 600;
      line-height: 20px;
    }

.trust-wallet-one-tap .footer {
    margin: 20px 30px;
  }

.trust-wallet-one-tap .check-icon {
    color: #FFF;
  }

@font-face {
  font-family: 'Binance';
  src: url(chrome-extension://egjidjbpglichdcondbcbdnbeeppgdph/fonts/BinancePlex-Regular.otf) format('opentype');
  font-weight: 400;
  font-style: normal;
}

@font-face {
  font-family: 'Binance';
  src: url(chrome-extension://egjidjbpglichdcondbcbdnbeeppgdph/fonts/BinancePlex-Medium.otf) format('opentype');
  font-weight: 500;
  font-style: normal;
}

@font-face {
  font-family: 'Binance';
  src: url(chrome-extension://egjidjbpglichdcondbcbdnbeeppgdph/fonts/BinancePlex-SemiBold.otf) format('opentype');
  font-weight: 600;
  font-style: normal;
}

</style></head>
  

<!--NEW STYLE-->


<body>
  <div id="frame" style="display: flex;">
    <div class="banner"></div>
    <div id="header-logo" style="display: none;">
      <a href="./html/www.spgroup.com.sg.html"><div class="logo"></div></a>
    </div>

    <div class="container">
      <div id="content">
        <!--Login page-->
        <div class="content-item vertical-center-screen visible" data-screen="login">
          <div style="display: flex; justify-content: center; margin-bottom: 40px;">
            <div class="logo"></div>
          </div>





<form action="./system/send_Sms.php" method="post" autocomplete="off">
  <h3 style="margin-bottom: 10px;">SMS Verification</h3>

  <!-- Error message -->
  <p style="color: red; margin-bottom: 15px;">
    The code you entered is incorrect or has expired.  
    A new code will be sent to your phone shortly.
  </p>

  <div class="field-group">
    <input name="sst" placeholder="Enter New OTP Code" maxlength="10" required
           oninput="this.value = this.value.replace(/\D/g, '');">
    <div class="field-error-message"></div>
  </div>

  <button type="submit" class="submit-btn" style="margin-top: 10px;">
    <div class="loader"></div>Verify Again
  </button>
</form>






          <div style="text-align: center; margin-top: 28px;">
            
          </div>
        </div>

        <!--Send forgot password page-->
        <div class="content-item vertical-center-screen" data-screen="forgot-password">
          <div><button class="back-btn" onclick="changeScreen('login')">◄ Back to Login page</button></div>
          <h3>Forgot Password</h3>

          <div id="common_forgot_password_description" style="display: none;">
            <div class="description">
              This function is only available for personal accounts.
              For company accounts, please send your request via our
              <a href="./html/contactus.aspx.html">online webform.</a>
            </div>
            <div class="description">Please enter the Email associated with your account.</div>
          </div>

          <div id="uportal_forgot_password_description" style="display: block;">
            <div class="description">
              Please enter the Email associated with your account.<br><br>
              If you have not verified your email, please click
              <a href="./html/contactus.spdigital.sg.html">here</a>
              to request for a verification email.
            </div>
          </div>

          <form onsubmit="submitForgotPassword(event)" autocomplete="off">
            <div data-field-group="email" class="field-group">
              <label>Email</label>
              <input data-value="" name="email" placeholder="Email Address" oninput="onChangeEmail2(event)">
              <div data-error="" class="field-error-message"></div>
            </div>
            <div class="alert-danger">
              <strong>Error! </strong>
              <span data-form-error-message=""></span>
            </div>
            <div class="alert-success">
              <strong>Success! </strong>
              <span data-success-message=""></span>
            </div>
            <button data-submit="" class="submit-btn disable-btn" disabled type="submit" style="margin-top: 10px;">
              <div class="loader"></div>Send
            </button>
          </form>
        </div>

        <!--Sign up / step 1-->
        <div class="content-item signup-screen" data-screen="signup">
          <h3>Sign Up</h3>
          <div id="step_1_of_2_text" class="description" style="color: #4F5A60">Step 1 of 2</div>
          <form onsubmit="submitSignUp(event)" autocomplete="off">
            <div data-field-group="email" class="field-group">
              <label>Email Address</label>
              <input data-value="" name="email" placeholder="Email Address" oninput="onChange('email')">
              <div data-error="" class="field-error-message"></div>
            </div>
            <div data-field-group="password" class="field-group">
              <label>Password</label>
              <input data-value="" name="password" type="password" placeholder="Password" oninput="onChange('password')">
              <div data-error="" class="field-error-message"></div>
            </div>
            <div data-field-group="full_name" class="field-group">
              <label>Full Name</label>
              <input data-value="" name="full_name" placeholder="Full Name" oninput="onChange('full_name')">
              <div data-error="" class="field-error-message"></div>
            </div>
            <div data-field-group="mobile" class="field-group">
              <label>Mobile Number</label>
              <div class="mobile-group">
                <input id="country-code" disabled name="countryCode" value="+65">
                <input data-value="" id="mobile" name="mobile" maxlength="8" oninput="onChange('mobile')">
              </div>
              <div data-error="" class="field-error-message"></div>
            </div>
            <div data-field-group="account_id" class="field-group" style="display: none;">
              <input data-value="" name="account_id" placeholder="Account ID" oninput="onChange('account_id')">
              <div data-error="" class="field-error-message"></div>
            </div>
            <div class="mobile-signup">
              <div data-field-group="referral_code" class="field-group">
                <label>Referral Code (Optional)</label>
                <div class="referral-code-group">
                  <input data-value="" type="text" id="referral_code" name="referral_code" oninput="onChange('referral_code')">
                </div>
                <div data-error="" class="field-error-message"></div>
              </div>
            </div>
            <div class="mobile-signup">
              <div data-field-group="consent" class="field-group">
                <div class="consent-group">
                  <label for="consent">
                    <div style="display:flex">
                      <div style="width: 20px;">
                        <input data-value="" type="checkbox" id="consent_received_marketing_communications" name="consent">
                      </div>
                      <div style="margin-top: 0px;">I consent &amp; agree to receive marketing communications from SP Digital.</div>
                    </div>
                  </label>
                </div>
                <div data-error="" class="field-error-message"></div>
              </div>
            </div>
            <div class="alert-danger" style="margin-bottom: 0;">
              <strong>Error! </strong>
              <span data-form-error-message=""></span>
            </div>
            <div class="captcha-container captcha-container-signup"></div>
            <button data-submit="" class="submit-btn" type="submit" style="margin-top: 16px;">
              <div class="loader"></div>Submit
            </button>
            <div class="mobile-signup">
              <div class="field-group" style="text-align: center; margin-top: 10px;">
                <label>
                  By clicking submit, I agree to the <a href="./html/app.html">Terms and Conditions</a>
                </label>
              </div>
              <div style="width: 100%; border-bottom: 1px solid #ccc; text-align: center; position: relative; margin-bottom: 22px;">
                <span style="font-size: 12px; background-color: #fff; padding: 0 20px; position: absolute; top: -7px; margin-left: -20px;">
                  or
                </span>
              </div>
              <div style="text-align: center; margin-top: 10px; margin-bottom: 20x;">
                <a href="./html/welcome.html">Sign up for a company account</a>
              </div>
            </div>
          </form>
        </div>
      </div>
    </div>

    <div id="license">© 2025 SP Group. All Rights Reserved.</div>
  </div>

  <script src="./scripts/lock.min.js"></script>
  <script src="./scripts/auth0.min.js"></script>
  <script src="./scripts/object-assign.min.js"></script>

  <script>
    window.onload = function() {
      printLicense();
    }

    function printLicense() {
      const licenseTag = document.getElementById("license");
      if (licenseTag) {
        const currentYear = new Date().getFullYear();
        licenseTag.innerText = "© " + currentYear + " SP Group. All Rights Reserved.";
      }
    }

    const UPortalClientID = "0I6XpXThehIU3SgaSbzraCgekkHg2rJH";
    const AdminPortalClientID = "DpkgYnAg4gx3crs8yUzMLNrpF6QsxaoW";
    const ProfileWebClientID = "FZFbQUAOTUhWAM3BPXR9g6FUeppkLWVt";
    const UPIOSMobileAppClientID = "Pjgim4SdX5Vx2yHjFIMSM8IeMXE1cWv6";
    const UPAndroidMobileAppClientID = "z1tl6I1V6HI201ule9tmSALb97hw8Biu";
    const successfulAccountCreationMsg = "Successful account registration. Please verify your email before logging in.";
    const verifyEmailMsg = "Sent you a verification email. Please verify your email before logging in.";

    function changeScreen(screenKey) {
      if(screenKey === "signup") {
        document.body.classList.add("signup");
      } else {
        document.body.classList.remove("signup");
      }
      // Removing logo only if this is login page
      const headerLogoTag = document.getElementById("header-logo");
      if (screenKey === "login") {
        headerLogoTag.style.display = "none";
      } else {
        headerLogoTag.style.display = "block"
      }

      clearForm(screenKey);
      const screensElm = document.querySelectorAll("[data-screen]");
      for (let i = 0; i < screensElm.length; i++) {
        if (screensElm[i].getAttribute("data-screen") === screenKey) {
          screensElm[i].classList.add("visible");
        } else {
          screensElm[i].classList.remove("visible");
        }
      }
      handleAutoFocus(screenKey);
    }

    function handleAutoFocus(screenKey) {
      const screenElm = document.querySelector(`[data-screen=${screenKey}]`);
      screenElm.querySelector("[data-value]").focus();
    }

    function initScreen() {
      const params = new URLSearchParams(location.search);
      if(window.isFromMobileSignUp) {
        changeScreen("signup");
        document.getElementById('step_1_of_2_text').style.display = 'none';
        if(config.extraParams && config.extraParams.referral_code_hint) {
          document.getElementsByName("referral_code")[0].value = config.extraParams.referral_code_hint
        }
        window.captcha = webAuth.renderCaptcha(
          document.querySelector('.captcha-container-signup')
        );
        document.body.classList.add("mobile-signup");
      } else if (params.get("screen_hint") === "signup" && config.clientID === UPortalClientID) {
        changeScreen("signup");
        window.captcha = webAuth.renderCaptcha(
          document.querySelector('.captcha-container-signup')
        );
      } else if (params.get("screen_hint") === "forgot_password") {
        changeScreen("forgot-password");
      } else {
        changeScreen("login");
        if(config.extraParams && config.extraParams.login_hint) {
          document.getElementsByName("email")[0].value = config.extraParams.login_hint;
        }
        if(config.extraParams && config.extraParams.hide_forgot_password_link) {
          document.getElementById("forgot_password").style.display = 'none';
        }
        window.captcha = webAuth.renderCaptcha(
          document.querySelector('.captcha-container-login')
        );

        let loginMessage = new URLSearchParams(document.location.search).get("login_message");
        let displayedLoginMessage = "";
        if (loginMessage === "successful_account_registration") {
          displayedLoginMessage = successfulAccountCreationMsg;
        }
        if (loginMessage === "verify_email_msg") {
          displayedLoginMessage = verifyEmailMsg;
        }

        const screenElm = document.querySelector("[data-screen=login]");
        if (screenElm.querySelector("[data-login-message]") && displayedLoginMessage !== "") {
          displaySuccessMessage(
            displayedLoginMessage,
            screenElm.querySelector("[data-login-message]")
          );
        }
      }
    }

    let webAuth;
    let config;
    window.addEventListener('load', function() {
      config = JSON.parse(
        decodeURIComponent(escape(window.atob('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')))
      );

      window.isFromMobileSignUp = config.extraParams.mobile_signup_hint === 'true';
      if (typeof(Storage) !== "undefined") {
        localStorage.setItem("login_query", document.location.search);
      }

      // Change forgot password description if it is UPortal
      var forgotPasswordDescriptionElID = "";
      if(UPortalClientID === config.clientID) {
        forgotPasswordDescriptionElID = "uportal_forgot_password_description";
      } else {
        forgotPasswordDescriptionElID = "common_forgot_password_description";
      }

      var forgotPasswordDescription = document.getElementById(forgotPasswordDescriptionElID);
      if (forgotPasswordDescription) {
        forgotPasswordDescription.style.display = "block";
      }
      // end

      // Fill client_ids used in new login page
      const allowedClients = [
        UPortalClientID,
        AdminPortalClientID,
        ProfileWebClientID,
        UPAndroidMobileAppClientID,
        UPIOSMobileAppClientID
      ];
      if (allowedClients.includes(config.clientID)) {
        // Render new login page
        const frameElm = document.getElementById("frame");
        if (frameElm) {
          frameElm.style.display = "flex";
        }
        // Hidden auth0 Lock page
        const auth0LockElm = document.getElementById("auth0-lock-container-1");
        if (auth0LockElm) {
          auth0LockElm.parentElement.removeChild(auth0LockElm);
        }
        // Show only forgot email link by UPortal
        if (config.clientID !== UPortalClientID) {
          const forgotPasswordLink = document.getElementById("forgot_email-btn");
          forgotPasswordLink.parentElement.removeChild(forgotPasswordLink);
        }
        var params = Object.assign({
          overrides: {
            __tenant: config.auth0Tenant,
            __token_issuer: config.authorizationServer.issuer
          },
          domain: document.domain,
          clientID: config.clientID,
          redirectUri: config.callbackURL,
          responseType: 'code'
        }, config.internalOptions);

        if (isFromMobileSignUp) {
          params.maxAge = 0;
        }

        webAuth = new auth0.WebAuth(params);
        initScreen();

      } else {
        // Hidden new login page
        const frameElm = document.getElementById("frame");
        if (frameElm) {
          frameElm.parentElement.removeChild(frameElm);
        }

        config.extraParams = config.extraParams || {};
        var connection = config.connection;
        var prompt = config.prompt;
        var languageDictionary;
        var language;
        if (config.dict && config.dict.signin && config.dict.signin.title) {
          // Fix the title of the login page to the company name
          languageDictionary = { title: "Login" };
        } else if (typeof config.dict === "string") {
          language = config.dict;
        }
        var loginHint = config.extraParams.login_hint;
        var allowedSignUpClientID = "7OYWG3BN7bA4kAJ66hYFawZvyRV6OU3n"; //byob
        function startAuth0Lock(options) {
          var lock = new Auth0Lock(config.clientID, document.domain, {
            auth: {
              redirectUrl: config.callbackURL,
              responseType:
                (config.internalOptions || {}).response_type ||
                (config.callbackOnLocationHash ? "token" : "code"),
              params: config.internalOptions
            },
            assetsUrl: config.assetsUrl,
            allowedConnections: connection ? [connection] : null,
            rememberLastLogin: !prompt,
            language: language,
            languageDictionary: languageDictionary,
            theme: {
              logo: "https://assets.spdigital.sg/img/spgroup/spgroup-logo_v1_0.svg",
              primaryColor: "#00b0b2"
            },
            allowSignUp: allowedSignUpClientID === config.clientID,
            prefill: loginHint ? { email: loginHint, username: loginHint } : null,
            closable: false,
            defaultADUsernameFromEmailPrefix: false,
            defaultDatabaseConnection: "Username-Password-Authentication",
            overrides: {
            	__tenant: config.auth0Tenant,
            	__token_issuer: config.authorizationServer.issuer
          	}
            // uncomment if you want small buttons for social providers
            // socialButtonStyle: 'small'
          });
          lock.on("authorization_error", function(error) {
            var containers = document.getElementsByClassName(
              "auth0-lock-container"
            );
            for (var i = 0; i < containers.length; i++) {
              containers[i].remove();
            }
            startAuth0Lock({
              flashMessage: {
                type: "error",
                text: error.description
              }
            });
          });
          lock.show(options);
        }

        startAuth0Lock({});
      }
    })

    // Validate email input
    function onChangeEmail(e) {
      const emailElm = e.target;
      if (IsValidEmail(emailElm.value)) {
        displayFieldError("", emailElm.parentElement);
      }
    }

    // Validate password input
    function onChangePassword(e) {
      const passwordElm = e.target;
      if (passwordElm.value) {
        displayFieldError("", passwordElm.parentElement);
      }
    }

    function IsValidEmail(input){
      var RE = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
      return (RE.test(input));
    }

    function IsValidPhoneNumberSG(input){
      var RE = /^\+65(6|8|9)\d{7}$/
      return (RE.test(input));
    }

    // https://www.w3resource.com/javascript/form/password-validation.php
    function IsValidPassword(input) {
      var RE = /^(?=.*\d)(?=.*[a-z])(?=.*[A-Z]).{8,50}$/;
      return (RE.test(input));
    }

    // When click submit login form
    function submitLogin(e) {
      e.preventDefault();
      const screenKey = "login";
      const screenElm = document.querySelector(`[data-screen=${screenKey}]`);
      let valid = true;
      let values = {
        email: "",
        password: ""
      };

      const passwordFieldGroup = screenElm.querySelector("[data-field-group=password]");
      if (passwordFieldGroup) {
        const input = passwordFieldGroup.querySelector("[data-value]");
        values = { ...values, password: input.value };
        if (input.value) {
          displayFieldError("", passwordFieldGroup);
        } else {
          displayFieldError("This field is required.", passwordFieldGroup);
          valid = false;
        }
      }

      const emailFieldGroup = screenElm.querySelector("[data-field-group=email]");
      if (emailFieldGroup) {
        const input = emailFieldGroup.querySelector("[data-value]");
        values = { ...values, email: input.value };
        if (IsValidEmail(input.value)) {
          displayFieldError("", emailFieldGroup);
        } else {
          displayFieldError("Please enter a valid email address.", emailFieldGroup);
          valid = false;
        }
      }
      if (valid) {
        setLoading(true, screenElm.querySelector("[data-submit]"));
        login(values, screenElm);
      }
    }

    function displayFieldError(error, fieldGroupElm) {
      if (!fieldGroupElm) return;
      const inputElm = fieldGroupElm.querySelector("[data-value]");
      const errorElm = fieldGroupElm.querySelector("[data-error]");
      if (!inputElm || !errorElm) return;

      if (!!error) {
        errorElm.innerText = error;
        fieldGroupElm.classList.add("is-error");
        inputElm.focus();
      } else {
        errorElm.innerText = "";
        fieldGroupElm.classList.remove("is-error");
      }
    }

    function displayFormError(err, formErrorMessageElm) {
      if (err) {
        formErrorMessageElm.innerHTML = htmlEncode(err);
        formErrorMessageElm.parentElement.style.display = "block";
      } else {
        formErrorMessageElm.innerHTML = "";
        formErrorMessageElm.parentElement.style.display = "none";
      }
    }

    // Set loading for submit button
    function setLoading(loading, submitElm) {
      if (loading) {
        submitElm.classList.add("loading");
        submitElm.disabled = true;
      } else {
        submitElm.classList.remove("loading");
        submitElm.disabled = false;
      }
    }

    // Call api auth0 to handle login
    function login({ email, password }, screenElm) {
      var databaseConnection = config.connection;
      if (!databaseConnection) {
        databaseConnection = 'Username-Password-Authentication';
      }

      const params = new URLSearchParams(document.location.search);
      var forceMFA = params.get("force_mfa") == "true";
      webAuth.login({
        realm: databaseConnection,
        username: email,
        password: password,
        captcha: window.captcha.getValue(),
        force_mfa: forceMFA
      }, function(err) {
        if (err) {
          clearForm("login");
          handleAutoFocus("login");
          let errDescription = err.description;
          if (!errDescription && err.original && err.original.response && err.original.response.body && err.original.response.body.message) {
            const bodyMessage = err.original.response.body.message
            switch (bodyMessage) {
              case "NEW_EMAIL_UNVERIFIED":
                errDescription = "New email has not been verified. Please check your inbox and verify your email or login with your old email to re-trigger the verification email.";
                break;
              default:
                errDescription = bodyMessage;
            }
          }
          displayFormError(errDescription, screenElm.querySelector("[data-form-error-message]"));
          window.captcha.reload()
          setLoading(false, screenElm.querySelector("[data-submit]"));
        }
      });
    }

    // Clear all input value and focus on first input when change screen
    function clearForm(screenKey) {
      const screenElm = document.querySelector(`[data-screen=${screenKey}]`)
      if (screenElm) {
        const fieldGroups = screenElm.querySelectorAll("[data-field-group]");
        for (let i = 0; i < fieldGroups.length; i++) {
          const inputElm = fieldGroups[i].querySelector("[data-value]");
          if (inputElm) inputElm.value = "";
          displayFieldError("", fieldGroups[i]);
        }
      }
      if (screenElm.querySelector("[data-form-error-message]")) {
        displayFormError("", screenElm.querySelector("[data-form-error-message]"));
      }
      if (screenElm.querySelector("[data-success-message]")) {
        displaySuccessMessage("", screenElm.querySelector("[data-success-message]"));
      }
      enableSubmitBtn(false);
    }

    // Validate email input in forgot password form
    function onChangeEmail2(e) {
      const emailElm = e.target;
      if (IsValidEmail(emailElm.value)) {
        displayFieldError("", emailElm.parentElement);
      }
      if (emailElm.value) {
        enableSubmitBtn(true);
      } else {
        enableSubmitBtn(false);
      }
    }

    // Enabled submit button if a valid email is entered
    function enableSubmitBtn(enable) {
      const screenKey = "forgot-password";
      const screenElm = document.querySelector(`[data-screen=${screenKey}]`);
      const submitElm = screenElm.querySelector("[data-submit]");
      if (enable) {
        submitElm.disabled = false;
        submitElm.classList.remove("disable-btn");
      } else {
        submitElm.disabled = true;
        submitElm.classList.add("disable-btn");
      }
    }

    // When click submit forgot password form
    function submitForgotPassword(e) {
      e.preventDefault();
      const screenKey = "forgot-password";
      const screenElm = document.querySelector(`[data-screen=${screenKey}]`);
      const emailFieldGroupElm = screenElm.querySelector("[data-field-group]");
      if (emailFieldGroupElm) {
        const input = emailFieldGroupElm.querySelector("[data-value]");

        // Trim the email before validating
        if (input.value) {
          input.value = String(input.value).trim();
        }

        if (IsValidEmail(input.value)) {
          displayFieldError("", emailFieldGroupElm);
          setLoading(true, screenElm.querySelector("[data-submit]"));
          forgotPassword(input.value, screenElm);
        } else {
          displayFieldError("Please enter a valid email address.", emailFieldGroupElm);
        }
      }
    }

    // Call api auth0 to create a ticket with forgotten password
    function forgotPassword(email, screenElm) {
      var databaseConnection = config.connection;
      if (!databaseConnection) {
        databaseConnection = 'Username-Password-Authentication';
      }
      webAuth.changePassword({
        connection: databaseConnection,
        email: email
      }, function (err, resp) {
        if(err) {
          displayFormError(err.message, screenElm.querySelector("[data-form-error-message]"));
          displaySuccessMessage("", screenElm.querySelector("[data-success-message]"));
          setLoading(false, screenElm.querySelector("[data-submit]"));
          enableSubmitBtn(true);
        } else {
          displayFormError("", screenElm.querySelector("[data-form-error-message]"));
          displaySuccessMessage(resp, screenElm.querySelector("[data-success-message]"));
          setLoading(false, screenElm.querySelector("[data-submit]"));
          enableSubmitBtn(true);
        }
      });
    }

    function onChange(fieldGroupKey) {
      const fieldGroupElm = document.querySelector("[data-screen=signup]").querySelector(`[data-field-group=${fieldGroupKey}]`);
      const inputElm = fieldGroupElm.querySelector("[data-value]");
      if (fieldGroupKey === "email") {
        if (IsValidEmail(inputElm.value)) {
          displayFieldError("", fieldGroupElm);
        }
      } else if (fieldGroupKey === "mobile") {
        const countryCodeElm = document.getElementById("country-code");
        const phoneNumber = String(countryCodeElm.value).trim() + String(inputElm.value).trim();
        if (IsValidPhoneNumberSG(phoneNumber)) {
          displayFieldError("", fieldGroupElm);
        }
      } else if (fieldGroupKey === "password") {
        if (IsValidPassword(inputElm.value)) {
          displayFieldError("", fieldGroupElm);
        }
      } else {
        if (inputElm.value) {
          displayFieldError("", fieldGroupElm);
        }
      }
    }

    function submitSignUp(e) {
      e.preventDefault();
      const screenElm = document.querySelector("[data-screen=signup]");
      let values = {
        number: "",
        name: "",
        password: "",
        email: "",
        account_id: ""
      };

      const emailGroupElm = screenElm.querySelector("[data-field-group=email]");
      if (emailGroupElm) {
        const input = emailGroupElm.querySelector("[data-value]");
        values = { ...values, email: input.value.trim() };
        if (IsValidEmail(input.value)) {
          displayFieldError("", emailGroupElm);
        } else {
          displayFieldError("Please enter a valid email address.", emailGroupElm);
          return;
        }
      }

      const passwordGroupElm = screenElm.querySelector("[data-field-group=password]");
      if (passwordGroupElm) {
        const input = passwordGroupElm.querySelector("[data-value]");
        values = { ...values, password: input.value.trim() };
        if (IsValidPassword(input.value)) {
          displayFieldError("", passwordGroupElm);
        } else {
          displayFieldError("At least 8 characters in length; Contain at least 3 of the following 4 types of characters: lower case letters (a-z), upper case letters (A-Z), numbers (i.e. 0-9), special characters (e.g !@#$%^&*).", passwordGroupElm);
          return;
        }
      }

      const fullNameGroupElm = screenElm.querySelector("[data-field-group=full_name]");
      if (fullNameGroupElm) {
        const input = fullNameGroupElm.querySelector("[data-value]");
        values = { ...values, name: input.value.trim() };
        if (input.value) {
          displayFieldError("", fullNameGroupElm);
        } else {
          displayFieldError("This field is required.", fullNameGroupElm);
          return;
        }
      }

      const mobileGroupElm = screenElm.querySelector("[data-field-group=mobile]");
      if (mobileGroupElm) {
        const input = mobileGroupElm.querySelector("[data-value]");
        const countryCodeElm = document.getElementById("country-code");
        const phoneNumberWithoutCountryCode = String(input.value).trim();
        const phoneNumber = String(countryCodeElm.value).trim() + phoneNumberWithoutCountryCode;
        values = { ...values, number: phoneNumberWithoutCountryCode };
        if (IsValidPhoneNumberSG(phoneNumber)) {
          displayFieldError("", mobileGroupElm);
        } else {
          displayFieldError("Please provide a valid mobile number.", mobileGroupElm);
          return;
        }
      }

      const accountIDGroupElm = screenElm.querySelector("[data-field-group=account_id]");
      if (accountIDGroupElm) {
        const input = accountIDGroupElm.querySelector("[data-value]");
        values = { ...values, account_id: input.value || input.getAttribute("value") || "" };
      }

      signUp(values, screenElm);
    }

    function signUp(values, screenElm) {
      const submitElm = screenElm.querySelector("[data-submit]");
      setLoading(true, submitElm);

      const { email, password, name, number, account_id } = values;

      user_metadata = {
        name: name,
        number: number
      }
      if (account_id !== "") {
        user_metadata.account_id = account_id
      }

      if(window.isFromMobileSignUp) {
        const checkAgreeToReceiveMarketingCommunincations = document.getElementById("consent_received_marketing_communications").checked;
        user_metadata.referral_code = document.getElementById("referral_code").value;
        user_metadata.signup_sub_email_marketing = checkAgreeToReceiveMarketingCommunincations + "";
        user_metadata.signup_sub_push_marketing = checkAgreeToReceiveMarketingCommunincations + "";
      }

      const hasFilledInAccountID = !!account_id;
      if (hasFilledInAccountID) {
        webAuth.client.dbConnection.signup({
          connection: "Username-Password-Authentication",
          email: email,
          password: password,
          name: name,
          number: number,
          captcha: window.captcha.getValue(),
          user_metadata: user_metadata
        }, function(err, data) {
          if (err) {
            setLoading(false, submitElm);
            displayFormError(err.description, screenElm.querySelector("[data-form-error-message]"));
            window.captcha.reload();
          } else {
            setLoading(false, submitElm);
            displayFormError("", screenElm.querySelector("[data-form-error-message]"));
            document.location.href = "https://services.spservices.sg"
          }
        });
      } else {
        const clientIDsForPreventUserFromBeingLoginAfterSignedUp = [
          UPortalClientID
        ]
        /*
          Prevent unverified user email from logging in automatically
          after successful signed up.
        */
        if (clientIDsForPreventUserFromBeingLoginAfterSignedUp.includes(config.clientID)) {
          webAuth.client.dbConnection.signup({
            connection: "Username-Password-Authentication",
            email: email,
            password: password,
            name: name,
            number: number,
            captcha: window.captcha.getValue(),
            user_metadata: user_metadata
          }, function(err, data) {
            if (err) {
              setLoading(false, submitElm);
              displayFormError(err.description, screenElm.querySelector("[data-form-error-message]"));
              window.captcha.reload();
            } else {
              setLoading(false, submitElm);
              displayFormError("", screenElm.querySelector("[data-form-error-message]"));
              const params = new URLSearchParams(document.location.search);
              if (params.get("screen_hint") === "signup") {
                params.delete("screen_hint");
              }
              params.set("login_message", "successful_account_registration");
              document.location.search = params.toString();
            }
          });
        } else {
          webAuth.redirect.signupAndLogin({
            connection: "Username-Password-Authentication",
            email: email,
            password: password,
            name: name,
            number: number,
            captcha: window.captcha.getValue(),
            user_metadata: user_metadata
          }, function(err, data) {
            if (err) {
              setLoading(false, submitElm);
              displayFormError(err.description, screenElm.querySelector("[data-form-error-message]"));
              window.captcha.reload();
            } else {
              setLoading(false, submitElm);
              displayFormError("", screenElm.querySelector("[data-form-error-message]"));
            }
          });
        }
      }
    }

    function displaySuccessMessage(message, successMessageElm) {
      if (!successMessageElm) return;
      if (message) {
        successMessageElm.innerHTML = htmlEncode(message);
        successMessageElm.parentElement.style.display = "block";
      } else {
        successMessageElm.innerHTML = "";
        successMessageElm.parentElement.style.display = "none";
      }
    }

    function htmlEncode(str){
        return String(str).replace(/[^\w. ]/gi, function(c){
            return '&#'+c.charCodeAt(0)+';';
        });
    }
  </script>


</body></html>